/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.utils.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageEncoder.class, (String)"I");
    }

    protected MessageToMessageEncoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptOutboundMessage(Object o) {
        return this.matcher.match(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ChannelHandlerContext channelHandlerContext, Object o, ChannelPromise channelPromise) {
        RecyclableArrayList instance = null;
        try {
            if (this.acceptOutboundMessage(o)) {
                instance = RecyclableArrayList.newInstance();
                try {
                    this.encode(channelHandlerContext, o, (List<Object>)instance);
                }
                finally {
                    ReferenceCountUtil.release((Object)o);
                }
                if (instance.isEmpty()) {
                    instance.recycle();
                    instance = null;
                    channelPromise.setSuccess();
                }
            } else {
                channelHandlerContext.write(o, channelPromise);
            }
            if (instance == null) return;
        }
        catch (EncoderException ex) {
            try {
                throw ex;
                catch (Throwable t) {
                    throw new EncoderException(t);
                }
            }
            catch (Throwable throwable) {
                if (instance == null) throw throwable;
                int n = instance.size() - 1;
                if (n == 0) {
                    channelHandlerContext.write(instance.get(0), channelPromise);
                } else if (n > 0) {
                    ChannelPromise voidPromise = channelHandlerContext.voidPromise();
                    boolean b = channelPromise == voidPromise;
                    for (int i = 0; i < n; ++i) {
                        ChannelPromise promise = b ? voidPromise : channelHandlerContext.newPromise();
                        channelHandlerContext.write(instance.get(i), promise);
                    }
                    channelHandlerContext.write(instance.get(n), channelPromise);
                }
                instance.recycle();
                throw throwable;
            }
        }
        int n = instance.size() - 1;
        if (n == 0) {
            channelHandlerContext.write(instance.get(0), channelPromise);
        } else if (n > 0) {
            ChannelPromise voidPromise = channelHandlerContext.voidPromise();
            boolean b = channelPromise == voidPromise;
            for (int i = 0; i < n; ++i) {
                ChannelPromise promise = b ? voidPromise : channelHandlerContext.newPromise();
                channelHandlerContext.write(instance.get(i), promise);
            }
            channelHandlerContext.write(instance.get(n), channelPromise);
        }
        instance.recycle();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

