/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.pingresponse;

import java.lang.reflect.Type;
import java.util.UUID;
import protocolsupport.libs.com.google.gson.JsonArray;
import protocolsupport.libs.com.google.gson.JsonDeserializationContext;
import protocolsupport.libs.com.google.gson.JsonDeserializer;
import protocolsupport.libs.com.google.gson.JsonElement;
import protocolsupport.libs.com.google.gson.JsonObject;
import protocolsupport.libs.com.google.gson.JsonParseException;
import protocolsupport.libs.com.google.gson.JsonSerializationContext;
import protocolsupport.libs.com.google.gson.JsonSerializer;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.utils.JsonUtils;

public class PingResponsePlayers {
    private int max;
    private int online;
    private GameProfile[] players;

    public PingResponsePlayers() {
    }

    public PingResponsePlayers(int max, int online) {
        this.max = max;
        this.online = online;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getOnline() {
        return this.online;
    }

    public void setOnline(int online) {
        this.online = online;
    }

    public boolean hasPlayers() {
        return this.players != null && this.players.length > 0;
    }

    public GameProfile[] getPlayers() {
        return this.players;
    }

    public void setPlayers(GameProfile[] players) {
        this.players = players;
    }

    public static class Serializer
    implements JsonDeserializer<PingResponsePlayers>,
    JsonSerializer<PingResponsePlayers> {
        @Override
        public PingResponsePlayers deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonArray jsonArray;
            JsonObject jsonObject = JsonUtils.getObject(jsonElement, "players");
            PingResponsePlayers players = new PingResponsePlayers(JsonUtils.getInt(jsonObject, "max"), JsonUtils.getInt(jsonObject, "online"));
            if (JsonUtils.isJsonArray(jsonObject, "sample") && (jsonArray = JsonUtils.getJsonArray(jsonObject, "sample")).size() > 0) {
                GameProfile[] array = new GameProfile[jsonArray.size()];
                for (int i = 0; i < array.length; ++i) {
                    JsonObject playerJsonObject = JsonUtils.getObject(jsonArray.get(i), "player[" + i + "]");
                    array[i] = new GameProfile(UUID.fromString(JsonUtils.getString(playerJsonObject, "id")), JsonUtils.getString(playerJsonObject, "name"));
                }
                players.setPlayers(array);
            }
            return players;
        }

        @Override
        public JsonElement serialize(PingResponsePlayers players, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("max", players.getMax());
            jsonObject.addProperty("online", players.getOnline());
            if (players.hasPlayers()) {
                JsonArray jsonArray = new JsonArray();
                for (int i = 0; i < players.getPlayers().length; ++i) {
                    GameProfile player = players.getPlayers()[i];
                    JsonObject playerJsonObject = new JsonObject();
                    playerJsonObject.addProperty("id", player.getUUID() == null ? "" : player.getUUID().toString());
                    playerJsonObject.addProperty("name", player.getName());
                    jsonArray.add(playerJsonObject);
                }
                jsonObject.add("sample", jsonArray);
            }
            return jsonObject;
        }
    }
}

