/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import protocolsupport.api.chat.ChatAPI;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.libs.gnu.trove.map.hash.TIntObjectHashMap;
import protocolsupport.protocol.typeremapper.watchedentity.types.WatchedEntity;
import protocolsupport.protocol.typeremapper.watchedentity.types.WatchedPlayer;
import protocolsupport.protocol.utils.types.WindowType;

public class NetworkDataCache {
    private double x;
    private double y;
    private double z;
    private int teleportConfirmId;
    private WindowType windowType = WindowType.PLAYER;
    private final TIntObjectHashMap<WatchedEntity> watchedEntities = new TIntObjectHashMap();
    private final TIntObjectHashMap<Byte> watchedEntitiesBaseFlags = new TIntObjectHashMap();
    private WatchedPlayer player;
    private final HashMap<UUID, PlayerListEntry> playerlist = new HashMap();
    private int dimensionId;
    private float maxHealth = 20.0f;

    public boolean isTeleportConfirmNeeded() {
        return this.teleportConfirmId != -1;
    }

    public int tryTeleportConfirm(double x, double y, double z) {
        if (Double.doubleToLongBits(this.x) == Double.doubleToLongBits(x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(y) && Double.doubleToLongBits(this.z) == Double.doubleToLongBits(z)) {
            int r = this.teleportConfirmId;
            this.teleportConfirmId = -1;
            return r;
        }
        return -1;
    }

    public boolean tryTeleportConfirm(int teleportId) {
        if (teleportId == this.teleportConfirmId) {
            this.teleportConfirmId = -1;
            return true;
        }
        return false;
    }

    public void setTeleportLocation(double x, double y, double z, int teleportConfirmId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.teleportConfirmId = teleportConfirmId;
    }

    public void setOpenedWindow(WindowType windowType) {
        this.windowType = windowType;
    }

    public WindowType getOpenedWindow() {
        return this.windowType;
    }

    public void closeWindow() {
        this.windowType = WindowType.PLAYER;
    }

    public void addWatchedEntity(WatchedEntity entity) {
        this.watchedEntities.put(entity.getId(), entity);
    }

    public void addWatchedSelfPlayer(WatchedPlayer player) {
        this.player = player;
        this.addWatchedEntity(player);
    }

    public void addWatchedEntityBaseMeta(int entityId, byte flags) {
        this.watchedEntitiesBaseFlags.put(entityId, flags);
    }

    public int getSelfPlayerEntityId() {
        return this.player != null ? this.player.getId() : -1;
    }

    private void readdSelfPlayer() {
        if (this.player != null) {
            this.addWatchedEntity(this.player);
        }
    }

    public WatchedEntity getWatchedEntity(int entityId) {
        return this.watchedEntities.get(entityId);
    }

    public byte getWatchedEntityBaseMeta(int entityId) {
        Byte ret = this.watchedEntitiesBaseFlags.get(entityId);
        return ret == null ? (byte)0 : ret;
    }

    public void removeWatchedEntities(int[] entityIds) {
        for (int entityId : entityIds) {
            this.watchedEntities.remove(entityId);
            this.watchedEntitiesBaseFlags.remove(entityId);
        }
        this.readdSelfPlayer();
    }

    public void clearWatchedEntities() {
        this.watchedEntities.clear();
        this.readdSelfPlayer();
    }

    public void addPlayerListEntry(UUID uuid, PlayerListEntry entry) {
        this.playerlist.put(uuid, entry);
    }

    public PlayerListEntry getPlayerListEntry(UUID uuid) {
        return this.playerlist.get(uuid);
    }

    public void removePlayerListEntry(UUID uuid) {
        this.playerlist.remove(uuid);
    }

    public void setDimensionId(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public boolean hasSkyLightInCurrentDimension() {
        return this.dimensionId == 0;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public static class PlayerListEntry
    implements Cloneable {
        private final String name;
        private String displayNameJson;
        private final PropertiesStorage propstorage = new PropertiesStorage();

        public PlayerListEntry(String name) {
            this.name = name;
        }

        public void setDisplayNameJson(String displayNameJson) {
            this.displayNameJson = displayNameJson;
        }

        public PropertiesStorage getProperties() {
            return this.propstorage;
        }

        public String getUserName() {
            return this.name;
        }

        public String getName() {
            return this.displayNameJson == null ? this.name : ChatAPI.fromJSON(this.displayNameJson).toLegacyText();
        }

        public PlayerListEntry clone() {
            PlayerListEntry clone = new PlayerListEntry(this.name);
            clone.displayNameJson = this.displayNameJson;
            for (PlayerPropertiesResolveEvent.ProfileProperty property : this.propstorage.getAll(false)) {
                clone.propstorage.add(property);
            }
            return clone;
        }
    }

    public static class PropertiesStorage {
        private final HashMap<String, PlayerPropertiesResolveEvent.ProfileProperty> signed = new HashMap();
        private final HashMap<String, PlayerPropertiesResolveEvent.ProfileProperty> unsigned = new HashMap();

        public void add(PlayerPropertiesResolveEvent.ProfileProperty property) {
            if (property.hasSignature()) {
                this.signed.put(property.getName(), property);
            } else {
                this.unsigned.put(property.getName(), property);
            }
        }

        public List<PlayerPropertiesResolveEvent.ProfileProperty> getAll(boolean signedOnly) {
            if (signedOnly) {
                return new ArrayList<PlayerPropertiesResolveEvent.ProfileProperty>(this.signed.values());
            }
            ArrayList<PlayerPropertiesResolveEvent.ProfileProperty> properties = new ArrayList<PlayerPropertiesResolveEvent.ProfileProperty>();
            properties.addAll(this.signed.values());
            properties.addAll(this.unsigned.values());
            return properties;
        }
    }
}

