/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.api.events.ItemStackWriteEvent;
import protocolsupport.protocol.typeremapper.id.RemappingTable;
import protocolsupport.protocol.typeremapper.itemstack.ItemStackRemapper;
import protocolsupport.protocol.utils.types.MerchantData;
import protocolsupport.protocol.utils.types.Position;
import protocolsupport.utils.netty.WrappingBuffer;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.itemstack.ItemStackWrapper;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;

public class ProtocolSupportPacketDataSerializer
extends WrappingBuffer {
    protected ProtocolVersion version;

    public ProtocolSupportPacketDataSerializer(ByteBuf buf, ProtocolVersion version) {
        this.buf = buf;
        this.version = version;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public int readVarInt() {
        return ProtocolSupportPacketDataSerializer.readVarInt(this);
    }

    public void writeVarInt(int varint) {
        ProtocolSupportPacketDataSerializer.writeVarInt(this, varint);
    }

    public long readVarLong() {
        byte part;
        long varlong = 0L;
        int length = 0;
        do {
            part = this.readByte();
            varlong |= (long)((part & 0x7F) << length++ * 7);
            if (length <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((part & 0x80) == 128);
        return varlong;
    }

    public void writeVarLong(long varlong) {
        while ((varlong & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(varlong & 0x7FL) | 0x80);
            varlong >>>= 7;
        }
        this.writeByte((int)varlong);
    }

    public <T extends Enum<T>> T readEnum(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[this.readVarInt()];
    }

    public void writeEnum(Enum<?> e) {
        this.writeVarInt(e.ordinal());
    }

    public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public String readString() {
        return this.readString(Short.MAX_VALUE);
    }

    public String readString(int limit) {
        if (this.getVersion().isBeforeOrEq(ProtocolVersion.MINECRAFT_1_6_4)) {
            int length = this.readUnsignedShort() * 2;
            this.checkLimit(length, limit * 4);
            return new String(ProtocolSupportPacketDataSerializer.toArray(this.readSlice(length)), StandardCharsets.UTF_16BE);
        }
        int length = this.readVarInt();
        this.checkLimit(length, limit * 4);
        return new String(ProtocolSupportPacketDataSerializer.toArray(this.readSlice(length)), StandardCharsets.UTF_8);
    }

    public void writeString(String string) {
        if (this.getVersion().isBeforeOrEq(ProtocolVersion.MINECRAFT_1_6_4)) {
            this.writeShort(string.length());
            this.writeBytes(string.getBytes(StandardCharsets.UTF_16BE));
        } else {
            byte[] data = string.getBytes(StandardCharsets.UTF_8);
            this.writeVarInt(data.length);
            this.writeBytes(data);
        }
    }

    public Position readPosition() {
        return Position.fromLong(this.readLong());
    }

    public Position readLegacyPositionB() {
        return new Position(this.readInt(), this.readUnsignedByte(), this.readInt());
    }

    public Position readLegacyPositionS() {
        return new Position(this.readInt(), this.readShort(), this.readInt());
    }

    public Position readLegacyPositionI() {
        return new Position(this.readInt(), this.readInt(), this.readInt());
    }

    public void writePosition(Position position) {
        this.writeLong(position.asLong());
    }

    public void writeLegacyPositionB(Position position) {
        this.writeInt(position.getX());
        this.writeByte(position.getY());
        this.writeInt(position.getZ());
    }

    public void writeLegacyPositionS(Position position) {
        this.writeInt(position.getX());
        this.writeShort(position.getY());
        this.writeInt(position.getZ());
    }

    public void writeLegacyPositionI(Position position) {
        this.writeInt(position.getX());
        this.writeInt(position.getY());
        this.writeInt(position.getZ());
    }

    public byte[] readByteArray() {
        return this.readByteArray(this.readableBytes());
    }

    public byte[] readByteArray(int limit) {
        int size = -1;
        size = this.getVersion().isBeforeOrEq(ProtocolVersion.MINECRAFT_1_7_10) ? (int)this.readShort() : this.readVarInt();
        this.checkLimit(size, limit);
        byte[] array = new byte[size];
        this.readBytes(array);
        return array;
    }

    public void writeByteArray(ByteBuf data) {
        if (this.getVersion().isBeforeOrEq(ProtocolVersion.MINECRAFT_1_7_10)) {
            this.writeShort(data.readableBytes());
        } else {
            this.writeVarInt(data.readableBytes());
        }
        this.writeBytes(data);
    }

    public void writeByteArray(byte[] data) {
        if (this.getVersion().isBeforeOrEq(ProtocolVersion.MINECRAFT_1_7_10)) {
            this.writeShort(data.length);
        } else {
            this.writeVarInt(data.length);
        }
        this.writeBytes(data);
    }

    public ItemStackWrapper readItemStack() {
        short type = this.readShort();
        if (type >= 0) {
            ItemStackWrapper itemstack = ServerPlatform.get().getWrapperFactory().createItemStack(type);
            itemstack.setAmount(this.readByte());
            itemstack.setData(this.readShort());
            itemstack.setTag(this.readTag());
            return ItemStackRemapper.remapServerbound(this.getVersion(), itemstack.cloneItemStack());
        }
        return ServerPlatform.get().getWrapperFactory().createNullItemStack();
    }

    public void writeItemStack(ItemStackWrapper itemstack) {
        if (itemstack.isNull()) {
            this.writeShort(-1);
            return;
        }
        ItemStackWrapper remapped = ItemStackRemapper.remapClientbound(this.getVersion(), itemstack.cloneItemStack());
        if (ItemStackWriteEvent.getHandlerList().getRegisteredListeners().length > 0) {
            InternalItemStackWriteEvent event = new InternalItemStackWriteEvent(this.getVersion(), itemstack, remapped);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        this.writeShort(((RemappingTable.ArrayBasedIdRemappingTable)ItemStackRemapper.ITEM_ID_REMAPPING_REGISTRY.getTable(this.version)).getRemap(remapped.getTypeId()));
        this.writeByte(remapped.getAmount());
        this.writeShort(remapped.getData());
        this.writeTag(remapped.getTag());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NBTTagCompoundWrapper readTag() {
        try {
            if (this.getVersion().isBefore(ProtocolVersion.MINECRAFT_1_8)) {
                short length = this.readShort();
                if (length < 0) {
                    return ServerPlatform.get().getWrapperFactory().createNullNBTCompound();
                }
                try (GZIPInputStream inputstream = new GZIPInputStream((InputStream)new ByteBufInputStream(this.readSlice(length)));){
                    NBTTagCompoundWrapper nBTTagCompoundWrapper = ServerPlatform.get().getWrapperFactory().createNBTCompoundFromStream(inputstream);
                    return nBTTagCompoundWrapper;
                }
            }
            this.markReaderIndex();
            if (this.readByte() == 0) {
                return ServerPlatform.get().getWrapperFactory().createNullNBTCompound();
            }
            this.resetReaderIndex();
            try (DataInputStream datainputstream = new DataInputStream((InputStream)new ByteBufInputStream((ByteBuf)this));){
                NBTTagCompoundWrapper nBTTagCompoundWrapper = ServerPlatform.get().getWrapperFactory().createNBTCompoundFromStream(datainputstream);
                return nBTTagCompoundWrapper;
            }
        }
        catch (IOException e) {
            throw new DecoderException((Throwable)e);
        }
    }

    public void writeTag(NBTTagCompoundWrapper tag) {
        block29: {
            try {
                if (this.getVersion().isBefore(ProtocolVersion.MINECRAFT_1_8)) {
                    if (tag.isNull()) {
                        this.writeShort(-1);
                        break block29;
                    }
                    int writerIndex = this.writerIndex();
                    this.writeShort(0);
                    try (GZIPOutputStream outputstream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream((ByteBuf)this));){
                        tag.writeToStream(outputstream);
                    }
                    this.setShort(writerIndex, this.writerIndex() - writerIndex - 2);
                    break block29;
                }
                if (tag.isNull()) {
                    this.writeByte(0);
                    break block29;
                }
                try (DataOutputStream dataoutputstream = new DataOutputStream((OutputStream)new ByteBufOutputStream((ByteBuf)this));){
                    tag.writeToStream(dataoutputstream);
                }
            }
            catch (Throwable ioexception) {
                throw new EncoderException(ioexception);
            }
        }
    }

    public MerchantData readMerchantData() {
        MerchantData merchdata = new MerchantData(this.readInt());
        int count = this.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            ItemStackWrapper itemstack1 = this.readItemStack();
            ItemStackWrapper result = this.readItemStack();
            ItemStackWrapper itemstack2 = ServerPlatform.get().getWrapperFactory().createNullItemStack();
            if (this.readBoolean()) {
                itemstack2 = this.readItemStack();
            }
            boolean disabled = this.readBoolean();
            int uses = 0;
            int maxuses = 7;
            if (this.getVersion().isAfterOrEq(ProtocolVersion.MINECRAFT_1_8)) {
                uses = this.readInt();
                maxuses = this.readInt();
            }
            merchdata.addOffer(new MerchantData.TradeOffer(itemstack1, itemstack2, result, disabled ? maxuses : uses, maxuses));
        }
        return merchdata;
    }

    public void writeMerchantData(MerchantData merchdata) {
        this.writeInt(merchdata.getWindowId());
        this.writeByte(merchdata.getOffers().size());
        for (MerchantData.TradeOffer offer : merchdata.getOffers()) {
            this.writeItemStack(offer.getItemStack1());
            this.writeItemStack(offer.getResult());
            this.writeBoolean(offer.hasItemStack2());
            if (offer.hasItemStack2()) {
                this.writeItemStack(offer.getItemStack2());
            }
            this.writeBoolean(offer.isDisabled());
            if (!this.getVersion().isAfterOrEq(ProtocolVersion.MINECRAFT_1_8)) continue;
            this.writeInt(offer.getUses());
            this.writeInt(offer.getMaxUses());
        }
    }

    protected void checkLimit(int size, int limit) {
        if (size > limit) {
            throw new DecoderException("Size " + size + " is bigger than allowed " + limit);
        }
    }

    public static byte[] toArray(ByteBuf buf) {
        byte[] result = new byte[buf.readableBytes()];
        buf.readBytes(result);
        return result;
    }

    public static int readVarInt(ByteBuf from) {
        byte part;
        int value = 0;
        int length = 0;
        do {
            part = from.readByte();
            value |= (part & 0x7F) << length++ * 7;
            if (length <= 5) continue;
            throw new DecoderException("VarInt too big");
        } while (part < 0);
        return value;
    }

    public static void writeVarInt(ByteBuf to, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            to.writeByte(i | 0x80);
            i >>>= 7;
        }
        to.writeByte(i);
    }

    public static class InternalItemStackWriteEvent
    extends ItemStackWriteEvent {
        private final ItemStack wrapped;

        public InternalItemStackWriteEvent(ProtocolVersion version, ItemStackWrapper original, ItemStackWrapper itemstack) {
            super(version, original.asBukkitMirror());
            this.wrapped = itemstack.asBukkitMirror();
        }

        @Override
        public ItemStack getResult() {
            return this.wrapped;
        }
    }
}

