/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.middle.clientbound.play;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.libs.gnu.trove.map.TIntObjectMap;
import protocolsupport.protocol.packet.middle.ClientBoundMiddlePacket;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.protocol.storage.NetworkDataCache;
import protocolsupport.protocol.typeremapper.watchedentity.types.WatchedEntity;
import protocolsupport.protocol.typeremapper.watchedentity.types.WatchedPlayer;
import protocolsupport.protocol.utils.datawatcher.DataWatcherDeserializer;
import protocolsupport.protocol.utils.datawatcher.DataWatcherObject;

public abstract class MiddleSpawnNamed<T>
extends ClientBoundMiddlePacket<T> {
    protected int playerEntityId;
    protected UUID uuid;
    protected String name;
    protected double x;
    protected double y;
    protected double z;
    protected int yaw;
    protected int pitch;
    protected List<PlayerPropertiesResolveEvent.ProfileProperty> properties;
    protected WatchedEntity wplayer;
    protected TIntObjectMap<DataWatcherObject<?>> metadata;

    @Override
    public void readFromServerData(ProtocolSupportPacketDataSerializer serializer) {
        this.playerEntityId = serializer.readVarInt();
        this.uuid = serializer.readUUID();
        this.x = serializer.readDouble();
        this.y = serializer.readDouble();
        this.z = serializer.readDouble();
        this.yaw = serializer.readUnsignedByte();
        this.pitch = serializer.readUnsignedByte();
        this.metadata = DataWatcherDeserializer.decodeData(serializer);
    }

    @Override
    public void handle() {
        this.wplayer = new WatchedPlayer(this.playerEntityId);
        this.cache.addWatchedEntity(this.wplayer);
        NetworkDataCache.PlayerListEntry entry = this.cache.getPlayerListEntry(this.uuid);
        if (entry != null) {
            this.name = entry.getUserName();
            this.properties = entry.getProperties().getAll(true);
        } else {
            this.name = "Unknown";
            this.properties = Collections.emptyList();
        }
    }
}

