/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.handler;

import com.google.common.base.Charsets;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import protocolsupport.ProtocolSupport;
import protocolsupport.api.events.PlayerLoginStartEvent;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.libs.org.apache.commons.lang3.Validate;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.protocol.packet.handler.AbstractLoginListenerPlay;
import protocolsupport.protocol.packet.handler.IHasProfile;
import protocolsupport.protocol.packet.handler.PlayerLookupUUID;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.utils.Utils;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.network.NetworkManagerWrapper;

public abstract class AbstractLoginListener
implements IHasProfile {
    private static final int loginThreads = Utils.getJavaPropertyValue("loginthreads", Integer.MAX_VALUE, Utils.Converter.STRING_TO_INT);
    private static final int loginThreadKeepAlive = Utils.getJavaPropertyValue("loginthreadskeepalive", 60, Utils.Converter.STRING_TO_INT);
    private static final Executor loginprocessor = new ThreadPoolExecutor(1, loginThreads, (long)loginThreadKeepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "LoginProcessingThread"));
    protected final NetworkManagerWrapper networkManager;
    protected final String hostname;
    protected final byte[] randomBytes = new byte[4];
    protected int loginTicks;
    protected SecretKey loginKey;
    protected LoginState state = LoginState.HELLO;
    protected GameProfile profile;
    protected boolean isOnlineMode;
    protected boolean useOnlineModeUUID = this.isOnlineMode = Bukkit.getOnlineMode();
    protected UUID forcedUUID = null;

    public static void init() {
        ProtocolSupport.logInfo("Login threads max count: " + loginThreads + ", keep alive time: " + loginThreadKeepAlive);
    }

    public AbstractLoginListener(NetworkManagerWrapper networkmanager, String hostname) {
        this.networkManager = networkmanager;
        this.hostname = hostname;
        ThreadLocalRandom.current().nextBytes(this.randomBytes);
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    public void tick() {
        if (this.loginTicks++ == 600) {
            this.disconnect("Took too long to log in");
        }
    }

    public void disconnect(final String s) {
        try {
            Bukkit.getLogger().info("Disconnecting " + this.getConnectionRepr() + ": " + s);
            this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createLoginDisconnectPacket(s), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) {
                    AbstractLoginListener.this.networkManager.close(s);
                }
            }, new GenericFutureListener[0]);
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "Error whilst disconnecting player", exception);
        }
    }

    public void initOfflineModeGameProfile() {
        this.profile = new GameProfile(this.networkManager.getSpoofedUUID() != null ? this.networkManager.getSpoofedUUID() : this.generateOffileModeUUID(), this.profile.getName());
        if (this.networkManager.getSpoofedProperties() != null) {
            for (PlayerPropertiesResolveEvent.ProfileProperty property : this.networkManager.getSpoofedProperties()) {
                this.profile.addProperty(property);
            }
        }
    }

    protected UUID generateOffileModeUUID() {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.profile.getName()).getBytes(Charsets.UTF_8));
    }

    protected abstract boolean hasCompression();

    protected abstract void enableCompression(int var1);

    public String getConnectionRepr() {
        return this.profile != null ? this.profile + " (" + this.networkManager.getAddress() + ")" : this.networkManager.getAddress().toString();
    }

    public void handleLoginStart(final String name) {
        Validate.isTrue(this.state == LoginState.HELLO, "Unexpected hello packet", new Object[0]);
        this.state = LoginState.ONLINEMODERESOLVE;
        loginprocessor.execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        AbstractLoginListener.this.profile = new GameProfile(null, name);
                        PlayerLoginStartEvent event = new PlayerLoginStartEvent(ConnectionImpl.getFromChannel(AbstractLoginListener.this.networkManager.getChannel()), AbstractLoginListener.this.profile.getName(), AbstractLoginListener.this.isOnlineMode, AbstractLoginListener.this.useOnlineModeUUID, AbstractLoginListener.this.hostname);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isLoginDenied()) {
                            AbstractLoginListener.this.disconnect(event.getDenyLoginMessage());
                            return;
                        }
                        AbstractLoginListener.this.isOnlineMode = event.isOnlineMode();
                        AbstractLoginListener.this.useOnlineModeUUID = event.useOnlineModeUUID();
                        AbstractLoginListener.this.forcedUUID = event.getForcedUUID();
                        if (AbstractLoginListener.this.isOnlineMode) {
                            AbstractLoginListener.this.state = LoginState.KEY;
                            AbstractLoginListener.this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createLoginEncryptionBeginPacket(ServerPlatform.get().getMiscUtils().getEncryptionKeyPair().getPublic(), AbstractLoginListener.this.randomBytes));
                        } else {
                            new PlayerLookupUUID(AbstractLoginListener.this, AbstractLoginListener.this.isOnlineMode).run();
                        }
                    }
                    catch (Throwable t) {
                        AbstractLoginListener.this.disconnect("Error occured while logging in");
                        if (!ServerPlatform.get().getMiscUtils().isDebugging()) break block5;
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    public void handleEncryption(final EncryptionPacketWrapper encryptionpakcet) {
        Validate.isTrue(this.state == LoginState.KEY, "Unexpected key packet", new Object[0]);
        this.state = LoginState.AUTHENTICATING;
        loginprocessor.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        PrivateKey privatekey = ServerPlatform.get().getMiscUtils().getEncryptionKeyPair().getPrivate();
                        if (!Arrays.equals(AbstractLoginListener.this.randomBytes, encryptionpakcet.getNonce(privatekey))) {
                            throw new IllegalStateException("Invalid nonce!");
                        }
                        AbstractLoginListener.this.loginKey = encryptionpakcet.getSecretKey(privatekey);
                        AbstractLoginListener.this.enableEncryption(AbstractLoginListener.this.loginKey);
                        new PlayerLookupUUID(AbstractLoginListener.this, AbstractLoginListener.this.isOnlineMode).run();
                    }
                    catch (Throwable t) {
                        AbstractLoginListener.this.disconnect("Error occured while logging in");
                        if (!ServerPlatform.get().getMiscUtils().isDebugging()) break block3;
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    protected abstract void enableEncryption(SecretKey var1);

    public void setReadyToAccept() {
        int threshold;
        UUID newUUID = null;
        if (this.isOnlineMode && !this.useOnlineModeUUID) {
            newUUID = this.generateOffileModeUUID();
        }
        if (this.forcedUUID != null) {
            newUUID = this.forcedUUID;
        }
        if (newUUID != null) {
            GameProfile newProfile = new GameProfile(newUUID, this.profile.getName());
            newProfile.getProperties().putAll(this.profile.getProperties());
            this.profile = newProfile;
        }
        if (this.hasCompression() && (threshold = ServerPlatform.get().getMiscUtils().getCompressionThreshold()) >= 0) {
            this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createSetCompressionPacket(threshold), (GenericFutureListener<? extends Future<? super Void>>)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    AbstractLoginListener.this.enableCompression(threshold);
                }
            }, new GenericFutureListener[0]);
        }
        AbstractLoginListenerPlay listener = this.getLoginListenerPlay();
        this.networkManager.setPacketListener(listener);
        listener.finishLogin();
    }

    protected abstract AbstractLoginListenerPlay getLoginListenerPlay();

    public static enum LoginState {
        HELLO,
        ONLINEMODERESOLVE,
        KEY,
        AUTHENTICATING;

    }

    public static interface EncryptionPacketWrapper {
        public byte[] getNonce(PrivateKey var1);

        public SecretKey getSecretKey(PrivateKey var1);
    }
}

