/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.legacyremapper.chunk.BlockStorageReader;
import protocolsupport.protocol.legacyremapper.chunk.ChunkTransformerByte;
import protocolsupport.protocol.legacyremapper.chunk.ChunkTransformerShort;
import protocolsupport.protocol.legacyremapper.chunk.ChunkTransformerVaries;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.utils.Utils;

public abstract class ChunkTransformer {
    protected byte[] data;
    protected int bitmap;
    protected int columnsCount;
    protected boolean hasSkyLight;
    protected boolean hasBiomeData;
    protected final ChunkSection[] sections = new ChunkSection[16];
    protected final byte[] biomeData = new byte[256];
    protected static final int blocksInSection = 4096;

    public static ChunkTransformer create(BlockFormat format) {
        switch (format) {
            case VARIES: {
                return new ChunkTransformerVaries();
            }
            case SHORT: {
                return new ChunkTransformerShort();
            }
            case BYTE: {
                return new ChunkTransformerByte();
            }
        }
        throw new IllegalArgumentException();
    }

    public void loadData(byte[] data, int bitmap, boolean hasSkyLight, boolean hasBiomeData) {
        try {
            this.data = data;
            this.bitmap = bitmap;
            this.columnsCount = Integer.bitCount(bitmap);
            this.hasSkyLight = hasSkyLight;
            this.hasBiomeData = hasBiomeData;
            ByteBuf chunkdata = Unpooled.wrappedBuffer((byte[])data);
            for (int i = 0; i < this.columnsCount; ++i) {
                this.sections[i] = new ChunkSection(chunkdata, hasSkyLight);
            }
            if (hasBiomeData) {
                chunkdata.readBytes(this.biomeData);
            }
        }
        catch (Throwable e) {
            throw new ChunkDataParseException(data, bitmap, hasSkyLight, hasBiomeData, e);
        }
    }

    public byte[] toLegacyData(ProtocolVersion version) {
        try {
            return this.toLegacyData0(version);
        }
        catch (Throwable t) {
            throw new ChunkDataParseException(this.data, this.bitmap, this.hasSkyLight, this.hasBiomeData, t);
        }
    }

    protected abstract byte[] toLegacyData0(ProtocolVersion var1);

    public static final class ChunkDataParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ChunkDataParseException(byte[] data, int bitmap, boolean hasSkyLight, boolean hasBiomeData, Throwable e) {
            super(Utils.exceptionMessage("Failed to parse chunk data", String.format("Column bitmap: %s (Column count: %d)", Integer.toBinaryString(bitmap), Integer.bitCount(bitmap)), String.format("Has sky light: %b", hasSkyLight), String.format("Has biome data: %b", hasBiomeData), String.format("Chunk data: %s", Arrays.toString(data))), e);
        }
    }

    protected static class ChunkSection {
        private static final int[] globalpalette = new int[65534];
        protected final BlockStorageReader blockdata;
        protected final byte[] blocklight = new byte[2048];
        protected final byte[] skylight = new byte[2048];

        public ChunkSection(ByteBuf datastream, boolean hasSkyLight) {
            byte bitsPerBlock = datastream.readByte();
            int[] palette = globalpalette;
            int palettelength = ProtocolSupportPacketDataSerializer.readVarInt(datastream);
            if (palettelength != 0) {
                palette = new int[palettelength];
                for (int i = 0; i < palette.length; ++i) {
                    palette[i] = ProtocolSupportPacketDataSerializer.readVarInt(datastream);
                }
            }
            this.blockdata = new BlockStorageReader(palette, bitsPerBlock, ProtocolSupportPacketDataSerializer.readVarInt(datastream));
            this.blockdata.readFromStream(datastream);
            datastream.readBytes(this.blocklight);
            if (hasSkyLight) {
                datastream.readBytes(this.skylight);
            }
        }

        static {
            for (int i = 0; i < globalpalette.length; ++i) {
                ChunkSection.globalpalette[i] = i;
            }
        }
    }

    public static enum BlockFormat {
        VARIES,
        SHORT,
        BYTE;

    }
}

