/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api.remapper;

import org.bukkit.Material;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.typeremapper.id.IdRemapper;
import protocolsupport.protocol.typeremapper.id.RemappingTable;

public class BlockRemapperControl {
    private final RemappingTable.ArrayBasedIdRemappingTable table;

    public BlockRemapperControl(ProtocolVersion version) {
        switch (version) {
            case UNKNOWN: {
                throw new IllegalArgumentException((Object)((Object)version) + " is not a valid protocol version");
            }
        }
        this.table = (RemappingTable.ArrayBasedIdRemappingTable)IdRemapper.BLOCK.getTable(version);
    }

    public void setRemap(Material from, Material to) {
        this.setRemap(from.getId(), to.getId());
    }

    public void setRemap(int from, int to) {
        for (int i = 0; i < 16; ++i) {
            this.setRemap(from, i, to, i);
        }
    }

    @Deprecated
    public Material getRemap(Material material) {
        return Material.getMaterial((int)this.getRemap(material.getId()));
    }

    @Deprecated
    public int getRemap(int id) {
        return BlockRemapperControl.id(this.table.getRemap(BlockRemapperControl.combinedId(id, 0)));
    }

    public MaterialAndData getRemap(MaterialAndData entry) {
        int combinedId = this.table.getRemap(BlockRemapperControl.combinedId(entry.getId(), entry.getData()));
        return new MaterialAndData(BlockRemapperControl.id(combinedId), BlockRemapperControl.data(combinedId));
    }

    public void setRemap(MaterialAndData from, MaterialAndData to) {
        this.setRemap(from.getId(), from.getData(), to.getId(), to.getData());
    }

    public void setRemap(Material matFrom, int dataFrom, Material matTo, int dataTo) {
        this.setRemap(matFrom.getId(), dataFrom, matTo.getId(), dataTo);
    }

    public void setRemap(int idFrom, int dataFrom, int idTo, int dataTo) {
        this.table.setRemap(BlockRemapperControl.combinedId(idFrom, dataFrom), BlockRemapperControl.combinedId(idTo, dataTo));
    }

    private static int combinedId(int id, int data) {
        return id << 4 | data & 0xF;
    }

    private static int id(int combinedId) {
        return combinedId >> 4;
    }

    private static int data(int combinedId) {
        return combinedId & 0xF;
    }

    public static class MaterialAndData {
        private final int id;
        private final int data;

        public MaterialAndData(Material material, int data) {
            this(material.getId(), data);
        }

        public MaterialAndData(int id, int data) {
            this.id = id;
            this.data = data;
        }

        public Material getMaterial() {
            return Material.getMaterial((int)this.id);
        }

        public int getId() {
            return this.id;
        }

        public int getData() {
            return this.data;
        }
    }
}

