/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport;

import java.text.MessageFormat;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import protocolsupport.commands.CommandHandler;
import protocolsupport.listeners.CommandListener;
import protocolsupport.listeners.PlayerListener;
import protocolsupport.logger.AsyncErrorLogger;
import protocolsupport.protocol.legacyremapper.LegacySound;
import protocolsupport.protocol.legacyremapper.chunk.BlockStorageReader;
import protocolsupport.protocol.packet.ClientBoundPacket;
import protocolsupport.protocol.packet.ServerBoundPacket;
import protocolsupport.protocol.packet.handler.AbstractLoginListener;
import protocolsupport.protocol.pipeline.initial.InitialPacketDecoder;
import protocolsupport.protocol.typeremapper.id.IdRemapper;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.SpecificRemapper;
import protocolsupport.protocol.typeskipper.id.IdSkipper;
import protocolsupport.protocol.utils.data.ItemData;
import protocolsupport.protocol.utils.data.PotionData;
import protocolsupport.protocol.utils.data.SoundData;
import protocolsupport.protocol.utils.i18n.I18NData;
import protocolsupport.utils.netty.Allocator;
import protocolsupport.utils.netty.Compressor;
import protocolsupport.zplatform.ServerPlatform;

public class ProtocolSupport
extends JavaPlugin {
    public void onLoad() {
        AsyncErrorLogger.INSTANCE.start();
        if (!ServerPlatform.detect()) {
            this.getLogger().severe("Unsupported server implementation type, shutting down");
            Bukkit.shutdown();
            return;
        }
        this.getLogger().info(MessageFormat.format("Detected {0} server implementation type", ServerPlatform.get().getName()));
        try {
            Allocator.init();
            ItemData.init();
            PotionData.init();
            SoundData.init();
            I18NData.init();
            Compressor.init();
            ServerBoundPacket.init();
            ClientBoundPacket.init();
            InitialPacketDecoder.init();
            AbstractLoginListener.init();
            LegacySound.init();
            IdSkipper.init();
            SpecificRemapper.init();
            IdRemapper.init();
            BlockStorageReader.init();
            ServerPlatform.get().inject();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Bukkit.shutdown();
        }
    }

    public void onEnable() {
        this.getCommand("protocolsupport").setExecutor((CommandExecutor)new CommandHandler());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CommandListener(), (Plugin)this);
    }

    public void onDisable() {
        Bukkit.shutdown();
        AsyncErrorLogger.INSTANCE.stop();
    }

    public static void logWarning(String message) {
        ((ProtocolSupport)JavaPlugin.getPlugin(ProtocolSupport.class)).getLogger().warning(message);
    }

    public static void logInfo(String message) {
        ((ProtocolSupport)JavaPlugin.getPlugin(ProtocolSupport.class)).getLogger().info(message);
    }
}

