/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.storage;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.storage.DBCore;

public class SQLiteCore
implements DBCore {
    private Logger log;
    private Connection connection;
    private String dbLocation;
    private String dbName = "SimpleClans";
    private File file;

    public SQLiteCore(String dbLocation) {
        this.dbLocation = dbLocation;
        this.log = SimpleClans.getLog();
        this.initialize();
    }

    private void initialize() {
        if (this.file == null) {
            File dbFolder = new File(this.dbLocation);
            if (this.dbName.contains("/") || this.dbName.contains("\\") || this.dbName.endsWith(".db")) {
                this.log.severe("The database name can not contain: /, \\, or .db");
                return;
            }
            if (!dbFolder.exists()) {
                dbFolder.mkdir();
            }
            this.file = new File(dbFolder.getAbsolutePath() + File.separator + this.dbName + ".db");
        }
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.file.getAbsolutePath());
        }
        catch (SQLException ex) {
            this.log.severe("SQLite exception on initialize " + ex);
        }
        catch (ClassNotFoundException ex) {
            this.log.severe("You need the SQLite library " + ex);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.connection == null) {
            this.initialize();
        }
        return this.connection;
    }

    @Override
    public Boolean checkConnection() {
        return this.getConnection() != null;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.log.severe("Failed to close database connection! " + e.getMessage());
        }
    }

    @Override
    public ResultSet select(String query) {
        try {
            return this.getConnection().createStatement().executeQuery(query);
        }
        catch (SQLException ex) {
            this.log.severe("Error at SQL Query: " + ex.getMessage());
            this.log.severe("Query: " + query);
            return null;
        }
    }

    @Override
    public void insert(String query) {
        block2: {
            try {
                this.getConnection().createStatement().executeQuery(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block2;
                this.log.severe("Error at SQL INSERT Query: " + ex);
                this.log.severe("Query: " + query);
            }
        }
    }

    @Override
    public void update(String query) {
        block2: {
            try {
                this.getConnection().createStatement().executeQuery(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block2;
                this.log.severe("Error at SQL UPDATE Query: " + ex);
                this.log.severe("Query: " + query);
            }
        }
    }

    @Override
    public void delete(String query) {
        block2: {
            try {
                this.getConnection().createStatement().executeQuery(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block2;
                this.log.severe("Error at SQL DELETE Query: " + ex);
                this.log.severe("Query: " + query);
            }
        }
    }

    @Override
    public Boolean execute(String query) {
        try {
            this.getConnection().createStatement().execute(query);
            return true;
        }
        catch (SQLException ex) {
            this.log.severe(ex.getMessage());
            this.log.severe("Query: " + query);
            return false;
        }
    }

    @Override
    public Boolean existsTable(String table) {
        try {
            ResultSet tables = this.getConnection().getMetaData().getTables(null, null, table, null);
            return tables.next();
        }
        catch (SQLException e) {
            this.log.severe("Failed to check if table " + table + " exists: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean existsColumn(String table, String column) {
        try {
            ResultSet col = this.getConnection().getMetaData().getColumns(null, null, table, column);
            return col.next();
        }
        catch (Exception e) {
            this.log.severe("Failed to check if column " + column + " exists in table " + table + " : " + e.getMessage());
            return false;
        }
    }
}

