/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Dates;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.events.AllyClanAddEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.AllyClanRemoveEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.DisbandClanEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.PlayerDemoteEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.PlayerJoinedClanEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.PlayerKickedClanEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.PlayerPromoteEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.RivalClanAddEvent;
import net.sacredlabyrinth.phaed.simpleclans.events.RivalClanRemoveEvent;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDMigration;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Clan
implements Serializable,
Comparable<Clan> {
    private static final long serialVersionUID = 1L;
    private boolean verified;
    private String tag;
    private String colorTag;
    private String name;
    private double balance;
    private boolean friendlyFire;
    private long founded;
    private long lastUsed;
    private String capeUrl;
    private List<String> allies = new ArrayList<String>();
    private List<String> rivals = new ArrayList<String>();
    private List<String> bb = new ArrayList<String>();
    private List<String> members = new ArrayList<String>();
    private HashMap<String, Clan> warringClans = new HashMap();
    private int homeX = 0;
    private int homeY = 0;
    private int homeZ = 0;
    private String homeWorld = "";
    private boolean allowWithdraw = false;
    private boolean allowDeposit = true;

    public Clan() {
        this.capeUrl = "";
        this.tag = "";
    }

    public Clan(String tag, String name, boolean verified) {
        this.tag = Helper.cleanTag(tag);
        this.colorTag = Helper.parseColors(tag);
        this.name = name;
        this.founded = new Date().getTime();
        this.lastUsed = new Date().getTime();
        this.verified = verified;
        this.capeUrl = "";
        if (SimpleClans.getInstance().getSettingsManager().isClanFFOnByDefault()) {
            this.friendlyFire = true;
        }
    }

    public int hashCode() {
        return this.getTag().hashCode() >> 13;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Clan)) {
            return false;
        }
        Clan other = (Clan)obj;
        return other.getTag().equals(this.getTag());
    }

    @Override
    public int compareTo(Clan other) {
        return this.getTag().compareToIgnoreCase(other.getTag());
    }

    public String toString() {
        return this.tag;
    }

    public void deposit(double amount, Player player) {
        if (SimpleClans.getInstance().getPermissionsManager().playerHasMoney(player, amount)) {
            if (SimpleClans.getInstance().getPermissionsManager().playerChargeMoney(player, amount)) {
                player.sendMessage(ChatColor.AQUA + MessageFormat.format(SimpleClans.getInstance().getLang("player.clan.deposit"), amount));
                this.addBb(player.getName(), ChatColor.AQUA + MessageFormat.format(SimpleClans.getInstance().getLang("bb.clan.deposit"), amount));
                this.setBalance(this.getBalance() + amount);
                SimpleClans.getInstance().getStorageManager().updateClan(this);
            } else {
                player.sendMessage(ChatColor.AQUA + SimpleClans.getInstance().getLang("not.sufficient.money"));
            }
        } else {
            player.sendMessage(ChatColor.AQUA + SimpleClans.getInstance().getLang("not.sufficient.money"));
        }
    }

    public void withdraw(double amount, Player player) {
        if (this.getBalance() >= amount) {
            if (SimpleClans.getInstance().getPermissionsManager().playerGrantMoney(player, amount)) {
                player.sendMessage(ChatColor.AQUA + MessageFormat.format(SimpleClans.getInstance().getLang("player.clan.withdraw"), amount));
                this.addBb(player.getName(), ChatColor.AQUA + MessageFormat.format(SimpleClans.getInstance().getLang("bb.clan.withdraw"), amount));
                this.setBalance(this.getBalance() - amount);
                SimpleClans.getInstance().getStorageManager().updateClan(this);
            }
        } else {
            player.sendMessage(ChatColor.AQUA + SimpleClans.getInstance().getLang("clan.bank.not.enough.money"));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void updateLastUsed() {
        this.setLastUsed(new Date().getTime());
    }

    public int getInactiveDays() {
        Timestamp now = new Timestamp(new Date().getTime());
        return (int)Math.floor(Dates.differenceInDays(new Timestamp(this.getLastUsed()), now));
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    public boolean isMember(Player player) {
        if (SimpleClans.getInstance().hasUUID()) {
            return this.members.contains(player.getUniqueId().toString());
        }
        return this.members.contains(player.getName().toLowerCase());
    }

    @Deprecated
    public boolean isMember(String playerName) {
        if (SimpleClans.getInstance().hasUUID()) {
            UUID PlayerUniqueId = UUIDMigration.getForcedPlayerUUID(playerName);
            if (PlayerUniqueId != null) {
                return this.members.contains(PlayerUniqueId.toString());
            }
            return false;
        }
        return this.members.contains(playerName.toLowerCase());
    }

    public boolean isMember(UUID playerUniqueId) {
        return this.members.contains(playerUniqueId.toString());
    }

    public List<String> getBb() {
        return Collections.unmodifiableList(this.bb);
    }

    public List<String> getAllies() {
        return Collections.unmodifiableList(this.allies);
    }

    private void addAlly(String tag) {
        this.allies.add(tag);
    }

    private boolean removeAlly(String ally) {
        if (!this.allies.contains(ally)) {
            return false;
        }
        this.allies.remove(ally);
        return true;
    }

    public long getFounded() {
        return this.founded;
    }

    public String getFoundedString() {
        return new SimpleDateFormat("MMM dd, ''yy h:mm a").format(new Date(this.founded));
    }

    public void setFounded(long founded) {
        this.founded = founded;
    }

    public String getColorTag() {
        return this.colorTag;
    }

    public void setColorTag(String colorTag) {
        this.colorTag = Helper.parseColors(colorTag);
    }

    public void addBb(String msg) {
        while (this.bb.size() > SimpleClans.getInstance().getSettingsManager().getBbSize()) {
            this.bb.remove(0);
        }
        this.bb.add(msg);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
    }

    public void clearBb() {
        this.bb.clear();
        SimpleClans.getInstance().getStorageManager().updateClan(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importMember(ClanPlayer cp) {
        String NameOrUUID;
        if (SimpleClans.getInstance().hasUUID()) {
            if (cp.getUniqueId() == null) return;
            NameOrUUID = cp.getUniqueId().toString();
        } else {
            NameOrUUID = cp.getCleanName();
        }
        if (this.members.contains(NameOrUUID)) return;
        this.members.add(NameOrUUID);
    }

    @Deprecated
    public void removeMember(String playerName) {
        if (SimpleClans.getInstance().hasUUID()) {
            UUID PlayerUniqueId = UUIDMigration.getForcedPlayerUUID(playerName);
            if (PlayerUniqueId != null) {
                this.members.remove(PlayerUniqueId.toString());
            }
        } else {
            this.members.remove(playerName.toLowerCase());
        }
    }

    public void removeMember(UUID playerUniqueId) {
        this.members.remove(playerUniqueId.toString());
    }

    public int getSize() {
        return this.members.size();
    }

    public List<String> getRivals() {
        return Collections.unmodifiableList(this.rivals);
    }

    private void addRival(String tag) {
        this.rivals.add(tag);
    }

    private boolean removeRival(String rival) {
        if (!this.rivals.contains(rival)) {
            return false;
        }
        this.rivals.remove(rival);
        return true;
    }

    public boolean isRival(String tag) {
        return this.rivals.contains(tag);
    }

    public boolean isAlly(String tag) {
        return this.allies.contains(tag);
    }

    public boolean isVerified() {
        return !SimpleClans.getInstance().getSettingsManager().isRequireVerification() || this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public String getCapeUrl() {
        return this.capeUrl;
    }

    public void setCapeUrl(String capeUrl) {
        this.capeUrl = capeUrl;
    }

    public String getPackedBb() {
        return Helper.toMessage(this.bb, "|");
    }

    public void setPackedBb(String packedBb) {
        this.bb = Helper.fromArray(packedBb.split("[|]"));
    }

    public String getPackedAllies() {
        return Helper.toMessage(this.allies, "|");
    }

    public void setPackedAllies(String packedAllies) {
        this.allies = Helper.fromArray(packedAllies.split("[|]"));
    }

    public String getPackedRivals() {
        return Helper.toMessage(this.rivals, "|");
    }

    public void setPackedRivals(String packedRivals) {
        this.rivals = Helper.fromArray(packedRivals.split("[|]"));
    }

    public String getAllyString(String sep) {
        String out = "";
        for (String allyTag : this.getAllies()) {
            Clan ally = SimpleClans.getInstance().getClanManager().getClan(allyTag);
            if (ally == null) continue;
            out = out + ally.getColorTag() + sep;
        }
        if ((out = Helper.stripTrailing(out, sep)).trim().isEmpty()) {
            return ChatColor.BLACK + "None";
        }
        return Helper.parseColors(out);
    }

    public String getRivalString(String sep) {
        String out = "";
        for (String rivalTag : this.getRivals()) {
            Clan rival = SimpleClans.getInstance().getClanManager().getClan(rivalTag);
            if (rival == null) continue;
            if (this.isWarring(rivalTag)) {
                out = out + ChatColor.DARK_RED + "[" + Helper.stripColors(rival.getColorTag()) + "]" + sep;
                continue;
            }
            out = out + rival.getColorTag() + sep;
        }
        if ((out = Helper.stripTrailing(out, sep)).trim().isEmpty()) {
            return ChatColor.BLACK + "None";
        }
        return Helper.parseColors(out);
    }

    public String getLeadersString(String prefix, String sep) {
        String out = "";
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null || !cp.isLeader()) continue;
            out = out + prefix + cp.getName() + sep;
        }
        return Helper.stripTrailing(out, sep);
    }

    public boolean isLeader(Player player) {
        if (SimpleClans.getInstance().hasUUID()) {
            return this.isLeader(player.getUniqueId());
        }
        return this.isLeader(player.getName());
    }

    @Deprecated
    public boolean isLeader(String playerName) {
        ClanPlayer cp;
        return this.isMember(playerName) && (cp = SimpleClans.getInstance().getClanManager().getClanPlayerName(playerName.toLowerCase())) != null && cp.isLeader();
    }

    public boolean isLeader(UUID playerUniqueId) {
        ClanPlayer cp;
        return this.isMember(playerUniqueId) && (cp = SimpleClans.getInstance().getClanManager().getClanPlayer(playerUniqueId)) != null && cp.isLeader();
    }

    public List<ClanPlayer> getMembers() {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            out.add(cp);
        }
        return out;
    }

    public List<ClanPlayer> getOnlineMembers() {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null || cp.toPlayer() == null || !cp.toPlayer().isOnline()) continue;
            out.add(cp);
        }
        return out;
    }

    public List<ClanPlayer> getLeaders() {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null || !cp.isLeader()) continue;
            out.add(cp);
        }
        return out;
    }

    public List<ClanPlayer> getNonLeaders() {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null || cp.isLeader()) continue;
            out.add(cp);
        }
        Collections.sort(out);
        return out;
    }

    public List<ClanPlayer> getAllMembers() {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            out.add(cp);
        }
        Collections.sort(out);
        return out;
    }

    public Set<ClanPlayer> getAllAllyMembers() {
        HashSet<ClanPlayer> out = new HashSet<ClanPlayer>();
        for (String tag : this.allies) {
            Clan ally = SimpleClans.getInstance().getClanManager().getClan(tag);
            if (ally == null) continue;
            out.addAll(ally.getMembers());
        }
        return out;
    }

    public float getTotalKDR() {
        if (this.members.isEmpty()) {
            return 0.0f;
        }
        double totalWeightedKills = 0.0;
        int totalDeaths = 0;
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            totalWeightedKills += cp.getWeightedKills();
            totalDeaths += cp.getDeaths();
        }
        if (totalDeaths == 0) {
            totalDeaths = 1;
        }
        return (float)totalWeightedKills / (float)totalDeaths;
    }

    public int getTotalDeaths() {
        int totalDeaths = 0;
        if (this.members.isEmpty()) {
            return totalDeaths;
        }
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            totalDeaths += cp.getDeaths();
        }
        return totalDeaths;
    }

    public int getAverageWK() {
        int total = 0;
        if (this.members.isEmpty()) {
            return total;
        }
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            total = (int)((double)total + cp.getWeightedKills());
        }
        return total / this.getSize();
    }

    public int getTotalRival() {
        int total = 0;
        if (this.members.isEmpty()) {
            return total;
        }
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            total += cp.getRivalKills();
        }
        return total;
    }

    public int getTotalNeutral() {
        int total = 0;
        if (this.members.isEmpty()) {
            return total;
        }
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            total += cp.getNeutralKills();
        }
        return total;
    }

    public int getTotalCivilian() {
        int total = 0;
        if (this.members.isEmpty()) {
            return total;
        }
        for (String member : this.members) {
            ClanPlayer cp = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getClanManager().getClanPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getClanManager().getClanPlayer(member.toLowerCase());
            if (cp == null) continue;
            total += cp.getCivilianKills();
        }
        return total;
    }

    public void setClanCape(String url) {
        this.setCapeUrl(url);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        for (String member : this.members) {
            if (SimpleClans.getInstance().hasUUID()) {
                SimpleClans.getInstance().getSpoutPluginManager().processPlayer(UUID.fromString(member));
                continue;
            }
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(member);
        }
    }

    public boolean reachedRivalLimit() {
        int rivalPercent;
        int clanCount;
        double limit;
        int rivalCount = this.rivals.size();
        return (double)rivalCount > (limit = (double)(clanCount = SimpleClans.getInstance().getClanManager().getRivableClanCount() - 1) * ((double)(rivalPercent = SimpleClans.getInstance().getSettingsManager().getRivalLimitPercent()) / 100.0));
    }

    public void addPlayerToClan(ClanPlayer cp) {
        cp.removePastClan(this.getColorTag());
        cp.setClan(this);
        cp.setLeader(false);
        cp.setTrusted(SimpleClans.getInstance().getSettingsManager().isClanTrustByDefault());
        this.importMember(cp);
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        if (SimpleClans.getInstance().hasUUID()) {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        } else {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getName());
        }
        SimpleClans.getInstance().getPermissionsManager().addClanPermissions(cp);
        Player player = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getServer().getPlayer(cp.getUniqueId()) : SimpleClans.getInstance().getServer().getPlayerExact(cp.getName());
        if (player != null) {
            SimpleClans.getInstance().getClanManager().updateDisplayName(player);
        }
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerJoinedClanEvent(this, cp));
    }

    @Deprecated
    public void removePlayerFromClan(String playerName) {
        ClanPlayer cp = SimpleClans.getInstance().getClanManager().getClanPlayer(playerName);
        SimpleClans.getInstance().getPermissionsManager().removeClanPermissions(cp);
        SimpleClans.getInstance().getPermissionsManager().removeClanPlayerPermissions(cp);
        cp.setClan(null);
        cp.addPastClan(this.getColorTag() + (cp.isLeader() ? ChatColor.DARK_RED + "*" : ""));
        cp.setLeader(false);
        cp.setTrusted(false);
        cp.setJoinDate(0L);
        this.removeMember(playerName);
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        if (SimpleClans.getInstance().hasUUID()) {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        } else {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getName());
        }
        Player matched = cp.toPlayer();
        if (matched != null) {
            SimpleClans.getInstance().getClanManager().updateDisplayName(matched);
        }
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerKickedClanEvent(this, cp));
    }

    public void removePlayerFromClan(UUID playerUniqueId) {
        ClanPlayer cp = SimpleClans.getInstance().getClanManager().getClanPlayer(playerUniqueId);
        SimpleClans.getInstance().getPermissionsManager().removeClanPermissions(cp);
        SimpleClans.getInstance().getPermissionsManager().removeClanPlayerPermissions(cp);
        cp.setClan(null);
        cp.addPastClan(this.getColorTag() + (cp.isLeader() ? ChatColor.DARK_RED + "*" : ""));
        cp.setLeader(false);
        cp.setTrusted(false);
        cp.setJoinDate(0L);
        this.removeMember(playerUniqueId);
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        Player matched = SimpleClans.getInstance().getServer().getPlayer(playerUniqueId);
        if (matched != null) {
            SimpleClans.getInstance().getClanManager().updateDisplayName(matched);
        }
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerKickedClanEvent(this, cp));
    }

    @Deprecated
    public void promote(String playerName) {
        ClanPlayer cp = SimpleClans.getInstance().getClanManager().getClanPlayer(playerName);
        cp.setLeader(true);
        cp.setTrusted(true);
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        if (SimpleClans.getInstance().hasUUID()) {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        } else {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getName());
        }
        SimpleClans.getInstance().getPermissionsManager().addClanPermissions(cp);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerPromoteEvent(this, cp));
    }

    public void promote(UUID playerUniqueId) {
        ClanPlayer cp = SimpleClans.getInstance().getClanManager().getClanPlayer(playerUniqueId);
        cp.setLeader(true);
        cp.setTrusted(true);
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        SimpleClans.getInstance().getPermissionsManager().addClanPermissions(cp);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerPromoteEvent(this, cp));
    }

    @Deprecated
    public void demote(String playerName) {
        ClanPlayer cp = SimpleClans.getInstance().getClanManager().getClanPlayer(playerName);
        cp.setLeader(false);
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        if (SimpleClans.getInstance().hasUUID()) {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        } else {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getName());
        }
        SimpleClans.getInstance().getPermissionsManager().addClanPermissions(cp);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerDemoteEvent(this, cp));
    }

    public void demote(UUID playerUniqueId) {
        ClanPlayer cp = SimpleClans.getInstance().getClanManager().getClanPlayer(playerUniqueId);
        cp.setLeader(false);
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        SimpleClans.getInstance().getPermissionsManager().addClanPermissions(cp);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerDemoteEvent(this, cp));
    }

    public void addAlly(Clan ally) {
        this.removeRival(ally.getTag());
        this.addAlly(ally.getTag());
        ally.removeRival(this.getTag());
        ally.addAlly(this.getTag());
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        SimpleClans.getInstance().getStorageManager().updateClan(ally);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new AllyClanAddEvent(this, ally));
    }

    public void removeAlly(Clan ally) {
        this.removeAlly(ally.getTag());
        ally.removeAlly(this.getTag());
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        SimpleClans.getInstance().getStorageManager().updateClan(ally);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new AllyClanRemoveEvent(this, ally));
    }

    public void addRival(Clan rival) {
        this.removeAlly(rival.getTag());
        this.addRival(rival.getTag());
        rival.removeAlly(this.getTag());
        rival.addRival(this.getTag());
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        SimpleClans.getInstance().getStorageManager().updateClan(rival);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new RivalClanAddEvent(this, rival));
    }

    public void removeRival(Clan rival) {
        this.removeRival(rival.getTag());
        rival.removeRival(this.getTag());
        SimpleClans.getInstance().getStorageManager().updateClan(this);
        SimpleClans.getInstance().getStorageManager().updateClan(rival);
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new RivalClanRemoveEvent(this, rival));
    }

    public void verifyClan() {
        this.setVerified(true);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
    }

    public boolean isAnyOnline() {
        for (String member : this.members) {
            if (!(SimpleClans.getInstance().hasUUID() ? Helper.isOnline(UUID.fromString(member)) : Helper.isOnline(member))) continue;
            return true;
        }
        return false;
    }

    public boolean allLeadersOnline() {
        List<ClanPlayer> leaders = this.getLeaders();
        for (ClanPlayer leader : leaders) {
            if (!(SimpleClans.getInstance().hasUUID() ? !Helper.isOnline(leader.getUniqueId()) : !Helper.isOnline(leader.getName()))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean allOtherLeadersOnline(String playerName) {
        List<ClanPlayer> leaders = this.getLeaders();
        for (ClanPlayer leader : leaders) {
            if (leader.getName().equalsIgnoreCase(playerName) || Helper.isOnline(leader.getName())) continue;
            return false;
        }
        return true;
    }

    public boolean allOtherLeadersOnline(UUID playerUniqueId) {
        List<ClanPlayer> leaders = this.getLeaders();
        for (ClanPlayer leader : leaders) {
            if (leader.getUniqueId().equals(playerUniqueId) || Helper.isOnline(leader.getUniqueId())) continue;
            return false;
        }
        return true;
    }

    public void changeClanTag(String tag) {
        this.setColorTag(tag);
        SimpleClans.getInstance().getStorageManager().updateClan(this);
    }

    public void clanAnnounce(String playerName, String msg) {
        String message = SimpleClans.getInstance().getSettingsManager().getClanChatAnnouncementColor() + msg;
        for (ClanPlayer cp : this.getMembers()) {
            Player pl = cp.toPlayer();
            if (pl == null) continue;
            ChatBlock.sendMessage((CommandSender)pl, message);
        }
        SimpleClans.getInstance().getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + SimpleClans.getInstance().getLang("clan.announce") + ChatColor.AQUA + "] " + ChatColor.AQUA + "[" + Helper.getColorName(playerName) + ChatColor.WHITE + "] " + message);
    }

    public void leaderAnnounce(String msg) {
        String message = SimpleClans.getInstance().getSettingsManager().getClanChatAnnouncementColor() + msg;
        List<ClanPlayer> leaders = this.getLeaders();
        for (ClanPlayer cp : leaders) {
            Player pl = cp.toPlayer();
            if (pl == null) continue;
            ChatBlock.sendMessage((CommandSender)pl, message);
        }
        SimpleClans.getInstance().getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + SimpleClans.getInstance().getLang("leader.announce") + ChatColor.AQUA + "] " + ChatColor.WHITE + message);
    }

    public void audioAnnounce(String playerName, String msg) {
        this.clanAnnounce(playerName, msg);
        for (String member : this.members) {
            Player pl = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getServer().getPlayer(UUID.fromString(member)) : SimpleClans.getInstance().getServer().getPlayerExact(member);
            if (pl == null) continue;
            SimpleClans.getInstance().getSpoutPluginManager().playAlert(pl);
        }
    }

    public void addBb(String announcerName, String msg) {
        if (this.isVerified()) {
            this.addBb(SimpleClans.getInstance().getSettingsManager().getBbColor() + msg);
            this.clanAnnounce(announcerName, SimpleClans.getInstance().getSettingsManager().getBbAccentColor() + "* " + SimpleClans.getInstance().getSettingsManager().getBbColor() + Helper.parseColors(msg));
        }
    }

    public void displayBb(Player player) {
        if (this.isVerified()) {
            ChatBlock.sendBlank((CommandSender)player);
            ChatBlock.saySingle((CommandSender)player, MessageFormat.format(SimpleClans.getInstance().getLang("bulletin.board.header"), SimpleClans.getInstance().getSettingsManager().getBbAccentColor(), SimpleClans.getInstance().getSettingsManager().getPageHeadingsColor(), Helper.capitalize(this.getName())));
            int maxSize = SimpleClans.getInstance().getSettingsManager().getBbSize();
            while (this.bb.size() > maxSize) {
                this.bb.remove(0);
            }
            for (String msg : this.bb) {
                ChatBlock.sendMessage((CommandSender)player, SimpleClans.getInstance().getSettingsManager().getBbAccentColor() + "* " + SimpleClans.getInstance().getSettingsManager().getBbColor() + Helper.parseColors(msg));
            }
            ChatBlock.sendBlank((CommandSender)player);
        }
    }

    public void disband() {
        SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)new DisbandClanEvent(this));
        List<ClanPlayer> clanPlayers = SimpleClans.getInstance().getClanManager().getAllClanPlayers();
        List<Clan> clans = SimpleClans.getInstance().getClanManager().getClans();
        for (ClanPlayer cp : clanPlayers) {
            if (!cp.getTag().equals(this.getTag())) continue;
            SimpleClans.getInstance().getPermissionsManager().removeClanPermissions(this);
            cp.setClan(null);
            if (this.isVerified()) {
                cp.addPastClan(this.getColorTag() + (cp.isLeader() ? ChatColor.DARK_RED + "*" : ""));
            }
            cp.setLeader(false);
            SimpleClans.getInstance().getStorageManager().updateClanPlayer(cp);
            if (SimpleClans.getInstance().hasUUID()) {
                SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
                continue;
            }
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getName());
        }
        clans.remove(this);
        for (Clan c : clans) {
            String disbanded = SimpleClans.getInstance().getLang("clan.disbanded");
            if (c.removeWarringClan(this)) {
                c.addBb(disbanded, ChatColor.AQUA + MessageFormat.format(SimpleClans.getInstance().getLang("you.are.no.longer.at.war"), Helper.capitalize(c.getName()), this.getColorTag()));
            }
            if (c.removeRival(this.getTag())) {
                c.addBb(disbanded, ChatColor.AQUA + MessageFormat.format(SimpleClans.getInstance().getLang("has.been.disbanded.rivalry.ended"), Helper.capitalize(this.getName())));
            }
            if (!c.removeAlly(this.getTag())) continue;
            c.addBb(disbanded, ChatColor.AQUA + MessageFormat.format(SimpleClans.getInstance().getLang("has.been.disbanded.alliance.ended"), Helper.capitalize(this.getName())));
        }
        final Clan thisOne = this;
        SimpleClans.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SimpleClans.getInstance(), new Runnable(){

            @Override
            public void run() {
                SimpleClans.getInstance().getClanManager().removeClan(thisOne.getTag());
                SimpleClans.getInstance().getStorageManager().deleteClan(thisOne);
            }
        }, 1L);
    }

    public boolean isUnrivable() {
        return SimpleClans.getInstance().getSettingsManager().isUnrivable(this.getTag());
    }

    public boolean isWarring(String tag) {
        return this.warringClans.containsKey(tag);
    }

    public boolean isWarring(Clan clan) {
        return this.warringClans.containsKey(clan.getTag());
    }

    public void addWarringClan(Clan clan) {
        if (!this.warringClans.containsKey(clan.getTag())) {
            this.warringClans.put(clan.getTag(), clan);
        }
        SimpleClans.getInstance().getStorageManager().updateClan(this);
    }

    public boolean removeWarringClan(Clan clan) {
        Clan warring = this.warringClans.remove(clan.getTag());
        if (warring != null) {
            SimpleClans.getInstance().getStorageManager().updateClan(this);
            return true;
        }
        return false;
    }

    public List<Clan> getWarringClans() {
        return new ArrayList<Clan>(this.warringClans.values());
    }

    public String getFlags() {
        JSONObject json = new JSONObject();
        JSONArray warring = new JSONArray();
        warring.addAll(this.warringClans.keySet());
        json.put((Object)"warring", (Object)warring);
        json.put((Object)"homeX", (Object)this.homeX);
        json.put((Object)"homeY", (Object)this.homeY);
        json.put((Object)"homeZ", (Object)this.homeZ);
        json.put((Object)"homeWorld", (Object)(this.homeWorld == null ? "" : this.homeWorld));
        return json.toString();
    }

    public void setFlags(String flagString) {
        JSONObject flags;
        if (flagString != null && !flagString.isEmpty() && (flags = (JSONObject)JSONValue.parse((String)flagString)) != null) {
            for (Object flag : flags.keySet()) {
                try {
                    JSONArray clans;
                    if (flag.equals("warring") && (clans = (JSONArray)flags.get(flag)) != null) {
                        for (Object tag : clans) {
                            SimpleClans.debug("warring added: " + tag.toString());
                            this.warringClans.put(tag.toString(), null);
                        }
                    }
                    if (flag.equals("homeX")) {
                        this.homeX = ((Long)flags.get(flag)).intValue();
                    }
                    if (flag.equals("homeY")) {
                        this.homeY = ((Long)flags.get(flag)).intValue();
                    }
                    if (flag.equals("homeZ")) {
                        this.homeZ = ((Long)flags.get(flag)).intValue();
                    }
                    if (!flag.equals("homeWorld")) continue;
                    this.homeWorld = (String)flags.get(flag);
                }
                catch (Exception ex) {
                    for (StackTraceElement el : ex.getStackTrace()) {
                        System.out.print("Failed reading flag: " + flag);
                        System.out.print("Value: " + flags.get(flag));
                        System.out.print(el.toString());
                    }
                }
            }
        }
    }

    public void validateWarring() {
        Iterator<String> iter = this.warringClans.keySet().iterator();
        while (iter.hasNext()) {
            String clanName = iter.next();
            Clan clan = SimpleClans.getInstance().getClanManager().getClan(clanName);
            if (clan == null) {
                iter.remove();
                continue;
            }
            SimpleClans.debug("validated: " + clanName);
            this.warringClans.put(clanName, clan);
        }
    }

    public void setHomeLocation(Location home) {
        if (home == null) {
            this.homeY = 0;
            this.homeX = 0;
            this.homeZ = 0;
            this.homeWorld = null;
        } else {
            home.setY((double)(home.getBlockY() + 1));
            this.homeX = home.getBlockX();
            this.homeY = home.getBlockY();
            this.homeZ = home.getBlockZ();
            this.homeWorld = home.getWorld().getName();
        }
        SimpleClans.getInstance().getStorageManager().updateClan(this);
    }

    public Location getHomeLocation() {
        World world = SimpleClans.getInstance().getServer().getWorld(this.homeWorld);
        if (world != null) {
            if (!world.getBlockAt(this.homeX, this.homeY, this.homeZ).getType().equals((Object)Material.AIR) || !world.getBlockAt(this.homeX, this.homeY + 1, this.homeZ).getType().equals((Object)Material.AIR) || this.homeY == 0) {
                return new Location(world, (double)this.homeX, (double)world.getHighestBlockYAt(this.homeX, this.homeZ), (double)this.homeZ);
            }
            return new Location(world, (double)this.homeX, (double)this.homeY, (double)this.homeZ);
        }
        return null;
    }

    public String getTagLabel(boolean isLeader) {
        SimpleClans plugin = SimpleClans.getInstance();
        if (isLeader) {
            return plugin.getSettingsManager().getTagBracketLeaderColor() + plugin.getSettingsManager().getTagBracketLeft() + plugin.getSettingsManager().getTagDefaultColor() + this.getColorTag() + plugin.getSettingsManager().getTagBracketLeaderColor() + plugin.getSettingsManager().getTagBracketRight() + plugin.getSettingsManager().getTagSeparatorLeaderColor() + plugin.getSettingsManager().getTagSeparator();
        }
        return plugin.getSettingsManager().getTagBracketColor() + plugin.getSettingsManager().getTagBracketLeft() + plugin.getSettingsManager().getTagDefaultColor() + this.getColorTag() + plugin.getSettingsManager().getTagBracketColor() + plugin.getSettingsManager().getTagBracketRight() + plugin.getSettingsManager().getTagSeparatorColor() + plugin.getSettingsManager().getTagSeparator();
    }

    public boolean isAllowWithdraw() {
        return this.allowWithdraw;
    }

    public void setAllowWithdraw(boolean allowWithdraw) {
        this.allowWithdraw = allowWithdraw;
    }

    public boolean isAllowDeposit() {
        return this.allowDeposit;
    }

    public void setAllowDeposit(boolean allowDeposit) {
        this.allowDeposit = allowDeposit;
    }
}

