/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.players;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.channels.types.Channel;
import br.com.devpaulo.legendchat.channels.types.TemporaryChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerManager {
    private final HashMap<Player, Channel> players = new HashMap();
    private final List<String> spys = new ArrayList<String>();
    private final List<Player> hidden = new ArrayList<Player>();

    public void playerDisconnect(Player p) {
        this.setPlayerFocusedChannel(p, null, false);
        if (!Legendchat.maintainSpyMode()) {
            this.removeSpy(p);
        }
        this.showPlayerToRecipients(p);
    }

    public void setPlayerFocusedChannel(Player p, Channel c, boolean msg) {
        if (Legendchat.getDefaultChannel() != c && c != null && !p.hasPermission("legendchat.channel." + c.getName() + ".focus") && !p.hasPermission("legendchat.admin")) {
            if (msg) {
                p.sendMessage(Legendchat.getMessageManager().getMessage("error5"));
            }
            return;
        }
        if (this.isPlayerFocusedInAnyChannel(p)) {
            this.players.remove(p);
        }
        if (c != null) {
            this.players.put(p, c);
        }
        if (msg) {
            p.sendMessage(Legendchat.getMessageManager().getMessage("message1").replace("@channel", c.getName()));
        }
    }

    public Channel getPlayerFocusedChannel(Player p) {
        if (this.isPlayerFocusedInAnyChannel(p)) {
            return this.players.get(p);
        }
        return null;
    }

    public List<Player> getPlayersFocusedInChannel(Channel c) {
        ArrayList<Player> l = new ArrayList<Player>();
        for (Player p : this.players.keySet()) {
            if (this.players.get(p) != c) continue;
            l.add(p);
        }
        return l;
    }

    public List<Player> getPlayersWhoCanSeeChannel(Channel c) {
        ArrayList<Player> l = new ArrayList<Player>();
        if (c instanceof TemporaryChannel) {
            l.addAll(((TemporaryChannel)c).user_list());
        } else {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.hasPermission("legendchat.channel." + c.getName().toLowerCase() + ".chat")) continue;
                l.add(p);
            }
        }
        return l;
    }

    public boolean isPlayerFocusedInAnyChannel(Player p) {
        return this.players.containsKey(p);
    }

    public boolean canPlayerSeeChannel(Player p, Channel c) {
        if (c instanceof TemporaryChannel) {
            return ((TemporaryChannel)c).user_list().contains(p);
        }
        return p.hasPermission("legendchat.channel." + c.getName().toLowerCase() + ".chat");
    }

    public void addSpy(Player p) {
        this.addSpy(p.getName());
    }

    public void addSpy(String p) {
        if (!this.isSpy(p = p.toLowerCase())) {
            this.spys.add(p);
        }
    }

    public void removeSpy(Player p) {
        this.removeSpy(p.getName());
    }

    public void removeSpy(String p) {
        if (this.isSpy(p = p.toLowerCase())) {
            this.spys.remove(p);
        }
    }

    public boolean isSpy(Player p) {
        return this.isSpy(p.getName());
    }

    public boolean isSpy(String p) {
        return this.spys.contains(p.toLowerCase());
    }

    public List<String> getAllSpys() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.spys);
        return l;
    }

    public List<Player> getOnlineSpys() {
        ArrayList<Player> l = new ArrayList<Player>();
        ArrayList<String> l2 = new ArrayList<String>();
        l2.addAll(this.spys);
        for (String n : l2) {
            Player p = Bukkit.getPlayerExact((String)n);
            if (p == null) continue;
            l.add(p);
        }
        return l;
    }

    public void hidePlayerFromRecipients(Player p) {
        if (!this.isPlayerHiddenFromRecipients(p)) {
            this.hidden.add(p);
        }
    }

    public void showPlayerToRecipients(Player p) {
        if (this.isPlayerHiddenFromRecipients(p)) {
            this.hidden.remove(p);
        }
    }

    public boolean isPlayerHiddenFromRecipients(Player p) {
        return this.hidden.contains(p);
    }

    public List<Player> getHiddenPlayers() {
        ArrayList<Player> l = new ArrayList<Player>();
        l.addAll(this.hidden);
        return l;
    }
}

