/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.channels.types;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.channels.types.Channel;
import br.com.devpaulo.legendchat.channels.utils.ChannelUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public final class TemporaryChannel
implements Channel {
    private String name = "";
    private String nick = "";
    private String format = "";
    private String color = "";
    private String color2 = "";
    private boolean shortcut = false;
    private boolean focus = false;
    private double distance = 0.0;
    private boolean crossworlds = false;
    private double cost = 0.0;
    private boolean show_cost_msg = false;
    private int delay = 0;
    private Player leader = null;
    private final List<Player> mods = new ArrayList<Player>();
    private final List<Player> players = new ArrayList<Player>();
    private boolean mod_can_kick = false;
    private boolean mod_can_invite = false;
    private final List<Player> invites = new ArrayList<Player>();

    public TemporaryChannel(String name, String nick, String format, String color, boolean shortcut, boolean focus, double distance, boolean crossworlds, int delay, double cost, boolean show_cost_msg, Player leader, boolean mod_can_kick, boolean mod_can_invite) {
        this.name = name;
        this.nick = nick;
        this.format = format;
        this.color = ChannelUtils.translateStringColor(color);
        this.color2 = color.toLowerCase();
        this.shortcut = shortcut;
        this.focus = focus;
        this.distance = distance;
        this.crossworlds = crossworlds;
        this.cost = cost;
        this.show_cost_msg = show_cost_msg;
        this.delay = delay;
        this.mod_can_kick = mod_can_kick;
        this.mod_can_invite = mod_can_invite;
        this.leader_set(leader);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNickname() {
        return this.nick;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public String getStringColor() {
        return this.color2;
    }

    public void setColorByString(String color) {
        this.color = ChannelUtils.translateStringColor(color);
        this.color2 = color.toLowerCase();
    }

    @Override
    public boolean isShortcutAllowed() {
        return this.shortcut;
    }

    @Override
    public boolean isFocusNeeded() {
        return this.focus;
    }

    @Override
    public boolean isCrossworlds() {
        return this.crossworlds;
    }

    @Override
    public double getMaxDistance() {
        return this.distance;
    }

    @Override
    public double getMessageCost() {
        return this.cost;
    }

    @Override
    public double getCostPerMessage() {
        return this.cost;
    }

    @Override
    public boolean showCostMessage() {
        return this.show_cost_msg;
    }

    @Override
    public int getDelayPerMessage() {
        return this.delay;
    }

    @Override
    public List<Player> getPlayersFocusedInChannel() {
        return Legendchat.getPlayerManager().getPlayersFocusedInChannel(this);
    }

    @Override
    public List<Player> getPlayersWhoCanSeeChannel() {
        ArrayList<Player> pl = new ArrayList<Player>();
        pl.addAll(this.players);
        return pl;
    }

    public void invite_add(Player p) {
        if (!this.invites.contains(p)) {
            this.invites.add(p);
        }
    }

    public void invite_remove(Player p) {
        if (this.invites.contains(p)) {
            this.invites.remove(p);
        }
    }

    public List<Player> invite_list() {
        ArrayList<Player> invs = new ArrayList<Player>();
        invs.addAll(this.invites);
        return invs;
    }

    public void user_add(Player p) {
        if (this.invites.contains(p)) {
            this.invites.remove(p);
        }
        if (!this.players.contains(p)) {
            this.players.add(p);
        }
    }

    public void user_remove(Player p) {
        if (this.players.contains(p)) {
            this.players.remove(p);
        }
        if (this.mods.contains(p)) {
            this.mods.remove(p);
        }
        if (this.leader == p) {
            this.leader_change();
        }
    }

    public List<Player> user_list() {
        return this.getPlayersWhoCanSeeChannel();
    }

    public List<Player> moderator_list() {
        ArrayList<Player> mods2 = new ArrayList<Player>();
        mods2.addAll(this.mods);
        return mods2;
    }

    public void moderator_add(Player p) {
        if (!this.players.contains(p)) {
            this.user_add(p);
        }
        if (!this.mods.contains(p)) {
            this.mods.add(p);
        }
    }

    public void moderator_remove(Player p) {
        if (this.mods.contains(p)) {
            this.mods.remove(p);
        }
    }

    public boolean moderator_canKick() {
        return this.mod_can_kick;
    }

    public boolean moderator_canInvite() {
        return this.mod_can_invite;
    }

    public void moderator_setCanKick(boolean b) {
        this.mod_can_kick = b;
    }

    public void moderator_setCanInvite(boolean b) {
        this.mod_can_invite = b;
    }

    public Player leader_get() {
        return this.leader;
    }

    public void leader_set(Player p) {
        if (p != null) {
            if (!this.players.contains(p)) {
                this.players.add(p);
            }
            if (this.mods.contains(p)) {
                this.mods.remove(p);
            }
        }
        this.leader = p;
    }

    public void leader_change() {
        Player m = this.getModToLeader();
        if (m == null) {
            String msg = Legendchat.getMessageManager().getMessage("tc_msg1").replace("@channel", this.getName());
            for (Player p : this.players) {
                p.sendMessage(msg);
            }
            Legendchat.getChannelManager().deleteChannel(this);
        } else {
            String msg = Legendchat.getMessageManager().getMessage("tc_ch6").replace("@channel", this.getName()).replace("@player", m.getName());
            for (Player p : this.players) {
                p.sendMessage(msg);
            }
            this.leader_set(m);
        }
    }

    private Player getModToLeader() {
        if (this.mods.isEmpty()) {
            return null;
        }
        for (Player p : this.mods) {
            int max_admin = Legendchat.getConfigManager().getTemporaryChannelConfig().getMaxAdminPerPlayer();
            if (max_admin == 0) {
                return p;
            }
            if (Legendchat.getTemporaryChannelManager().getPlayerTempChannelsAdmin(p).size() >= max_admin) continue;
            return p;
        }
        return null;
    }

    @Override
    public void sendMessage(String message) {
        ChannelUtils.otherMessage(this, message);
    }

    @Override
    public void sendMessage(Player sender, String message) {
        ChannelUtils.fakeMessage(this, sender, message);
    }

    @Override
    public void sendMessage(Player sender, String message, String bukkit_format, boolean cancelled) {
        ChannelUtils.realMessage(this, sender, message, bukkit_format, cancelled);
    }

    @Override
    public void setNickname(String n) {
        this.nick = n;
    }

    @Override
    public void setFormat(String n) {
        this.format = n;
    }

    @Override
    public void setColor(ChatColor c) {
        this.color2 = ChannelUtils.translateChatColorToStringColor(c);
        this.color = ChannelUtils.translateStringColor(this.color2);
    }

    @Override
    public void setShortcutAllowed(boolean n) {
        this.shortcut = n;
    }

    @Override
    public void setFocusNeeded(boolean n) {
        this.focus = n;
    }

    @Override
    public void setCrossworlds(boolean n) {
        this.crossworlds = n;
    }

    @Override
    public void setMaxDistance(double n) {
        this.distance = n;
    }

    @Override
    public void setMessageCost(double n) {
        this.cost = n;
    }

    @Override
    public void setCostPerMessage(double n) {
        this.cost = n;
    }

    @Override
    public void setShowCostMessage(boolean n) {
        this.show_cost_msg = n;
    }

    @Override
    public void setDelayPerMessage(int n) {
        this.delay = n;
    }
}

