/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.pluginHooks;

import com.jcdesimp.landlord.Landlord;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHandler {
    private Economy economy = null;

    public VaultHandler() {
        this.setupEconomy();
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = Landlord.getInstance().getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        return this.economy != null;
    }

    public boolean hasEconomy() {
        return this.economy != null;
    }

    private boolean canAfford(Player p, double amt) {
        return this.economy.getBalance(p.getName()) >= amt;
    }

    public boolean chargeCash(Player p, double amt) {
        if (this.canAfford(p, amt)) {
            EconomyResponse r = this.economy.withdrawPlayer(p.getName(), amt);
            return r.transactionSuccess();
        }
        return false;
    }

    public boolean giveCash(Player p, double amt) {
        EconomyResponse r = this.economy.depositPlayer(p.getName(), amt);
        return r.transactionSuccess();
    }

    public String formatCash(double amt) {
        return this.economy.format(amt);
    }
}

