/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.storage.DBCore;
import net.sacredlabyrinth.phaed.simpleclans.threads.ThreadUpdateSQL;

public class MySQLCore
implements DBCore {
    private Logger log;
    private Connection connection;
    private String host;
    private String username;
    private String password;
    private String database;
    private int port;

    public MySQLCore(String host, String database, int port, String username, String password) {
        this.database = database;
        this.port = port;
        this.host = host;
        this.username = username;
        this.password = password;
        this.log = SimpleClans.getLog();
        this.initialize();
    }

    private void initialize() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useUnicode=true&characterEncoding=utf-8", this.username, this.password);
        }
        catch (ClassNotFoundException e) {
            this.log.severe("ClassNotFoundException! " + e.getMessage());
        }
        catch (SQLException e) {
            this.log.severe("SQLException! " + e.getMessage());
        }
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.initialize();
            }
        }
        catch (SQLException e) {
            this.initialize();
        }
        return this.connection;
    }

    @Override
    public Boolean checkConnection() {
        return this.getConnection() != null;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.log.severe("Failed to close database connection! " + e.getMessage());
        }
    }

    @Override
    public ResultSet select(String query) {
        try {
            return this.getConnection().createStatement().executeQuery(query);
        }
        catch (SQLException ex) {
            this.log.severe("Error at SQL Query: " + ex.getMessage());
            this.log.severe("Query: " + query);
            return null;
        }
    }

    @Override
    public void insert(String query) {
        block4: {
            if (SimpleClans.getInstance().getSettingsManager().getUseThreads()) {
                Thread th = new Thread(new ThreadUpdateSQL(this.getConnection(), query, "INSERT"));
                th.start();
            } else {
                try {
                    this.getConnection().createStatement().executeUpdate(query);
                }
                catch (SQLException ex) {
                    if (ex.toString().contains("not return ResultSet")) break block4;
                    this.log.severe("Error at SQL INSERT Query: " + ex);
                    this.log.severe("Query: " + query);
                }
            }
        }
    }

    @Override
    public void update(String query) {
        block4: {
            if (SimpleClans.getInstance().getSettingsManager().getUseThreads()) {
                Thread th = new Thread(new ThreadUpdateSQL(this.getConnection(), query, "UPDATE"));
                th.start();
            } else {
                try {
                    this.getConnection().createStatement().executeUpdate(query);
                }
                catch (SQLException ex) {
                    if (ex.toString().contains("not return ResultSet")) break block4;
                    this.log.severe("Error at SQL UPDATE Query: " + ex);
                    this.log.severe("Query: " + query);
                }
            }
        }
    }

    @Override
    public void delete(String query) {
        block4: {
            if (SimpleClans.getInstance().getSettingsManager().getUseThreads()) {
                Thread th = new Thread(new ThreadUpdateSQL(this.getConnection(), query, "DELETE"));
                th.start();
            } else {
                try {
                    this.getConnection().createStatement().executeUpdate(query);
                }
                catch (SQLException ex) {
                    if (ex.toString().contains("not return ResultSet")) break block4;
                    this.log.severe("Error at SQL DELETE Query: " + ex);
                    this.log.severe("Query: " + query);
                }
            }
        }
    }

    @Override
    public Boolean execute(String query) {
        try {
            this.getConnection().createStatement().execute(query);
            return true;
        }
        catch (SQLException ex) {
            this.log.severe(ex.getMessage());
            this.log.severe("Query: " + query);
            return false;
        }
    }

    @Override
    public Boolean existsTable(String table) {
        try {
            ResultSet tables = this.getConnection().getMetaData().getTables(null, null, table, null);
            return tables.next();
        }
        catch (SQLException e) {
            this.log.severe("Failed to check if table " + table + " exists: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean existsColumn(String table, String column) {
        try {
            ResultSet col = this.getConnection().getMetaData().getColumns(null, null, table, column);
            return col.next();
        }
        catch (Exception e) {
            this.log.severe("Failed to check if column " + column + " exists in table " + table + " : " + e.getMessage());
            return false;
        }
    }
}

