/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CoordsCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        String headColor = plugin.getSettingsManager().getPageHeadingsColor();
        String subColor = plugin.getSettingsManager().getPageSubTitleColor();
        if (plugin.getPermissionsManager().has(player, "simpleclans.member.coords")) {
            ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
            if (cp != null) {
                Clan clan = cp.getClan();
                if (clan.isVerified()) {
                    if (cp.isTrusted()) {
                        if (arg.length == 0) {
                            ChatBlock chatBlock = new ChatBlock();
                            chatBlock.setFlexibility(true, false, false, false);
                            chatBlock.setAlignment("l", "c", "c", "c");
                            chatBlock.addRow("  " + headColor + plugin.getLang("name"), plugin.getLang("distance"), plugin.getLang("coords.upper"), plugin.getLang("world"));
                            List<ClanPlayer> members = Helper.stripOffLinePlayers(clan.getMembers());
                            TreeMap rows = new TreeMap();
                            for (ClanPlayer cpm : members) {
                                Player p = cpm.toPlayer();
                                if (p == null) continue;
                                String name = (cpm.isLeader() ? plugin.getSettingsManager().getPageLeaderColor() : (cpm.isTrusted() ? plugin.getSettingsManager().getPageTrustedColor() : plugin.getSettingsManager().getPageUnTrustedColor())) + cpm.getName();
                                Location loc = p.getLocation();
                                int distance = (int)Math.ceil(loc.toVector().distance(player.getLocation().toVector()));
                                String coords = loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ();
                                String world = loc.getWorld().getName();
                                ArrayList<String> cols = new ArrayList<String>();
                                cols.add("  " + name);
                                cols.add(ChatColor.AQUA + "" + distance);
                                cols.add(ChatColor.WHITE + "" + coords);
                                cols.add(world);
                                rows.put(distance, cols);
                            }
                            if (!rows.isEmpty()) {
                                for (List col : rows.values()) {
                                    chatBlock.addRow((String)col.get(0), (String)col.get(1), (String)col.get(2), (String)col.get(3));
                                }
                                ChatBlock.sendBlank((CommandSender)player);
                                ChatBlock.saySingle((CommandSender)player, plugin.getSettingsManager().getPageClanNameColor() + Helper.capitalize(clan.getName()) + subColor + " " + plugin.getLang("coords") + " " + headColor + Helper.generatePageSeparator(plugin.getSettingsManager().getPageSep()));
                                ChatBlock.sendBlank((CommandSender)player);
                                boolean more = chatBlock.sendBlock((CommandSender)player, plugin.getSettingsManager().getPageSize());
                                if (more) {
                                    plugin.getStorageManager().addChatBlock((CommandSender)player, chatBlock);
                                    ChatBlock.sendBlank((CommandSender)player);
                                    ChatBlock.sendMessage((CommandSender)player, headColor + MessageFormat.format(plugin.getLang("view.next.page"), plugin.getSettingsManager().getCommandMore()));
                                }
                                ChatBlock.sendBlank((CommandSender)player);
                            } else {
                                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("you.are.the.only.member.online"));
                            }
                        } else {
                            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.0.coords"), plugin.getSettingsManager().getCommandClan()));
                        }
                    } else {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("only.trusted.players.can.access.clan.coords"));
                    }
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("clan.is.not.verified"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
            }
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
        }
    }
}

