/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.server.v1_11_R1.PacketCompressor;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.utils.netty.Compressor;

public class SpigotPacketCompressor
extends PacketCompressor {
    private final Compressor compressor = Compressor.create();
    private final int threshold;

    public SpigotPacketCompressor(int threshold) {
        super(threshold);
        this.threshold = threshold;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.compressor.recycle();
    }

    protected void a(ChannelHandlerContext ctx, ByteBuf from, ByteBuf to) {
        int readable = from.readableBytes();
        if (readable == 0) {
            return;
        }
        if (readable < this.threshold) {
            ProtocolSupportPacketDataSerializer.writeVarInt(to, 0);
            to.writeBytes(from);
        } else {
            ProtocolSupportPacketDataSerializer.writeVarInt(to, readable);
            to.writeBytes(this.compressor.compress(ProtocolSupportPacketDataSerializer.toArray(from)));
        }
    }
}

