/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone.itemstack;

import java.util.Objects;
import net.glowstone.inventory.GlowItemFactory;
import net.glowstone.util.InventoryUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import protocolsupport.zplatform.impl.glowstone.itemstack.GlowStoneNBTTagCompoundWrapper;
import protocolsupport.zplatform.itemstack.ItemStackWrapper;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;

public class GlowStoneItemStackWrapper
extends ItemStackWrapper {
    protected final ItemStack itemstack;

    protected GlowStoneItemStackWrapper(ItemStack itemstack) {
        this.itemstack = itemstack;
    }

    public static ItemStackWrapper createNull() {
        return new GlowStoneItemStackWrapper(InventoryUtil.createEmptyStack());
    }

    public static ItemStackWrapper create(int typeId) {
        return new GlowStoneItemStackWrapper(new ItemStack(typeId));
    }

    @Override
    public ItemStack asBukkitMirror() {
        return this.itemstack;
    }

    @Override
    public boolean isNull() {
        return this.itemstack.getType() == Material.AIR || this.getAmount() <= 0 || this.getData() < Short.MIN_VALUE || this.getData() > 65535;
    }

    @Override
    public int getTypeId() {
        return this.itemstack.getTypeId();
    }

    @Override
    public void setTypeId(int typeId) {
        this.itemstack.setTypeId(typeId);
    }

    @Override
    public int getData() {
        return this.itemstack.getDurability();
    }

    @Override
    public void setData(int data) {
        this.itemstack.setDurability((short)data);
    }

    @Override
    public int getAmount() {
        return this.itemstack.getAmount();
    }

    @Override
    public void setAmount(int amount) {
        this.itemstack.setAmount(amount);
    }

    @Override
    public void setDisplayName(String displayName) {
        ItemMeta meta = this.itemstack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(this.getType());
        }
        if (meta != null) {
            meta.setDisplayName(displayName);
            this.itemstack.setItemMeta(meta);
        }
    }

    @Override
    public NBTTagCompoundWrapper getTag() {
        return GlowStoneNBTTagCompoundWrapper.wrap(GlowItemFactory.instance().writeNbt(this.itemstack.getItemMeta()));
    }

    @Override
    public void setTag(NBTTagCompoundWrapper tag) {
        this.itemstack.setItemMeta(GlowItemFactory.instance().readNbt(this.getType(), ((GlowStoneNBTTagCompoundWrapper)tag).tag));
    }

    @Override
    public ItemStackWrapper cloneItemStack() {
        return new GlowStoneItemStackWrapper(this.itemstack.clone());
    }

    public int hashCode() {
        return this.itemstack != null ? this.itemstack.hashCode() : 0;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof GlowStoneItemStackWrapper)) {
            return false;
        }
        GlowStoneItemStackWrapper other = (GlowStoneItemStackWrapper)otherObj;
        return Objects.equals(this.itemstack, other.itemstack);
    }

    public String toString() {
        return String.valueOf(this.itemstack);
    }
}

