/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.utils.recyclable;

import io.netty.util.Recycler;
import java.util.ArrayList;
import protocolsupport.utils.recyclable.Recyclable;
import protocolsupport.utils.recyclable.RecyclableCollection;

public class RecyclableArrayList<E>
extends ArrayList<E>
implements RecyclableCollection<E> {
    private static final long serialVersionUID = 1L;
    private static final Recycler<RecyclableArrayList> RECYCLER = new Recycler<RecyclableArrayList>(){

        protected RecyclableArrayList newObject(Recycler.Handle handle) {
            return new RecyclableArrayList(handle);
        }
    };
    private final Recycler.Handle handle;

    public static <T> RecyclableArrayList<T> create() {
        return (RecyclableArrayList)RECYCLER.get();
    }

    private RecyclableArrayList(Recycler.Handle handle) {
        this.handle = handle;
    }

    @Override
    public void recycle() {
        for (Object element : this) {
            if (!(element instanceof Recyclable)) continue;
            ((Recyclable)element).recycle();
        }
        this.recycleObjectOnly();
    }

    @Override
    public void recycleObjectOnly() {
        this.clear();
        RECYCLER.recycle((Object)this, this.handle);
    }
}

