/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.authlib;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.libs.com.google.gson.JsonArray;
import protocolsupport.libs.com.google.gson.JsonElement;
import protocolsupport.libs.com.google.gson.JsonObject;
import protocolsupport.libs.com.google.gson.JsonParser;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.protocol.utils.authlib.UUIDTypeAdapter;
import protocolsupport.utils.JsonUtils;

public class MinecraftSessionService {
    private static final String hasJoinedUrl = "https://sessionserver.mojang.com/session/minecraft/hasJoined";

    public static GameProfile hasJoinedServer(String name, String hash) throws AuthenticationUnavailableException, MalformedURLException {
        URL url = new URL("https://sessionserver.mojang.com/session/minecraft/hasJoined?username=" + name + "&serverId=" + hash);
        try {
            JsonObject root = new JsonParser().parse(new InputStreamReader(url.openStream())).getAsJsonObject();
            String rname = JsonUtils.getString(root, "name");
            UUID ruuid = UUIDTypeAdapter.fromString(JsonUtils.getString(root, "id"));
            GameProfile profile = new GameProfile(ruuid, rname);
            JsonArray properties = JsonUtils.getJsonArray(root, "properties");
            for (JsonElement property : properties) {
                JsonObject propertyobj = property.getAsJsonObject();
                profile.addProperty(new PlayerPropertiesResolveEvent.ProfileProperty(JsonUtils.getString(propertyobj, "name"), JsonUtils.getString(propertyobj, "value"), JsonUtils.getString(propertyobj, "signature")));
            }
            return profile;
        }
        catch (IOException e) {
            throw new AuthenticationUnavailableException();
        }
    }

    public static class AuthenticationUnavailableException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

