/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeskipper.id;

import java.util.EnumMap;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.typeskipper.id.SkippingTable;

public abstract class SkippingRegistry<T extends SkippingTable> {
    private final EnumMap<ProtocolVersion, T> registry = new EnumMap(ProtocolVersion.class);

    public SkippingRegistry() {
        for (ProtocolVersion version : ProtocolVersion.values()) {
            this.registry.put(version, this.createTable());
        }
    }

    public T getTable(ProtocolVersion version) {
        return (T)((SkippingTable)this.registry.get((Object)version));
    }

    protected abstract T createTable();

    public static abstract class GenericSkippingRegistry<T, R extends SkippingTable.GenericSkippingTable<T>>
    extends SkippingRegistry<R> {
        public void registerSkipEntry(T id, ProtocolVersion ... versions) {
            for (ProtocolVersion version : versions) {
                ((SkippingTable.GenericSkippingTable)this.getTable(version)).setSkip(id);
            }
        }
    }

    public static abstract class IntSkippingRegistry<T extends SkippingTable.IntSkippingTable>
    extends SkippingRegistry<T> {
        public void registerSkipEntry(int id, ProtocolVersion ... versions) {
            for (ProtocolVersion version : versions) {
                ((SkippingTable.IntSkippingTable)this.getTable(version)).setSkip(id);
            }
        }
    }
}

