/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.watchedentity.remapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.EntityType;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.MappingEntry;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapper;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapperBooleanToByte;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapperNoOp;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapperNumberToByte;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapperNumberToInt;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapperNumberToShort;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapperStringClamp;
import protocolsupport.protocol.utils.datawatcher.DataWatcherObject;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectBlockState;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectBoolean;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectByte;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectInt;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectShort;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectVarInt;
import protocolsupport.utils.ProtocolVersionsHelper;

public enum SpecificRemapper {
    NONE(EType.NONE, -1, new Mapping[0]),
    ENTITY(EType.NONE, -1, new Mapping(0).addRemap(0, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL), new Mapping(1).addRemap(1, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_9__1_11).addRemap(1, ValueRemapperNumberToShort.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(2).addRemap(2, ValueRemapperNoOp.STRING, ProtocolVersionsHelper.RANGE__1_9__1_11), new Mapping(3).addRemap(3, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_9__1_11), new Mapping(4).addRemap(4, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_9__1_11), new Mapping(5).addRemap(5, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11)),
    LIVING(EType.NONE, -1, ENTITY, new Mapping(2).addRemap(2, ValueRemapperNoOp.STRING, ProtocolVersion.MINECRAFT_1_8).addRemap(10, new ValueRemapperStringClamp(64), ProtocolVersionsHelper.RANGE__1_6__1_7).addRemap(5, new ValueRemapperStringClamp(64), ProtocolVersionsHelper.BEFORE_1_6), new Mapping(3).addRemap(3, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersion.MINECRAFT_1_8).addRemap(11, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.RANGE__1_6__1_7).addRemap(6, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_6), new Mapping(6).addRemap(6, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9), new Mapping(7).addRemap(7, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(6, ValueRemapperNoOp.FLOAT, ProtocolVersion.getAllBetween(ProtocolVersion.MINECRAFT_1_9_4, ProtocolVersion.MINECRAFT_1_6_1)), new Mapping(8).addRemap(8, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(7, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(7, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.RANGE__1_6__1_7).addRemap(8, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_6), new Mapping(9).addRemap(9, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(8, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(8, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.RANGE__1_6__1_7).addRemap(9, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_6), new Mapping(10).addRemap(10, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(9, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(9, ValueRemapperNumberToByte.INSTANCE, ProtocolVersionsHelper.RANGE__1_6__1_7).addRemap(10, ValueRemapperNumberToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_6)),
    INSENTIENT(EType.NONE, -1, LIVING, new Mapping(11).addRemap(11, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(10, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(15, ValueRemapperNoOp.BYTE, ProtocolVersion.MINECRAFT_1_8)),
    PLAYER(EType.NONE, -1, LIVING, new Mapping(11).addRemap(11, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(10, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.ALL_1_9).addRemap(17, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(12).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(13).addRemap(13, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(10, ValueRemapperNoOp.BYTE, ProtocolVersion.getAllBetween(ProtocolVersion.MINECRAFT_1_8, ProtocolVersion.MINECRAFT_1_6_1))),
    AGEABLE(EType.NONE, -1, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(12, new ValueRemapper<DataWatcherObjectBoolean>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBoolean object) {
            return new DataWatcherObjectByte((byte)((Boolean)object.getValue() != false ? -1 : 0));
        }
    }, ProtocolVersion.MINECRAFT_1_8).addRemap(12, new ValueRemapper<DataWatcherObjectBoolean>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBoolean object) {
            return new DataWatcherObjectInt((Boolean)object.getValue() != false ? -1 : 0);
        }
    }, ProtocolVersionsHelper.BEFORE_1_8), new Mapping(30).addRemap(12, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.RANGE__1_6__1_7)),
    TAMEABLE(EType.NONE, -1, AGEABLE, new Mapping(13).addRemap(13, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.BEFORE_1_9)),
    ARMOR_STAND(EType.NONE, -1, LIVING, new Mapping(11).addRemap(11, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(10, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_8__1_9), new Mapping(12).addRemap(12, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_8__1_9), new Mapping(13).addRemap(13, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_8__1_9), new Mapping(14).addRemap(14, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(13, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_8__1_9), new Mapping(15).addRemap(15, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(14, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_8__1_9), new Mapping(16).addRemap(16, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(15, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_8__1_9), new Mapping(17).addRemap(17, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(16, ValueRemapperNoOp.VECTOR3F, ProtocolVersionsHelper.RANGE__1_8__1_9)),
    COW(EType.MOB, EntityType.COW, AGEABLE, new Mapping[0]),
    MUSHROOM_COW(EType.MOB, EntityType.MUSHROOM_COW, COW, new Mapping[0]),
    CHICKEN(EType.MOB, EntityType.CHICKEN, AGEABLE, new Mapping[0]),
    SQUID(EType.MOB, EntityType.SQUID, INSENTIENT, new Mapping[0]),
    BASE_HORSE(EType.NONE, -1, AGEABLE, new Mapping(13).addRemap(13, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(17, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    BATTLE_HORSE(EType.NONE, -1, BASE_HORSE, new Mapping(15).addRemap(15, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(14, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(20, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(16).addRemap(16, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_11).addRemap(17, ValueRemapperNoOp.VARINT, ProtocolVersion.MINECRAFT_1_10).addRemap(16, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(22, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    CARGO_HORSE(EType.NONE, -1, BASE_HORSE, new Mapping(15).addRemap(15, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_11)),
    COMMON_HORSE(EType.MOB, EntityType.HORSE, BATTLE_HORSE, new Mapping[0]),
    ZOMBIE_HORSE(EType.MOB, EntityType.ZOMBIE_HORSE, BATTLE_HORSE, new Mapping[0]),
    SKELETON_HORSE(EType.MOB, EntityType.SKELETON_HORSE, BATTLE_HORSE, new Mapping[0]),
    DONKEY(EType.MOB, EntityType.DONKEY, CARGO_HORSE, new Mapping[0]),
    MULE(EType.MOB, EntityType.MULE, CARGO_HORSE, new Mapping[0]),
    LAMA(EType.MOB, EntityType.LLAMA, CARGO_HORSE, new Mapping(16).addRemap(16, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_11), new Mapping(17).addRemap(17, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_11), new Mapping(18).addRemap(18, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_11)),
    BAT(EType.MOB, EntityType.BAT, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.BEFORE_1_9)),
    OCELOT(EType.MOB, EntityType.OCELOT, TAMEABLE, new Mapping(15).addRemap(15, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(14, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperNumberToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    WOLF(EType.MOB, EntityType.WOLF, TAMEABLE, new Mapping(15).addRemap(15, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(14, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperNoOp.FLOAT, ProtocolVersion.getAllBetween(ProtocolVersion.MINECRAFT_1_8, ProtocolVersion.MINECRAFT_1_6_1)).addRemap(18, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_6), new Mapping(16).addRemap(16, ValueRemapperNoOp.BOOLEAN, ProtocolVersion.MINECRAFT_1_10).addRemap(15, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(19, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(17).addRemap(17, ValueRemapperNoOp.VARINT, ProtocolVersion.MINECRAFT_1_10).addRemap(16, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(20, ValueRemapperNumberToByte.INSTANCE, ProtocolVersion.MINECRAFT_1_8).addRemap(20, new ValueRemapper<DataWatcherObjectVarInt>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectVarInt object) {
            return new DataWatcherObjectByte((byte)(15 - (Integer)object.getValue()));
        }
    }, ProtocolVersionsHelper.BEFORE_1_8)),
    PIG(EType.MOB, EntityType.PIG, AGEABLE, new Mapping(13).addRemap(13, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(14).addRemap(14, ValueRemapperNoOp.VARINT, ProtocolVersion.MINECRAFT_1_11_1)),
    RABBIT(EType.MOB, EntityType.RABBIT, AGEABLE, new Mapping(13).addRemap(13, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperNumberToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    SHEEP(EType.MOB, EntityType.SHEEP, AGEABLE, new Mapping(13).addRemap(13, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.BEFORE_1_9)),
    POLAR_BEAR(EType.MOB, EntityType.POLAR_BEAR, AGEABLE, new Mapping(13).addRemap(13, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11)),
    VILLAGER(EType.MOB, EntityType.VILLAGER, AGEABLE, new Mapping(13).addRemap(13, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    ENDERMAN(EType.MOB, EntityType.ENDERMAN, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BLOCKSTATE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BLOCKSTATE, ProtocolVersionsHelper.ALL_1_9).addRemap(16, new ValueRemapper<DataWatcherObjectBlockState>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBlockState object) {
            return new DataWatcherObjectShort((short)((Integer)object.getValue() >> 4));
        }
    }, ProtocolVersion.MINECRAFT_1_8).addRemap(16, new ValueRemapper<DataWatcherObjectBlockState>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBlockState object) {
            return new DataWatcherObjectByte((byte)((Integer)object.getValue() >> 4));
        }
    }, ProtocolVersionsHelper.BEFORE_1_8).addRemap(17, new ValueRemapper<DataWatcherObjectBlockState>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBlockState object) {
            return new DataWatcherObjectByte((byte)((Integer)object.getValue() & 0xF));
        }
    }, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(13).addRemap(13, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    GIANT(EType.MOB, EntityType.GIANT, INSENTIENT, new Mapping[0]),
    SILVERFISH(EType.MOB, EntityType.SILVERFISH, INSENTIENT, new Mapping[0]),
    ENDERMITE(EType.MOB, EntityType.ENDERMITE, INSENTIENT, new Mapping[0]),
    ENDER_DRAGON(EType.MOB, EntityType.ENDER_DRAGON, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9)),
    SNOWMAN(EType.MOB, EntityType.SNOWMAN, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9)),
    ZOMBIE(EType.MOB, EntityType.ZOMBIE, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(12, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(13).addRemap(13, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(13, ValueRemapperNumberToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(14).addRemap(14, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_11).addRemap(15, ValueRemapperNoOp.BOOLEAN, ProtocolVersion.MINECRAFT_1_10).addRemap(14, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9)),
    ZOMBIE_VILLAGER(EType.MOB, EntityType.ZOMBIE_VILLAGER, ZOMBIE, new Mapping(15).addRemap(15, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_11).addRemap(14, ValueRemapperNoOp.BOOLEAN, ProtocolVersion.MINECRAFT_1_10).addRemap(13, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(14, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    HUSK(EType.MOB, EntityType.HUSK, ZOMBIE, new Mapping[0]),
    ZOMBIE_PIGMAN(EType.MOB, EntityType.PIG_ZOMBIE, ZOMBIE, new Mapping[0]),
    BLAZE(EType.MOB, EntityType.BLAZE, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.BEFORE_1_9)),
    SPIDER(EType.MOB, EntityType.SPIDER, LIVING, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.BEFORE_1_9)),
    CAVE_SPIDER(EType.MOB, EntityType.CAVE_SPIDER, SPIDER, new Mapping[0]),
    CREEPER(EType.MOB, EntityType.CREEPER, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNumberToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(13).addRemap(13, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(17, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(14).addRemap(14, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(13, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    GHAST(EType.MOB, EntityType.GHAST, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    SLIME(EType.MOB, EntityType.SLIME, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNumberToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    MAGMA_CUBE(EType.MOB, EntityType.MAGMA_CUBE, SLIME, new Mapping[0]),
    BASE_SKELETON(EType.NONE, -1, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_11).addRemap(13, ValueRemapperNoOp.BOOLEAN, ProtocolVersion.MINECRAFT_1_10).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9)),
    SKELETON(EType.MOB, EntityType.SKELETON, BASE_SKELETON, new Mapping[0]),
    WITHER_SKELETON(EType.MOB, EntityType.WITHER_SKELETON, BASE_SKELETON, new Mapping[0]),
    STRAY(EType.MOB, EntityType.STRAY, BASE_SKELETON, new Mapping[0]),
    WITCH(EType.MOB, EntityType.WITCH, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    IRON_GOLEM(EType.MOB, EntityType.IRON_GOLEM, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(16, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.BEFORE_1_9)),
    SHULKER(EType.MOB, 69, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.DIRECTION, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.DIRECTION, ProtocolVersionsHelper.ALL_1_9), new Mapping(13).addRemap(13, ValueRemapperNoOp.OPTIONAL_POSITION, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.OPTIONAL_POSITION, ProtocolVersionsHelper.ALL_1_9), new Mapping(14).addRemap(14, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(13, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9), new Mapping(15).addRemap(15, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_11)),
    WITHER(EType.MOB, EntityType.WITHER, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(11, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(17, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(13).addRemap(13, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(14).addRemap(14, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(13, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(19, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(15).addRemap(15, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(14, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(20, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    GUARDIAN(EType.MOB, EntityType.GUARDIAN, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_11).addRemap(12, new ValueRemapper<DataWatcherObjectBoolean>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBoolean object) {
            return new DataWatcherObjectByte((Boolean)object.getValue() != false ? (byte)2 : 0);
        }
    }, ProtocolVersion.MINECRAFT_1_10).addRemap(11, new ValueRemapper<DataWatcherObjectBoolean>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBoolean object) {
            return new DataWatcherObjectByte((Boolean)object.getValue() != false ? (byte)2 : 0);
        }
    }, ProtocolVersionsHelper.ALL_1_9).addRemap(16, new ValueRemapper<DataWatcherObjectBoolean>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectBoolean object) {
            return new DataWatcherObjectInt((Boolean)object.getValue() != false ? 2 : 0);
        }
    }, ProtocolVersion.MINECRAFT_1_8), new Mapping(13).addRemap(13, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(12, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(17, ValueRemapperNumberToInt.INSTANCE, ProtocolVersion.MINECRAFT_1_8)),
    ELDER_GUARDIAN(EType.MOB, EntityType.ELDER_GUARDIAN, GUARDIAN, new Mapping[0]),
    VINDICATOR(EType.MOB, EntityType.VINDICATOR, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_11)),
    EVOKER(EType.MOB, EntityType.EVOKER, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_11)),
    VEX(EType.MOB, EntityType.VEX, INSENTIENT, new Mapping(12).addRemap(12, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_11)),
    ARMOR_STAND_MOB(EType.MOB, EntityType.ARMOR_STAND, ARMOR_STAND, new Mapping[0]),
    BOAT(EType.OBJECT, 1, new Mapping(6).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersion.MINECRAFT_1_10).addRemap(5, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(17, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(7).addRemap(7, ValueRemapperNoOp.VARINT, ProtocolVersion.MINECRAFT_1_10).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(8).addRemap(8, ValueRemapperNoOp.FLOAT, ProtocolVersion.MINECRAFT_1_10).addRemap(7, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.ALL_1_9).addRemap(19, ValueRemapperNoOp.FLOAT, ProtocolVersion.getAllBetween(ProtocolVersion.MINECRAFT_1_8, ProtocolVersion.MINECRAFT_1_6_1)).addRemap(19, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_6), new Mapping(9).addRemap(9, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11), new Mapping(10).addRemap(10, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11), new Mapping(11).addRemap(11, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11)),
    TNT(EType.OBJECT, 50, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9)),
    SNOWBALL(EType.OBJECT, 61, ENTITY, new Mapping[0]),
    EGG(EType.OBJECT, 62, ENTITY, new Mapping[0]),
    FIREBALL(EType.OBJECT, 63, ENTITY, new Mapping[0]),
    FIRECHARGE(EType.OBJECT, 64, ENTITY, new Mapping[0]),
    ENDERPEARL(EType.OBJECT, 65, ENTITY, new Mapping[0]),
    WITHER_SKULL(EType.OBJECT, 66, FIREBALL, new Mapping(6).addRemap(6, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(10, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9)),
    FALLING_OBJECT(EType.OBJECT, 70, ENTITY, new Mapping[0]),
    ENDEREYE(EType.OBJECT, 72, ENTITY, new Mapping[0]),
    POTION(EType.OBJECT, 73, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(7, ValueRemapperNoOp.ITEMSTACK, ProtocolVersion.MINECRAFT_1_10).addRemap(6, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.ALL_1_9)),
    DRAGON_EGG(EType.OBJECT, 74, ENTITY, new Mapping[0]),
    EXP_BOTTLE(EType.OBJECT, 75, ENTITY, new Mapping[0]),
    LEASH_KNOT(EType.OBJECT, 77, ENTITY, new Mapping[0]),
    FISHING_FLOAT(EType.OBJECT, 90, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9)),
    ITEM(EType.OBJECT, 2, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.ALL_1_9).addRemap(10, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.BEFORE_1_9)),
    MINECART(EType.OBJECT, 10, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(17, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(7).addRemap(7, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(18, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(10).addRemap(10, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(9, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(21, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(11).addRemap(11, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(10, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9).addRemap(22, ValueRemapperBooleanToByte.INSTANCE, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(8).addRemap(8, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(7, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.ALL_1_9).addRemap(19, ValueRemapperNoOp.FLOAT, ProtocolVersion.getAllBetween(ProtocolVersion.MINECRAFT_1_8, ProtocolVersion.MINECRAFT_1_6_1)).addRemap(19, ValueRemapperNumberToInt.INSTANCE, ProtocolVersionsHelper.BEFORE_1_6), new Mapping(9).addRemap(9, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(8, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(20, ValueRemapperNumberToInt.INSTANCE, ProtocolVersion.MINECRAFT_1_8).addRemap(20, new ValueRemapper<DataWatcherObjectVarInt>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectVarInt object) {
            int value = (Integer)object.getValue();
            int id = value & 0xFFFF;
            int data = value >> 12;
            return new DataWatcherObjectInt(data << 16 | id);
        }
    }, ProtocolVersionsHelper.BEFORE_1_6), new Mapping(12).addRemap(12, new ValueRemapper<DataWatcherObject<?>>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObject<?> object) {
            return object;
        }
    }, ProtocolVersionsHelper.ALL_1_11), new Mapping(13).addRemap(13, ValueRemapperNoOp.STRING, ProtocolVersionsHelper.ALL_1_11)),
    ARROW(EType.OBJECT, 60, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.ALL_1_9).addRemap(15, ValueRemapperNoOp.BYTE, ProtocolVersionsHelper.BEFORE_1_9)),
    SPECTRAL_ARROW(EType.OBJECT, 91, ARROW, new Mapping[0]),
    TIPPED_ARROW(EType.OBJECT, 92, ARROW, new Mapping(7).addRemap(7, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9)),
    FIREWORK(EType.OBJECT, 76, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.ALL_1_9).addRemap(8, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.BEFORE_1_9), new Mapping(7).addRemap(7, ValueRemapperNoOp.VARINT, ProtocolVersion.MINECRAFT_1_11_1)),
    ITEM_FRAME(EType.OBJECT, 71, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.ALL_1_9).addRemap(8, ValueRemapperNoOp.ITEMSTACK, ProtocolVersion.MINECRAFT_1_8).addRemap(2, ValueRemapperNoOp.ITEMSTACK, ProtocolVersionsHelper.BEFORE_1_8), new Mapping(7).addRemap(7, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9).addRemap(9, ValueRemapperNumberToByte.INSTANCE, ProtocolVersion.MINECRAFT_1_8).addRemap(3, new ValueRemapper<DataWatcherObjectVarInt>(){

        @Override
        public DataWatcherObject<?> remap(DataWatcherObjectVarInt object) {
            return new DataWatcherObjectByte((byte)((Integer)object.getValue() >> 1));
        }
    }, ProtocolVersionsHelper.BEFORE_1_8)),
    ENDER_CRYSTAL(EType.OBJECT, 51, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.OPTIONAL_POSITION, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.OPTIONAL_POSITION, ProtocolVersionsHelper.ALL_1_9), new Mapping(7).addRemap(7, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(6, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9)),
    ARMOR_STAND_OBJECT(EType.OBJECT, 78, ARMOR_STAND, new Mapping[0]),
    AREA_EFFECT_CLOUD(EType.OBJECT, 3, ENTITY, new Mapping(6).addRemap(6, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(5, ValueRemapperNoOp.FLOAT, ProtocolVersionsHelper.ALL_1_9), new Mapping(7).addRemap(7, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(6, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9), new Mapping(8).addRemap(8, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(7, ValueRemapperNoOp.BOOLEAN, ProtocolVersionsHelper.ALL_1_9), new Mapping(9).addRemap(9, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(8, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9), new Mapping(10).addRemap(10, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(9, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9), new Mapping(11).addRemap(11, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.RANGE__1_10__1_11).addRemap(10, ValueRemapperNoOp.VARINT, ProtocolVersionsHelper.ALL_1_9)),
    SHULKER_BULLET(EType.OBJECT, 67, ENTITY, new Mapping[0]),
    DRAGON_FIREBALL(EType.OBJECT, 93, ENTITY, new Mapping[0]),
    EVOCATOR_FANGS(EType.OBJECT, 79, ENTITY, new Mapping[0]);

    private static final SpecificRemapper[] OBJECT_BY_TYPE_ID;
    private static final SpecificRemapper[] MOB_BY_TYPE_ID;
    private final EType etype;
    private final int typeId;
    private final EnumMap<ProtocolVersion, ArrayList<MappingEntry>> entries = new EnumMap(ProtocolVersion.class);

    public static SpecificRemapper getObjectByTypeId(int objectTypeId) {
        return OBJECT_BY_TYPE_ID[objectTypeId];
    }

    public static SpecificRemapper getMobByTypeId(int mobTypeId) {
        return MOB_BY_TYPE_ID[mobTypeId];
    }

    private SpecificRemapper(EType etype, EntityType type, Mapping ... entries) {
        this(etype, (int)type.getTypeId(), entries);
    }

    private SpecificRemapper(EType etype, int typeId, Mapping ... entries) {
        for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
            this.entries.put(protocolVersion, new ArrayList());
        }
        for (Mapping mapping : entries) {
            for (Mapping.Entry entry : mapping.entries) {
                for (ProtocolVersion version : entry.versions) {
                    this.entries.get((Object)version).add(new MappingEntry(mapping.idFrom, entry.idTo, entry.vremap));
                }
            }
        }
        this.etype = etype;
        this.typeId = typeId;
    }

    private SpecificRemapper(EType etype, EntityType type, SpecificRemapper superType, Mapping ... entries) {
        this(etype, (int)type.getTypeId(), superType, entries);
    }

    private SpecificRemapper(EType etype, int typeId, SpecificRemapper superType, Mapping ... entries) {
        this(etype, typeId, entries);
        for (Map.Entry<ProtocolVersion, ArrayList<MappingEntry>> entry : superType.entries.entrySet()) {
            this.entries.get((Object)entry.getKey()).addAll((Collection<MappingEntry>)entry.getValue());
        }
    }

    public List<MappingEntry> getRemaps(ProtocolVersion version) {
        return this.entries.get((Object)version);
    }

    public static void init() {
    }

    static {
        OBJECT_BY_TYPE_ID = new SpecificRemapper[256];
        MOB_BY_TYPE_ID = new SpecificRemapper[256];
        Arrays.fill((Object[])OBJECT_BY_TYPE_ID, (Object)NONE);
        Arrays.fill((Object[])MOB_BY_TYPE_ID, (Object)NONE);
        block4: for (SpecificRemapper type : SpecificRemapper.values()) {
            switch (type.etype) {
                case OBJECT: {
                    SpecificRemapper.OBJECT_BY_TYPE_ID[type.typeId] = type;
                    continue block4;
                }
                case MOB: {
                    SpecificRemapper.MOB_BY_TYPE_ID[type.typeId] = type;
                    continue block4;
                }
            }
        }
    }

    private static class Mapping {
        private final int idFrom;
        private final List<Entry> entries = new ArrayList<Entry>();

        public Mapping(int idFrom) {
            this.idFrom = idFrom;
        }

        public Mapping addRemap(int to, ValueRemapper<?> valueremap, ProtocolVersion ... versions) {
            this.entries.add(new Entry(to, valueremap, versions));
            return this;
        }

        private static class Entry {
            private final int idTo;
            private final ValueRemapper<?> vremap;
            private final ProtocolVersion[] versions;

            public Entry(int to, ValueRemapper<?> vremap, ProtocolVersion[] versions) {
                this.idTo = to;
                this.vremap = vremap;
                this.versions = versions;
            }
        }
    }

    private static enum EType {
        NONE,
        OBJECT,
        MOB;

    }
}

