/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.watchedentity;

import protocolsupport.api.ProtocolVersion;
import protocolsupport.libs.gnu.trove.map.TIntObjectMap;
import protocolsupport.libs.gnu.trove.map.hash.TIntObjectHashMap;
import protocolsupport.protocol.storage.NetworkDataCache;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.MappingEntry;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.SpecificRemapper;
import protocolsupport.protocol.typeremapper.watchedentity.remapper.value.ValueRemapper;
import protocolsupport.protocol.typeremapper.watchedentity.types.WatchedEntity;
import protocolsupport.protocol.utils.datawatcher.DataWatcherObject;
import protocolsupport.protocol.utils.datawatcher.objects.DataWatcherObjectByte;
import protocolsupport.utils.Utils;

public class WatchedDataRemapper {
    private static final TIntObjectMap<DataWatcherObject<?>> EMPTY_MAP = new TIntObjectHashMap();

    public static TIntObjectMap<DataWatcherObject<?>> transform(NetworkDataCache cache, int entityId, TIntObjectMap<DataWatcherObject<?>> originaldata, ProtocolVersion to) {
        WatchedEntity entity = cache.getWatchedEntity(entityId);
        if (entity == null) {
            return EMPTY_MAP;
        }
        if (entity.getType() == SpecificRemapper.PLAYER) {
            DataWatcherObject<?> activehandflags;
            DataWatcherObject<?> baseflags = originaldata.get(0);
            if (baseflags != null && baseflags.getValue() instanceof Number) {
                cache.addWatchedEntityBaseMeta(entityId, ((Number)baseflags.getValue()).byteValue());
            }
            if ((activehandflags = originaldata.get(6)) != null && activehandflags.getValue() instanceof Number) {
                byte activehandvalue = ((Number)activehandflags.getValue()).byteValue();
                byte basevalue = cache.getWatchedEntityBaseMeta(entityId);
                switch (activehandvalue) {
                    case 1: {
                        basevalue = (byte)(basevalue | 0x10);
                        break;
                    }
                    case 0: {
                        basevalue = (byte)(basevalue & 0xFFFFFFEF);
                        break;
                    }
                }
                originaldata.put(0, new DataWatcherObjectByte(basevalue));
            }
        }
        TIntObjectHashMap transformed = new TIntObjectHashMap();
        SpecificRemapper stype = entity.getType();
        for (MappingEntry entry : stype.getRemaps(to)) {
            DataWatcherObject<?> object = originaldata.get(entry.getIdFrom());
            if (object == null) continue;
            ValueRemapper remapper = entry.getValueRemapper();
            try {
                if (!remapper.isValid(object)) continue;
                DataWatcherObject<?> remapped = remapper.remap(object);
                remapped.getTypeId(to);
                transformed.put(entry.getIdTo(), remapped);
            }
            catch (Exception e) {
                throw new MetadataRemapException(entry.getIdFrom(), entity.getId(), entity.getType(), to, e);
            }
        }
        return transformed;
    }

    public static class MetadataRemapException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MetadataRemapException(int index, int entityId, SpecificRemapper type, ProtocolVersion to, Exception e) {
            super(Utils.exceptionMessage("Unable to remap entity metadata", String.format("Metadata index: %d", index), String.format("Entity id: %d", entityId), String.format("Entity type: %s", new Object[]{type}), String.format("To protocol version: %s", new Object[]{to})), e);
        }
    }
}

