/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.id;

import java.util.EnumMap;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.typeremapper.id.RemappingTable;

public abstract class RemappingRegistry<T extends RemappingTable> {
    private final EnumMap<ProtocolVersion, T> remappings = new EnumMap(ProtocolVersion.class);

    public RemappingRegistry() {
        for (ProtocolVersion version : ProtocolVersion.values()) {
            if (!version.isSupported()) continue;
            this.remappings.put(version, this.createTable());
        }
    }

    public T getTable(ProtocolVersion version) {
        return (T)((RemappingTable)this.remappings.get((Object)version));
    }

    protected abstract T createTable();

    public static abstract class GenericRemappingRegistry<T, R extends RemappingTable.GenericRemappingTable<T>>
    extends RemappingRegistry<R> {
        public void registerRemapEntry(T from, T to, ProtocolVersion ... versions) {
            for (ProtocolVersion version : versions) {
                ((RemappingTable.GenericRemappingTable)this.getTable(version)).setRemap(from, to);
            }
        }
    }

    public static abstract class IdRemappingRegistry<T extends RemappingTable.IdRemappingTable>
    extends RemappingRegistry<T> {
        public void registerRemapEntry(int from, int to, ProtocolVersion ... versions) {
            for (ProtocolVersion version : versions) {
                ((RemappingTable.IdRemappingTable)this.getTable(version)).setRemap(from, to);
            }
        }
    }
}

