/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import javax.crypto.Cipher;

public class PacketEncrypter
extends MessageToByteEncoder<ByteBuf> {
    private final Cipher cipher;
    private byte[] inBuffer = new byte[0];
    private byte[] outBuffer = new byte[0];

    public PacketEncrypter(Cipher cipher) {
        this.cipher = cipher;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        if (!in.isReadable()) {
            return;
        }
        int readableBytes = in.readableBytes();
        byte[] inBytes = this.readIn(in);
        int outputSize = this.cipher.getOutputSize(readableBytes);
        if (this.outBuffer.length < outputSize) {
            this.outBuffer = new byte[outputSize];
        }
        out.writeBytes(this.outBuffer, 0, this.cipher.update(inBytes, 0, readableBytes, this.outBuffer));
    }

    private byte[] readIn(ByteBuf in) {
        int readableBytes = in.readableBytes();
        if (this.inBuffer.length < readableBytes) {
            this.inBuffer = new byte[readableBytes];
        }
        in.readBytes(this.inBuffer, 0, readableBytes);
        return this.inBuffer;
    }
}

