/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper.chunk;

import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.legacyremapper.chunk.BlockStorageReader;
import protocolsupport.protocol.legacyremapper.chunk.ChunkTransformer;
import protocolsupport.protocol.typeremapper.id.IdRemapper;
import protocolsupport.protocol.typeremapper.id.RemappingTable;

public class ChunkTransformerShort
extends ChunkTransformer {
    @Override
    protected byte[] toLegacyData0(ProtocolVersion version) {
        RemappingTable.ArrayBasedIdRemappingTable table = (RemappingTable.ArrayBasedIdRemappingTable)IdRemapper.BLOCK.getTable(ProtocolVersion.MINECRAFT_1_8);
        byte[] data = new byte[(this.hasSkyLight ? 12288 : 10240) * this.columnsCount + 256];
        int blockIdIndex = 0;
        int blockLightIndex = 8192 * this.columnsCount;
        int skyLightIndex = 10240 * this.columnsCount;
        for (int i = 0; i < this.columnsCount; ++i) {
            ChunkTransformer.ChunkSection section = this.sections[i];
            BlockStorageReader storage = section.blockdata;
            for (int block = 0; block < 4096; ++block) {
                int dataindex = blockIdIndex + (block << 1);
                int blockstate = storage.getBlockState(block);
                blockstate = table.getRemap(blockstate);
                data[dataindex] = (byte)blockstate;
                data[dataindex + 1] = (byte)(blockstate >> 8);
            }
            blockIdIndex += 8192;
            System.arraycopy(section.blocklight, 0, data, blockLightIndex, 2048);
            blockLightIndex += 2048;
            if (!this.hasSkyLight) continue;
            System.arraycopy(section.skylight, 0, data, skyLightIndex, 2048);
            skyLightIndex += 2048;
        }
        if (this.hasBiomeData) {
            System.arraycopy(this.biomeData, 0, data, skyLightIndex, 256);
        }
        return data;
    }
}

