/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper.chunk;

import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.legacyremapper.chunk.BlockStorageReader;
import protocolsupport.protocol.legacyremapper.chunk.ChunkTransformer;
import protocolsupport.protocol.typeremapper.id.IdRemapper;
import protocolsupport.protocol.typeremapper.id.RemappingTable;

public class ChunkTransformerByte
extends ChunkTransformer {
    @Override
    protected byte[] toLegacyData0(ProtocolVersion version) {
        RemappingTable.ArrayBasedIdRemappingTable table = (RemappingTable.ArrayBasedIdRemappingTable)IdRemapper.BLOCK.getTable(version);
        byte[] data = new byte[(this.hasSkyLight ? 10240 : 8192) * this.columnsCount + 256];
        int blockIdIndex = 0;
        int blockDataIndex = 4096 * this.columnsCount;
        int blockLightIndex = 6144 * this.columnsCount;
        int skyLightIndex = 8192 * this.columnsCount;
        for (int i = 0; i < this.columnsCount; ++i) {
            ChunkTransformer.ChunkSection section = this.sections[i];
            BlockStorageReader storage = section.blockdata;
            int blockdataacc = 0;
            for (int block = 0; block < 4096; ++block) {
                int blockstate = storage.getBlockState(block);
                blockstate = table.getRemap(blockstate);
                data[blockIdIndex + block] = (byte)(blockstate >> 4);
                int blockdata = blockstate & 0xF;
                if ((block & 1) == 0) {
                    blockdataacc = blockdata;
                    continue;
                }
                data[(block >> 1) + blockDataIndex] = (byte)(blockdataacc |= blockdata << 4);
            }
            blockIdIndex += 4096;
            blockDataIndex += 2048;
            System.arraycopy(section.blocklight, 0, data, blockLightIndex, 2048);
            blockLightIndex += 2048;
            if (!this.hasSkyLight) continue;
            System.arraycopy(section.skylight, 0, data, skyLightIndex, 2048);
            skyLightIndex += 2048;
        }
        if (this.hasBiomeData) {
            System.arraycopy(this.biomeData, 0, data, skyLightIndex, 256);
        }
        return data;
    }
}

