/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper;

import java.util.HashMap;
import protocolsupport.protocol.utils.data.SoundData;

public class LegacySound {
    private static final HashMap<String, String> legacySounds = new HashMap();

    public static String getSoundName(int soundId) {
        return SoundData.getNameById(soundId);
    }

    public static String getLegacySoundName(int soundType) {
        String newSound = LegacySound.getSoundName(soundType);
        return legacySounds.get(newSound);
    }

    public static String getLegacySoundName(String soundName) {
        switch (soundName) {
            case "game.player.hurt.fall.big": 
            case "game.neutral.hurt.fall.big": 
            case "game.hostile.hurt.fall.big": {
                return "damage.fallbig";
            }
            case "game.player.hurt.fall.small": 
            case "game.neutral.hurt.fall.small": 
            case "game.hostile.hurt.fall.small": {
                return "damage.fallsmall";
            }
            case "game.player.hurt": 
            case "game.player.die": 
            case "game.neutral.hurt": 
            case "game.neutral.die": 
            case "game.hostile.hurt": 
            case "game.hostile.die": {
                return "damage.hit";
            }
            case "game.player.swim": 
            case "game.neutral.swim": 
            case "game.hostile.swim": {
                return "liquid.swim";
            }
            case "game.player.swim.splash": 
            case "game.neutral.swim.splash": 
            case "game.hostile.swim.splash": {
                return "liquid.splash";
            }
        }
        return soundName;
    }

    private static void register(String newSound, String legacySound) {
        legacySounds.put(newSound, legacySound);
    }

    public static void init() {
    }

    static {
        LegacySound.register("entity.zombie_horse.ambient", "mob.horse.zombie.idle");
        LegacySound.register("block.note.snare", "note.snare");
        LegacySound.register("block.wood_button.click_off", "random.wood_click");
        LegacySound.register("block.wood_button.click_on", "random.wood_click");
        LegacySound.register("block.gravel.break", "dig.gravel");
        LegacySound.register("block.gravel.place", "dig.gravel");
        LegacySound.register("entity.arrow.hit", "random.bowhit");
        LegacySound.register("block.tripwire.detach", "random.bowhit");
        LegacySound.register("entity.splash_potion.break", "dig.glass");
        LegacySound.register("block.glass.break", "dig.glass");
        LegacySound.register("entity.zombie.ambient", "mob.zombie.say");
        LegacySound.register("entity.zombie_villager.ambient", "mob.zombie.say");
        LegacySound.register("entity.pig.death", "mob.pig.death");
        LegacySound.register("entity.mule.hurt", "mob.horse.donkey.hit");
        LegacySound.register("entity.donkey.hurt", "mob.horse.donkey.hit");
        LegacySound.register("entity.generic.swim", "game.neutral.swim");
        LegacySound.register("entity.hostile.swim", "game.neutral.swim");
        LegacySound.register("entity.player.swim", "game.neutral.swim");
        LegacySound.register("entity.generic.swim", "game.player.swim");
        LegacySound.register("entity.hostile.swim", "game.player.swim");
        LegacySound.register("entity.player.swim", "game.player.swim");
        LegacySound.register("entity.endermen.ambient", "mob.endermen.idle");
        LegacySound.register("block.portal.ambient", "portal.portal");
        LegacySound.register("entity.generic.burn", "random.fizz");
        LegacySound.register("block.fire.extinguish", "random.fizz");
        LegacySound.register("block.redstone_torch.burnout", "random.fizz");
        LegacySound.register("block.lava.extinguish", "random.fizz");
        LegacySound.register("entity.generic.extinguish_fire", "random.fizz");
        LegacySound.register("block.note.harp", "note.harp");
        LegacySound.register("block.snow.hit", "step.snow");
        LegacySound.register("block.snow.fall", "step.snow");
        LegacySound.register("block.snow.step", "step.snow");
        LegacySound.register("entity.arrow.hit_player", "random.successful_hit");
        LegacySound.register("entity.zombie_pig.hurt", "mob.zombiepig.zpighurt");
        LegacySound.register("entity.wolf.howl", "mob.wolf.howl");
        LegacySound.register("entity.firework.launch", "fireworks.launch");
        LegacySound.register("entity.cow.hurt", "mob.cow.hurt");
        LegacySound.register("entity.cow.death", "mob.cow.hurt");
        LegacySound.register("entity.firework.large_blast", "fireworks.largeBlast");
        LegacySound.register("entity.blaze.hurt", "mob.blaze.hit");
        LegacySound.register("entity.villager.death", "mob.villager.death");
        LegacySound.register("entity.blaze.death", "mob.blaze.death");
        LegacySound.register("entity.zombie_horse.death", "mob.horse.zombie.death");
        LegacySound.register("entity.silverfish.death", "mob.silverfish.kill");
        LegacySound.register("entity.endermite.death", "mob.silverfish.kill");
        LegacySound.register("record.ward", "records.ward");
        LegacySound.register("entity.wolf.pant", "mob.wolf.panting");
        LegacySound.register("block.metal.break", "dig.stone");
        LegacySound.register("block.metal.place", "dig.stone");
        LegacySound.register("entity.armorstand.place", "dig.stone");
        LegacySound.register("block.stone.break", "dig.stone");
        LegacySound.register("block.stone.place", "dig.stone");
        LegacySound.register("block.anvil.break", "dig.stone");
        LegacySound.register("block.glass.place", "dig.stone");
        LegacySound.register("entity.endermen.stare", "mob.endermen.stare");
        LegacySound.register("entity.player.splash", "game.player.swim.splash");
        LegacySound.register("entity.hostile.splash", "game.player.swim.splash");
        LegacySound.register("entity.generic.splash", "game.player.swim.splash");
        LegacySound.register("entity.small_magmacube.hurt", "mob.slime.small");
        LegacySound.register("block.slime.fall", "mob.slime.small");
        LegacySound.register("entity.small_slime.death", "mob.slime.small");
        LegacySound.register("block.slime.step", "mob.slime.small");
        LegacySound.register("entity.small_magmacube.death", "mob.slime.small");
        LegacySound.register("entity.small_slime.hurt", "mob.slime.small");
        LegacySound.register("block.slime.hit", "mob.slime.small");
        LegacySound.register("music.nether", "music.game.nether");
        LegacySound.register("entity.ghast.death", "mob.ghast.death");
        LegacySound.register("entity.guardian.attack", "mob.guardian.attack");
        LegacySound.register("block.dispenser.fail", "random.click");
        LegacySound.register("block.comparator.click", "random.click");
        LegacySound.register("block.stone_button.click_on", "random.click");
        LegacySound.register("block.stone_button.click_off", "random.click");
        LegacySound.register("block.tripwire.click_on", "random.click");
        LegacySound.register("block.dispenser.dispense", "random.click");
        LegacySound.register("ui.button.click", "random.click");
        LegacySound.register("block.lever.click", "random.click");
        LegacySound.register("block.tripwire.attach", "random.click");
        LegacySound.register("block.stone_pressureplate.click_on", "random.click");
        LegacySound.register("block.wood_pressureplate.click_off", "random.click");
        LegacySound.register("block.stone_pressureplate.click_off", "random.click");
        LegacySound.register("block.metal_pressureplate.click_off", "random.click");
        LegacySound.register("block.tripwire.click_off", "random.click");
        LegacySound.register("block.metal_pressureplate.click_on", "random.click");
        LegacySound.register("block.wood_pressureplate.click_on", "random.click");
        LegacySound.register("entity.zombie_pig.ambient", "mob.zombiepig.zpig");
        LegacySound.register("entity.generic.death", "game.player.die");
        LegacySound.register("entity.hostile.hurt", "game.player.die");
        LegacySound.register("entity.player.hurt", "game.player.die");
        LegacySound.register("entity.hostile.death", "game.player.die");
        LegacySound.register("entity.generic.hurt", "game.player.die");
        LegacySound.register("entity.player.death", "game.player.die");
        LegacySound.register("music.dragon", "music.game.end.dragon");
        LegacySound.register("entity.firework.twinkle_far", "fireworks.twinkle_far");
        LegacySound.register("entity.elder_guardian.ambient_land", "mob.guardian.land.idle");
        LegacySound.register("entity.guardian.ambient_land", "mob.guardian.land.idle");
        LegacySound.register("block.grass.break", "dig.grass");
        LegacySound.register("block.grass.place", "dig.grass");
        LegacySound.register("entity.skeleton.step", "mob.skeleton.step");
        LegacySound.register("entity.wither.death", "mob.wither.death");
        LegacySound.register("entity.wolf.hurt", "mob.wolf.hurt");
        LegacySound.register("entity.pig.saddle", "mob.horse.leather");
        LegacySound.register("entity.horse.saddle", "mob.horse.leather");
        LegacySound.register("entity.bat.loop", "mob.bat.loop");
        LegacySound.register("entity.ghast.hurt", "mob.ghast.scream");
        LegacySound.register("entity.generic.death", "game.player.hurt");
        LegacySound.register("entity.hostile.hurt", "game.player.hurt");
        LegacySound.register("entity.player.hurt", "game.player.hurt");
        LegacySound.register("entity.hostile.death", "game.player.hurt");
        LegacySound.register("entity.generic.hurt", "game.player.hurt");
        LegacySound.register("entity.player.death", "game.player.hurt");
        LegacySound.register("entity.generic.death", "game.neutral.die");
        LegacySound.register("entity.hostile.hurt", "game.neutral.die");
        LegacySound.register("entity.player.hurt", "game.neutral.die");
        LegacySound.register("entity.hostile.death", "game.neutral.die");
        LegacySound.register("entity.generic.hurt", "game.neutral.die");
        LegacySound.register("entity.player.death", "game.neutral.die");
        LegacySound.register("entity.creeper.death", "mob.creeper.death");
        LegacySound.register("entity.horse.gallop", "mob.horse.gallop");
        LegacySound.register("entity.wither.spawn", "mob.wither.spawn");
        LegacySound.register("entity.endermen.hurt", "mob.endermen.hit");
        LegacySound.register("entity.creeper.hurt", "mob.creeper.say");
        LegacySound.register("entity.horse.step_wood", "mob.horse.wood");
        LegacySound.register("entity.rabbit.death", "mob.rabbit.death");
        LegacySound.register("entity.zombie_villager.converted", "mob.zombie.unfect");
        LegacySound.register("block.anvil.use", "random.anvil_use");
        LegacySound.register("block.enderchest.close", "random.chestclosed");
        LegacySound.register("entity.mooshroom.shear", "mob.sheep.shear");
        LegacySound.register("entity.sheep.shear", "mob.sheep.shear");
        LegacySound.register("entity.item.pickup", "random.pop");
        LegacySound.register("entity.bat.death", "mob.bat.death");
        LegacySound.register("block.wood.place", "dig.wood");
        LegacySound.register("block.wood.break", "dig.wood");
        LegacySound.register("block.ladder.place", "dig.wood");
        LegacySound.register("entity.armorstand.fall", "dig.wood");
        LegacySound.register("block.ladder.break", "dig.wood");
        LegacySound.register("record.chirp", "records.chirp");
        LegacySound.register("entity.mule.death", "mob.horse.donkey.death");
        LegacySound.register("entity.donkey.death", "mob.horse.donkey.death");
        LegacySound.register("entity.firework.blast", "fireworks.blast");
        LegacySound.register("entity.zombie_pig.angry", "mob.zombiepig.zpigangry");
        LegacySound.register("entity.generic.swim", "game.hostile.swim");
        LegacySound.register("entity.hostile.swim", "game.hostile.swim");
        LegacySound.register("entity.player.swim", "game.hostile.swim");
        LegacySound.register("entity.guardian.flop", "mob.guardian.flop");
        LegacySound.register("entity.villager.yes", "mob.villager.yes");
        LegacySound.register("entity.ghast.warn", "mob.ghast.charge");
        LegacySound.register("entity.tnt.primed", "creeper.primed");
        LegacySound.register("entity.creeper.primed", "creeper.primed");
        LegacySound.register("block.sand.place", "dig.sand");
        LegacySound.register("block.sand.break", "dig.sand");
        LegacySound.register("entity.chicken.ambient", "mob.chicken.say");
        LegacySound.register("record.13", "records.13");
        LegacySound.register("record.11", "records.11");
        LegacySound.register("entity.elder_guardian.death", "mob.guardian.elder.death");
        LegacySound.register("entity.firework.twinkle", "fireworks.twinkle");
        LegacySound.register("entity.skeleton_horse.death", "mob.horse.skeleton.death");
        LegacySound.register("weather.rain", "ambient.weather.rain");
        LegacySound.register("weather.rain.above", "ambient.weather.rain");
        LegacySound.register("block.portal.trigger", "portal.trigger");
        LegacySound.register("block.enderchest.open", "random.chestopen");
        LegacySound.register("entity.horse.land", "mob.horse.land");
        LegacySound.register("entity.endermite.step", "mob.silverfish.step");
        LegacySound.register("entity.silverfish.step", "mob.silverfish.step");
        LegacySound.register("entity.bat.takeoff", "mob.bat.takeoff");
        LegacySound.register("entity.villager.no", "mob.villager.no");
        LegacySound.register("entity.player.big_fall", "game.hostile.hurt.fall.big");
        LegacySound.register("entity.generic.big_fall", "game.hostile.hurt.fall.big");
        LegacySound.register("entity.hostile.big_fall", "game.hostile.hurt.fall.big");
        LegacySound.register("entity.irongolem.step", "mob.irongolem.walk");
        LegacySound.register("block.note.hat", "note.hat");
        LegacySound.register("entity.zombie.attack_iron_door", "mob.zombie.metal");
        LegacySound.register("entity.villager.trading", "mob.villager.haggle");
        LegacySound.register("item.firecharge.use", "mob.ghast.fireball");
        LegacySound.register("entity.ghast.shoot", "mob.ghast.fireball");
        LegacySound.register("entity.enderdragon.shoot", "mob.ghast.fireball");
        LegacySound.register("entity.blaze.shoot", "mob.ghast.fireball");
        LegacySound.register("music.credits", "music.game.end.credits");
        LegacySound.register("entity.irongolem.death", "mob.irongolem.death");
        LegacySound.register("entity.item.break", "random.break");
        LegacySound.register("item.shield.break", "random.break");
        LegacySound.register("record.mellohi", "records.mellohi");
        LegacySound.register("entity.zombie_villager.cure", "mob.zombie.remedy");
        LegacySound.register("entity.enderpearl.throw", "random.bow");
        LegacySound.register("block.dispenser.launch", "random.bow");
        LegacySound.register("entity.skeleton.shoot", "random.bow");
        LegacySound.register("entity.endereye.launch", "random.bow");
        LegacySound.register("entity.firework.shoot", "random.bow");
        LegacySound.register("entity.experience_bottle.throw", "random.bow");
        LegacySound.register("entity.snowman.shoot", "random.bow");
        LegacySound.register("entity.arrow.shoot", "random.bow");
        LegacySound.register("entity.egg.throw", "random.bow");
        LegacySound.register("entity.snowball.throw", "random.bow");
        LegacySound.register("entity.bobber.throw", "random.bow");
        LegacySound.register("entity.lingeringpotion.throw", "random.bow");
        LegacySound.register("entity.splash_potion.throw", "random.bow");
        LegacySound.register("entity.villager.ambient", "mob.villager.idle");
        LegacySound.register("block.cloth.hit", "step.cloth");
        LegacySound.register("block.cloth.step", "step.cloth");
        LegacySound.register("block.cloth.fall", "step.cloth");
        LegacySound.register("entity.silverfish.hurt", "mob.silverfish.hit");
        LegacySound.register("entity.endermite.hurt", "mob.silverfish.hit");
        LegacySound.register("music.game", "music.game");
        LegacySound.register("block.lava.ambient", "liquid.lava");
        LegacySound.register("entity.player.big_fall", "game.neutral.hurt.fall.big");
        LegacySound.register("entity.generic.big_fall", "game.neutral.hurt.fall.big");
        LegacySound.register("entity.hostile.big_fall", "game.neutral.hurt.fall.big");
        LegacySound.register("record.mall", "records.mall");
        LegacySound.register("entity.blaze.burn", "fire.fire");
        LegacySound.register("block.fire.ambient", "fire.fire");
        LegacySound.register("entity.zombie.attack_door_wood", "mob.zombie.wood");
        LegacySound.register("entity.chicken.step", "mob.chicken.step");
        LegacySound.register("record.stal", "records.stal");
        LegacySound.register("entity.elder_guardian.hurt_land", "mob.guardian.land.hit");
        LegacySound.register("entity.guardian.hurt_land", "mob.guardian.land.hit");
        LegacySound.register("entity.chicken.egg", "mob.chicken.plop");
        LegacySound.register("entity.donkey.chest", "mob.chicken.plop");
        LegacySound.register("entity.enderdragon.flap", "mob.enderdragon.wings");
        LegacySound.register("block.grass.step", "step.grass");
        LegacySound.register("block.grass.fall", "step.grass");
        LegacySound.register("block.grass.hit", "step.grass");
        LegacySound.register("entity.horse.breathe", "mob.horse.breathe");
        LegacySound.register("entity.player.big_fall", "game.player.hurt.fall.big");
        LegacySound.register("entity.generic.big_fall", "game.player.hurt.fall.big");
        LegacySound.register("entity.hostile.big_fall", "game.player.hurt.fall.big");
        LegacySound.register("entity.mule.ambient", "mob.horse.donkey.idle");
        LegacySound.register("entity.donkey.ambient", "mob.horse.donkey.idle");
        LegacySound.register("record.far", "records.far");
        LegacySound.register("entity.spider.step", "mob.spider.step");
        LegacySound.register("entity.generic.death", "game.neutral.hurt");
        LegacySound.register("entity.hostile.hurt", "game.neutral.hurt");
        LegacySound.register("entity.player.hurt", "game.neutral.hurt");
        LegacySound.register("entity.hostile.death", "game.neutral.hurt");
        LegacySound.register("entity.generic.hurt", "game.neutral.hurt");
        LegacySound.register("entity.player.death", "game.neutral.hurt");
        LegacySound.register("entity.cow.ambient", "mob.cow.say");
        LegacySound.register("entity.horse.jump", "mob.horse.jump");
        LegacySound.register("entity.horse.step", "mob.horse.soft");
        LegacySound.register("entity.player.splash", "game.neutral.swim.splash");
        LegacySound.register("entity.hostile.splash", "game.neutral.swim.splash");
        LegacySound.register("entity.generic.splash", "game.neutral.swim.splash");
        LegacySound.register("entity.guardian.hurt", "mob.guardian.hit");
        LegacySound.register("entity.enderdragon.death", "mob.enderdragon.end");
        LegacySound.register("entity.zombie_villager.step", "mob.zombie.step");
        LegacySound.register("entity.zombie.step", "mob.zombie.step");
        LegacySound.register("entity.enderdragon.ambient", "mob.enderdragon.growl");
        LegacySound.register("entity.enderdragon.growl", "mob.enderdragon.growl");
        LegacySound.register("entity.wolf.shake", "mob.wolf.shake");
        LegacySound.register("entity.endermen.death", "mob.endermen.death");
        LegacySound.register("block.anvil.place", "random.anvil_land");
        LegacySound.register("block.anvil.land", "random.anvil_land");
        LegacySound.register("entity.generic.death", "game.hostile.hurt");
        LegacySound.register("entity.hostile.hurt", "game.hostile.hurt");
        LegacySound.register("entity.player.hurt", "game.hostile.hurt");
        LegacySound.register("entity.hostile.death", "game.hostile.hurt");
        LegacySound.register("entity.generic.hurt", "game.hostile.hurt");
        LegacySound.register("entity.player.death", "game.hostile.hurt");
        LegacySound.register("entity.minecart.inside", "minecart.inside");
        LegacySound.register("entity.slime.squish", "mob.slime.big");
        LegacySound.register("entity.magmacube.hurt", "mob.slime.big");
        LegacySound.register("entity.magmacube.death", "mob.slime.big");
        LegacySound.register("block.slime.break", "mob.slime.big");
        LegacySound.register("block.slime.place", "mob.slime.big");
        LegacySound.register("entity.slime.jump", "mob.slime.big");
        LegacySound.register("entity.slime.hurt", "mob.slime.big");
        LegacySound.register("entity.slime.death", "mob.slime.big");
        LegacySound.register("block.water.ambient", "liquid.water");
        LegacySound.register("entity.pig.hurt", "mob.pig.say");
        LegacySound.register("entity.pig.ambient", "mob.pig.say");
        LegacySound.register("entity.wither.shoot", "mob.wither.shoot");
        LegacySound.register("record.blocks", "records.blocks");
        LegacySound.register("item.firecharge.use", "item.fireCharge.use");
        LegacySound.register("entity.ghast.shoot", "item.fireCharge.use");
        LegacySound.register("entity.enderdragon.shoot", "item.fireCharge.use");
        LegacySound.register("entity.blaze.shoot", "item.fireCharge.use");
        LegacySound.register("block.sand.hit", "step.sand");
        LegacySound.register("block.sand.step", "step.sand");
        LegacySound.register("block.sand.fall", "step.sand");
        LegacySound.register("music.creative", "music.game.creative");
        LegacySound.register("entity.irongolem.hurt", "mob.irongolem.hit");
        LegacySound.register("entity.horse.death", "mob.horse.death");
        LegacySound.register("entity.bat.hurt", "mob.bat.hurt");
        LegacySound.register("entity.ghast.scream", "mob.ghast.affectionate_scream");
        LegacySound.register("entity.elder_guardian.ambient", "mob.guardian.elder.idle");
        LegacySound.register("entity.zombie_pig.death", "mob.zombiepig.zpigdeath");
        LegacySound.register("entity.lightning.thunder", "ambient.weather.thunder");
        LegacySound.register("entity.minecart.riding", "minecart.base");
        LegacySound.register("block.ladder.step", "step.ladder");
        LegacySound.register("block.ladder.fall", "step.ladder");
        LegacySound.register("block.ladder.hit", "step.ladder");
        LegacySound.register("entity.donkey.angry", "mob.horse.donkey.angry");
        LegacySound.register("ambient.cave", "ambient.cave.cave");
        LegacySound.register("record.wait", "records.wait");
        LegacySound.register("entity.firework.blast_far", "fireworks.blast_far");
        LegacySound.register("entity.hostile.small_fall", "game.neutral.hurt.fall.small");
        LegacySound.register("entity.player.small_fall", "game.neutral.hurt.fall.small");
        LegacySound.register("entity.generic.small_fall", "game.neutral.hurt.fall.small");
        LegacySound.register("entity.player.splash", "game.hostile.swim.splash");
        LegacySound.register("entity.hostile.splash", "game.hostile.swim.splash");
        LegacySound.register("entity.generic.splash", "game.hostile.swim.splash");
        LegacySound.register("entity.generic.drink", "random.drink");
        LegacySound.register("music.menu", "music.menu");
        LegacySound.register("entity.generic.death", "game.hostile.die");
        LegacySound.register("entity.hostile.hurt", "game.hostile.die");
        LegacySound.register("entity.player.hurt", "game.hostile.die");
        LegacySound.register("entity.hostile.death", "game.hostile.die");
        LegacySound.register("entity.generic.hurt", "game.hostile.die");
        LegacySound.register("entity.player.death", "game.hostile.die");
        LegacySound.register("entity.cat.hiss", "mob.cat.hiss");
        LegacySound.register("block.note.basedrum", "note.bd");
        LegacySound.register("entity.spider.ambient", "mob.spider.say");
        LegacySound.register("entity.spider.hurt", "mob.spider.say");
        LegacySound.register("block.stone.fall", "step.stone");
        LegacySound.register("block.anvil.fall", "step.stone");
        LegacySound.register("block.metal.step", "step.stone");
        LegacySound.register("block.stone.hit", "step.stone");
        LegacySound.register("block.glass.fall", "step.stone");
        LegacySound.register("block.stone.step", "step.stone");
        LegacySound.register("block.anvil.step", "step.stone");
        LegacySound.register("block.metal.hit", "step.stone");
        LegacySound.register("block.glass.step", "step.stone");
        LegacySound.register("block.metal.fall", "step.stone");
        LegacySound.register("block.glass.hit", "step.stone");
        LegacySound.register("block.anvil.hit", "step.stone");
        LegacySound.register("entity.player.levelup", "random.levelup");
        LegacySound.register("block.lava.pop", "liquid.lavapop");
        LegacySound.register("entity.sheep.hurt", "mob.sheep.say");
        LegacySound.register("entity.sheep.death", "mob.sheep.say");
        LegacySound.register("entity.sheep.ambient", "mob.sheep.say");
        LegacySound.register("entity.skeleton.ambient", "mob.skeleton.say");
        LegacySound.register("entity.blaze.ambient", "mob.blaze.breathe");
        LegacySound.register("entity.bat.ambient", "mob.bat.idle");
        LegacySound.register("entity.magmacube.squish", "mob.magmacube.big");
        LegacySound.register("entity.horse.ambient", "mob.horse.idle");
        LegacySound.register("entity.hostile.small_fall", "game.hostile.hurt.fall.small");
        LegacySound.register("entity.player.small_fall", "game.hostile.hurt.fall.small");
        LegacySound.register("entity.generic.small_fall", "game.hostile.hurt.fall.small");
        LegacySound.register("entity.zombie_horse.hurt", "mob.horse.zombie.hit");
        LegacySound.register("entity.irongolem.attack", "mob.irongolem.throw");
        LegacySound.register("block.cloth.break", "dig.cloth");
        LegacySound.register("block.cloth.place", "dig.cloth");
        LegacySound.register("block.gravel.fall", "step.gravel");
        LegacySound.register("block.gravel.step", "step.gravel");
        LegacySound.register("block.gravel.hit", "step.gravel");
        LegacySound.register("entity.endermite.ambient", "mob.silverfish.say");
        LegacySound.register("entity.silverfish.ambient", "mob.silverfish.say");
        LegacySound.register("entity.cat.purr", "mob.cat.purr");
        LegacySound.register("entity.zombie.infect", "mob.zombie.infect");
        LegacySound.register("entity.generic.eat", "random.eat");
        LegacySound.register("entity.wolf.ambient", "mob.wolf.bark");
        LegacySound.register("entity.tnt.primed", "game.tnt.primed");
        LegacySound.register("entity.creeper.primed", "game.tnt.primed");
        LegacySound.register("entity.sheep.step", "mob.sheep.step");
        LegacySound.register("entity.zombie_villager.death", "mob.zombie.death");
        LegacySound.register("entity.zombie.death", "mob.zombie.death");
        LegacySound.register("entity.shulker.teleport", "mob.endermen.portal");
        LegacySound.register("item.chorus_fruit.teleport", "mob.endermen.portal");
        LegacySound.register("entity.endermen.teleport", "mob.endermen.portal");
        LegacySound.register("entity.horse.angry", "mob.horse.angry");
        LegacySound.register("entity.wolf.growl", "mob.wolf.growl");
        LegacySound.register("block.snow.break", "dig.snow");
        LegacySound.register("block.snow.place", "dig.snow");
        LegacySound.register("block.piston.extend", "tile.piston.out");
        LegacySound.register("entity.player.burp", "random.burp");
        LegacySound.register("entity.cow.step", "mob.cow.step");
        LegacySound.register("entity.wither.hurt", "mob.wither.hurt");
        LegacySound.register("entity.guardian.death_land", "mob.guardian.land.death");
        LegacySound.register("entity.elder_guardian.death_land", "mob.guardian.land.death");
        LegacySound.register("music.end", "music.game.end");
        LegacySound.register("entity.chicken.hurt", "mob.chicken.hurt");
        LegacySound.register("entity.chicken.death", "mob.chicken.hurt");
        LegacySound.register("entity.wolf.step", "mob.wolf.step");
        LegacySound.register("entity.wolf.death", "mob.wolf.death");
        LegacySound.register("entity.wolf.whine", "mob.wolf.whine");
        LegacySound.register("block.note.pling", "note.pling");
        LegacySound.register("entity.hostile.small_fall", "game.player.hurt.fall.small");
        LegacySound.register("entity.player.small_fall", "game.player.hurt.fall.small");
        LegacySound.register("entity.generic.small_fall", "game.player.hurt.fall.small");
        LegacySound.register("entity.rabbit.hurt", "mob.rabbit.hurt");
        LegacySound.register("entity.cat.purreow", "mob.cat.purreow");
        LegacySound.register("entity.firework.large_blast_far", "fireworks.largeBlast_far");
        LegacySound.register("entity.skeleton.hurt", "mob.skeleton.hurt");
        LegacySound.register("entity.spider.death", "mob.spider.death");
        LegacySound.register("block.anvil.destroy", "random.anvil_break");
        LegacySound.register("record.cat", "records.cat");
        LegacySound.register("entity.wither.ambient", "mob.wither.idle");
        LegacySound.register("entity.elder_guardian.hurt", "mob.guardian.elder.hit");
        LegacySound.register("entity.endermen.scream", "mob.endermen.scream");
        LegacySound.register("entity.cat.death", "mob.cat.hitt");
        LegacySound.register("entity.cat.hurt", "mob.cat.hitt");
        LegacySound.register("entity.small_magmacube.squish", "mob.magmacube.small");
        LegacySound.register("item.flintandsteel.use", "fire.ignite");
        LegacySound.register("entity.enderdragon.hurt", "mob.enderdragon.hit");
        LegacySound.register("entity.zombie.hurt", "mob.zombie.hurt");
        LegacySound.register("entity.zombie_villager.hurt", "mob.zombie.hurt");
        LegacySound.register("entity.enderdragon_fireball.explode", "random.explode");
        LegacySound.register("entity.generic.explode", "random.explode");
        LegacySound.register("entity.lightning.impact", "random.explode");
        LegacySound.register("block.end_gateway.spawn", "random.explode");
        LegacySound.register("entity.slime.attack", "mob.slime.attack");
        LegacySound.register("entity.magmacube.jump", "mob.magmacube.jump");
        LegacySound.register("entity.bobber.splash", "random.splash");
        LegacySound.register("entity.skeleton_horse.hurt", "mob.horse.skeleton.hit");
        LegacySound.register("entity.rabbit.jump", "mob.rabbit.hop");
        LegacySound.register("entity.ghast.ambient", "mob.ghast.moan");
        LegacySound.register("entity.elder_guardian.curse", "mob.guardian.curse");
        LegacySound.register("entity.splash_potion.break", "game.potion.smash");
        LegacySound.register("block.glass.break", "game.potion.smash");
        LegacySound.register("block.note.bass", "note.bassattack");
        LegacySound.register("block.dispenser.fail", "gui.button.press");
        LegacySound.register("block.comparator.click", "gui.button.press");
        LegacySound.register("block.stone_button.click_on", "gui.button.press");
        LegacySound.register("block.stone_button.click_off", "gui.button.press");
        LegacySound.register("block.tripwire.click_on", "gui.button.press");
        LegacySound.register("block.dispenser.dispense", "gui.button.press");
        LegacySound.register("ui.button.click", "gui.button.press");
        LegacySound.register("block.lever.click", "gui.button.press");
        LegacySound.register("block.tripwire.attach", "gui.button.press");
        LegacySound.register("block.stone_pressureplate.click_on", "gui.button.press");
        LegacySound.register("block.wood_pressureplate.click_off", "gui.button.press");
        LegacySound.register("block.stone_pressureplate.click_off", "gui.button.press");
        LegacySound.register("block.metal_pressureplate.click_off", "gui.button.press");
        LegacySound.register("block.tripwire.click_off", "gui.button.press");
        LegacySound.register("block.metal_pressureplate.click_on", "gui.button.press");
        LegacySound.register("block.wood_pressureplate.click_on", "gui.button.press");
        LegacySound.register("entity.experience_orb.touch", "random.orb");
        LegacySound.register("entity.experience_orb.pickup", "random.orb");
        LegacySound.register("entity.wither.break_block", "mob.zombie.woodbreak");
        LegacySound.register("entity.zombie.break_door_wood", "mob.zombie.woodbreak");
        LegacySound.register("entity.horse.armor", "mob.horse.armor");
        LegacySound.register("entity.rabbit.ambient", "mob.rabbit.idle");
        LegacySound.register("block.piston.contract", "tile.piston.in");
        LegacySound.register("entity.cat.ambient", "mob.cat.meow");
        LegacySound.register("entity.pig.step", "mob.pig.step");
        LegacySound.register("record.strad", "records.strad");
        LegacySound.register("block.wood.hit", "step.wood");
        LegacySound.register("block.wood.fall", "step.wood");
        LegacySound.register("block.wood.step", "step.wood");
        LegacySound.register("block.portal.travel", "portal.travel");
        LegacySound.register("entity.guardian.death", "mob.guardian.death");
        LegacySound.register("entity.skeleton.death", "mob.skeleton.death");
        LegacySound.register("entity.horse.hurt", "mob.horse.hit");
        LegacySound.register("entity.villager.hurt", "mob.villager.hit");
        LegacySound.register("entity.skeleton_horse.ambient", "mob.horse.skeleton.idle");
        LegacySound.register("block.chest.open", "random.chestopen");
        LegacySound.register("block.chest.close", "random.chestclosed");
    }
}

