/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper;

import protocolsupport.api.chat.ChatAPI;
import protocolsupport.api.chat.components.BaseComponent;
import protocolsupport.api.chat.components.TranslateComponent;
import protocolsupport.api.chat.modifiers.ClickAction;
import protocolsupport.api.chat.modifiers.HoverAction;
import protocolsupport.protocol.utils.data.ItemData;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;

public class LegacyChatJson {
    public static String convert(String message) {
        BaseComponent component = ChatAPI.fromJSON(message);
        LegacyChatJson.walkComponent(component);
        return ChatAPI.toJSON(component);
    }

    private static void walkComponent(BaseComponent component) {
        LegacyChatJson.fixComponent(component);
        if (component instanceof TranslateComponent) {
            for (BaseComponent arg : ((TranslateComponent)component).getTranslationArgs()) {
                LegacyChatJson.walkComponent(arg);
            }
        }
        for (BaseComponent sibling : component.getSiblings()) {
            LegacyChatJson.walkComponent(sibling);
        }
    }

    private static void fixComponent(BaseComponent component) {
        ClickAction click;
        HoverAction hover = component.getHoverAction();
        if (hover != null && hover.getType() == HoverAction.Type.SHOW_ITEM) {
            NBTTagCompoundWrapper compound = ServerPlatform.get().getWrapperFactory().createNBTCompoundFromJson(hover.getValue());
            Integer id = ItemData.getIdByName(compound.getString("id"));
            if (id != null) {
                compound.setInt("id", id);
            }
            component.setHoverAction(new HoverAction(HoverAction.Type.SHOW_ITEM, compound.toString()));
        }
        if ((click = component.getClickAction()) != null && click.getType() == ClickAction.Type.OPEN_URL) {
            String url = click.getValue();
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            component.setClickAction(new ClickAction(ClickAction.Type.OPEN_URL, url));
        }
    }
}

