/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.logger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.plugin.java.JavaPlugin;
import protocolsupport.ProtocolSupport;
import protocolsupport.utils.Utils;

public class AsyncErrorLogger {
    private static final boolean enabled = Utils.getJavaPropertyValue("errlog.enabled", true, Utils.Converter.STRING_TO_BOOLEAN);
    private static final long maxFileSize = Utils.getJavaPropertyValue("errlog.maxsize", 0x1400000L, Utils.Converter.STRING_TO_LONG);
    private static final String filePath = Utils.getJavaPropertyValue("errlog.path", ((ProtocolSupport)JavaPlugin.getPlugin(ProtocolSupport.class)).getName() + "-errlog", Utils.Converter.NONE);
    public static final AsyncErrorLogger INSTANCE = new AsyncErrorLogger();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, JavaPlugin.getPlugin(ProtocolSupport.class) + "-errlog-thread");
        }
    });
    private final Object lock = new Object();
    private PrintWriter writer;

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }

    private AsyncErrorLogger() {
        if (!enabled) {
            this.stop();
            return;
        }
        try {
            File logfile = new File(filePath);
            if (logfile.length() > maxFileSize) {
                logfile.delete();
            }
            logfile.createNewFile();
            this.writer = new PrintWriter(new FileOutputStream(logfile, true));
        }
        catch (Exception e) {
            ProtocolSupport.logWarning("Unable to create error log");
            this.stop();
        }
    }

    public void log(final Throwable t, final Object ... info) {
        if (this.executor.isShutdown()) {
            return;
        }
        try {
            this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AsyncErrorLogger.this.lock;
                    synchronized (object) {
                        AsyncErrorLogger.this.writer.println("Error occured at " + new SimpleDateFormat("yyyy-MM-dd-HH-mm", Locale.ROOT).format(new Date()));
                        AsyncErrorLogger.this.writer.println("Additional info: " + String.join((CharSequence)", ", Arrays.asList(info).stream().map(obj -> String.valueOf(obj)).collect(Collectors.toList())));
                        AsyncErrorLogger.this.writer.println("Exception class: " + t.getClass().getName());
                        AsyncErrorLogger.this.writer.println("Exception message: " + t.getMessage());
                        AsyncErrorLogger.this.writer.println("Exception log:");
                        t.printStackTrace(AsyncErrorLogger.this.writer);
                        AsyncErrorLogger.this.writer.println();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

