/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api.events;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.HandlerList;
import protocolsupport.api.Connection;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.api.events.ConnectionEvent;
import protocolsupport.zplatform.ServerPlatform;

public class ServerPingResponseEvent
extends ConnectionEvent {
    private ProtocolInfo info;
    private String motd;
    private String icon;
    private int maxPlayers;
    private List<String> players;
    private static final HandlerList list = new HandlerList();

    public ServerPingResponseEvent(Connection connection, ProtocolInfo info, String icon, String motd, int maxPlayers, List<String> players) {
        super(connection);
        this.setProtocolInfo(info);
        this.setIcon(icon);
        this.setMotd(motd);
        this.setMaxPlayers(maxPlayers);
        this.setPlayers(players);
    }

    @Deprecated
    public ServerPingResponseEvent(InetSocketAddress address, ProtocolInfo info, String icon, String motd, int maxPlayers, List<String> players) {
        this(ProtocolSupportAPI.getConnection(address), info, icon, motd, maxPlayers, players);
    }

    public InetSocketAddress getAddress() {
        return this.getConnection().getAddress();
    }

    public ProtocolInfo getProtocolInfo() {
        return this.info;
    }

    public void setProtocolInfo(ProtocolInfo info) {
        this.info = info != null ? info : new ProtocolInfo(-1, "ProtocolSupport");
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String motd) {
        this.motd = motd != null ? motd : "A minecraft server (ProtocolSupport)";
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public List<String> getPlayers() {
        return new ArrayList<String>(this.players);
    }

    public void setPlayers(List<String> players) {
        this.players = players != null ? new ArrayList<String>(players) : new ArrayList();
    }

    public HandlerList getHandlers() {
        return list;
    }

    public static HandlerList getHandlerList() {
        return list;
    }

    public static String getServerModName() {
        return ServerPlatform.get().getMiscUtils().getModName();
    }

    public static String getServerVersionName() {
        return ServerPlatform.get().getMiscUtils().getVersionName();
    }

    public static class ProtocolInfo {
        private final int id;
        private final String name;

        public ProtocolInfo(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public ProtocolInfo(ProtocolVersion version, String name) {
            this(version.getId(), name);
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

