/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.libs.pluginutils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.ClassPath;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.Module;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.PluginHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class Registry {
    private final Map<Class<? extends Module>, Module> moduleMap = Maps.newConcurrentMap();
    private final PluginHolder plugin;
    private final ClassLoader classLoader;

    public Registry(PluginHolder plugin, ClassLoader classLoader) {
        this.plugin = plugin;
        this.classLoader = classLoader;
    }

    public void registerModules(String path) {
        ArrayList classes = Lists.newArrayList();
        try {
            ClassPath classPath = ClassPath.from((ClassLoader)this.classLoader);
            for (ClassPath.ClassInfo info : classPath.getTopLevelClassesRecursive(path)) {
                Class<?> clazz = Class.forName(info.getName());
                if (!Module.class.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to scan for modules", e);
        }
        this.registerModules(classes.toArray(new Class[0]));
    }

    public void registerModules(Class<? extends Module> ... modules) {
        this.registerModules(false, modules);
    }

    protected void registerModules(boolean local, Class<? extends Module> ... modules) {
        for (Class<? extends Module> moduleClass : modules) {
            try {
                Module instance = (Module)moduleClass.getConstructors()[0].newInstance(new Object[]{this.plugin});
                instance.local = local;
                this.moduleMap.put(moduleClass, instance);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to init module", e);
            }
        }
    }

    protected void enableModules(boolean local) {
        for (Module module : new ArrayList<Module>(this.moduleMap.values())) {
            if (module.local != local) continue;
            this.enableModule(module);
        }
        for (Module module : new ArrayList<Module>(this.moduleMap.values())) {
            if (module.local != local) continue;
            this.enableModule(module);
        }
    }

    protected void disableModules(boolean local) {
        for (Module module : new ArrayList<Module>(this.moduleMap.values())) {
            if (module.local != local) continue;
            module.disable();
            module.enabled = false;
        }
        for (Module module : new ArrayList<Module>(this.moduleMap.values())) {
            if (module.local != local) continue;
            module.disable();
            module.enabled = false;
        }
    }

    private void enableModule(Module module) {
        if (module.enabled) {
            return;
        }
        List<Class<Module>> required = module.getRequiredModules();
        for (Class<Module> moduleClass : required) {
            Module dep = this.moduleMap.get(moduleClass);
            this.enableModule(dep);
        }
        module.enable();
        module.enabled = true;
    }

    public <T extends Module> T getModule(Class<T> moduleClass) {
        return (T)((Module)moduleClass.cast(this.moduleMap.get(moduleClass)));
    }
}

