/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.internal;

import com.lenis0012.bukkit.marriage2.MData;
import com.lenis0012.bukkit.marriage2.MPlayer;
import com.lenis0012.bukkit.marriage2.commands.Command;
import com.lenis0012.bukkit.marriage2.config.Message;
import com.lenis0012.bukkit.marriage2.config.Permissions;
import com.lenis0012.bukkit.marriage2.config.Settings;
import com.lenis0012.bukkit.marriage2.internal.Dependencies;
import com.lenis0012.bukkit.marriage2.internal.MarriageBase;
import com.lenis0012.bukkit.marriage2.internal.MarriagePlugin;
import com.lenis0012.bukkit.marriage2.internal.Register;
import com.lenis0012.bukkit.marriage2.internal.data.DataConverter;
import com.lenis0012.bukkit.marriage2.internal.data.DataManager;
import com.lenis0012.bukkit.marriage2.internal.data.MarriageData;
import com.lenis0012.bukkit.marriage2.internal.data.MarriagePlayer;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.modules.configuration.ConfigurationModule;
import com.lenis0012.bukkit.marriage2.libs.updater.api.ReleaseType;
import com.lenis0012.bukkit.marriage2.libs.updater.api.Updater;
import com.lenis0012.bukkit.marriage2.libs.updater.api.UpdaterFactory;
import com.lenis0012.bukkit.marriage2.misc.ListQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class MarriageCore
extends MarriageBase {
    private final Map<UUID, MarriagePlayer> players = Collections.synchronizedMap(new HashMap());
    private DataManager dataManager;
    private Updater updater;
    private Dependencies dependencies;

    public MarriageCore(MarriagePlugin plugin) {
        super(plugin);
    }

    @Register(name="config", type=Register.Type.ENABLE, priority=0)
    public void loadConfig() {
        this.enable();
        ConfigurationModule module = this.plugin.getModule(ConfigurationModule.class);
        module.registerSettings(Settings.class);
        module.reloadSettings(Settings.class, true);
        Message.reloadAll(this);
        Permissions.setupChildRelations();
    }

    @Register(name="dependencies", type=Register.Type.ENABLE, priority=1)
    public void loadDependencies() {
        this.dependencies = new Dependencies(this);
    }

    @Register(name="database", type=Register.Type.ENABLE)
    public void loadDatabase() {
        this.dataManager = new DataManager(this);
        for (Player player : Bukkit.getOnlinePlayers()) {
            MarriagePlayer mp = this.dataManager.loadPlayer(player.getUniqueId());
            this.setMPlayer(player.getUniqueId(), mp);
        }
    }

    @Register(name="listeners", type=Register.Type.ENABLE)
    public void registerListeners() {
        for (Listener listener : this.findObjects("com.lenis0012.bukkit.marriage2.listeners", Listener.class, this)) {
            this.register(listener);
        }
    }

    @Register(name="commands", type=Register.Type.ENABLE)
    public void registerCommands() {
        for (Class<Command> command : this.findClasses("com.lenis0012.bukkit.marriage2.commands", Command.class, new Object[0])) {
            this.register(command);
        }
    }

    @Register(name="updater", type=Register.Type.ENABLE, priority=9)
    public void loadUpdater() {
        UpdaterFactory factory = new UpdaterFactory((Plugin)this.plugin, "com.lenis0012.bukkit.marriage2.libs.updater");
        this.updater = factory.newUpdater(this.plugin.getPluginFile(), Settings.ENABLE_UPDATE_CHACKER.value());
        this.updater.setChannel(ReleaseType.valueOf(Settings.UPDATER_CHANNEL.value().toUpperCase()));
    }

    @Register(name="converter", type=Register.Type.ENABLE, priority=10)
    public void loadConverter() {
        DataConverter converter = new DataConverter(this);
        if (converter.isOutdated()) {
            converter.convert();
        }
    }

    @Register(name="database", type=Register.Type.DISABLE)
    public void saveDatabase() {
        this.unloadAll();
        this.dataManager.close();
        Permissions.unloadAll();
    }

    @Override
    public MPlayer getMPlayer(UUID uuid) {
        MarriagePlayer player = this.players.get(uuid);
        if (player == null) {
            player = this.dataManager.loadPlayer(uuid);
            this.players.put(uuid, player);
        }
        return player;
    }

    @Override
    public MData marry(MPlayer player1, MPlayer player2) {
        MarriageData mdata = new MarriageData(this.dataManager, player1.getUniqueId(), player2.getUniqueId());
        mdata.saveAsync();
        ((MarriagePlayer)player1).addMarriage(mdata);
        ((MarriagePlayer)player2).addMarriage(mdata);
        this.dataManager.savePlayer((MarriagePlayer)player1);
        return mdata;
    }

    @Override
    public ListQuery getMarriageList(int scale, int page) {
        return this.dataManager.listMarriages(scale, page);
    }

    public void setMPlayer(UUID uuid, MarriagePlayer mp) {
        this.players.put(uuid, mp);
    }

    public boolean isMPlayerSet(UUID uuid) {
        return this.players.containsKey(uuid);
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public void removeMarriage(final MData mdata) {
        new Thread(){

            @Override
            public void run() {
                MarriageCore.this.dataManager.deleteMarriage(mdata.getPlayer1Id(), mdata.getPllayer2Id());
            }
        }.start();
    }

    public void unloadPlayer(UUID uuid) {
        final MarriagePlayer mPlayer = this.players.remove(uuid);
        if (mPlayer != null) {
            new Thread(){

                @Override
                public void run() {
                    MarriageCore.this.dataManager.savePlayer(mPlayer);
                }
            }.start();
        }
    }

    public void unloadAll() {
        for (MarriagePlayer mp : this.players.values()) {
            this.dataManager.savePlayer(mp);
        }
        this.players.clear();
    }

    @Override
    public Dependencies dependencies() {
        return this.dependencies;
    }
}

