/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.internal;

import com.google.common.collect.Lists;
import com.google.common.reflect.ClassPath;
import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.commands.Command;
import com.lenis0012.bukkit.marriage2.internal.MarriageCommandExecutor;
import com.lenis0012.bukkit.marriage2.internal.MarriagePlugin;
import com.lenis0012.bukkit.marriage2.misc.BConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class MarriageBase
implements Marriage {
    protected final MarriagePlugin plugin;
    private final ClassPath classPath;
    private MarriageCommandExecutor commandExecutor;

    public MarriageBase(MarriagePlugin plugin) {
        this.plugin = plugin;
        try {
            this.classPath = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to intialize class path!", e);
        }
    }

    void enable() {
        this.commandExecutor = new MarriageCommandExecutor(this);
        this.plugin.getCommand("marry").setExecutor((CommandExecutor)this.commandExecutor);
    }

    @Override
    public void register(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
    }

    @Override
    public void register(Class<? extends Command> commandClass) {
        this.commandExecutor.regster(commandClass);
    }

    @Override
    public BConfig getBukkitConfig(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        return new BConfig(this, file);
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public MarriagePlugin getPlugin() {
        return this.plugin;
    }

    public MarriageCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    protected <T> List<Class<? extends T>> findClasses(String pkg, Class<T> type, Object ... params) {
        ArrayList list = Lists.newArrayList();
        for (ClassPath.ClassInfo info : this.classPath.getTopLevelClassesRecursive(pkg)) {
            try {
                Class<?> clazz = Class.forName(info.getName());
                if (!type.isAssignableFrom(clazz) || type.equals(clazz)) continue;
                list.add(clazz);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to intiate class", e);
            }
        }
        return list;
    }

    protected <T> List<T> findObjects(String pkg, Class<T> type, Object ... params) {
        ArrayList list = Lists.newArrayList();
        for (Class<T> clazz : this.findClasses(pkg, type, new Object[0])) {
            try {
                list.add(type.cast(clazz.getConstructors()[0].newInstance(params)));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to construct class", e);
            }
        }
        return list;
    }
}

