#!/usr/bin/perl -w
use strict;

print "Enter output filename: ";
my $file = <>;
chomp($file);
print $file . "\n";

open OUT, ">$file";

my $startX;
my $startY;
my $startZ;
my $sizeX;
my $sizeY;
my $sizeZ;
my $bufferX;
my $bufferZ;
my $plotsX;
my $plotsZ;
my $world;
my $plotPrefix;
my $plotName;
my $owner;
my $input;

print "Enter the world name: ";
$world = <>;
chomp($world);
print "Starting X coordinate: ";
$startX = <>;
chomp($startX);
print "Starting Y coordinate: ";
$startY = <>;
chomp($startY);
print "Starting Z coordinate: ";
$startZ = <>;
chomp($startZ);
print "Size of plots on X axis: ";
$sizeX = <>;
chomp($sizeX);
print "Size of plots on Y axis: ";
$sizeY = <>;
chomp($sizeY);
print "Size of plots on Z axis: ";
$sizeZ = <>;
chomp($sizeZ);
print "Blocks between plots on X axis: ";
$bufferX = <>;
chomp($bufferX);
print "Blocks between plots on Z axis: ";
$bufferZ = <>;
chomp($bufferZ);
print "Number of plots on X axis: ";
$plotsX = <>;
chomp($plotsX);
print "Number of plots on Z axis: ";
$plotsZ = <>;
chomp($plotsZ);
print "Default owner name: ";
$owner = <>;
chomp($owner);
print "Residence name prefix: ";
$plotPrefix = <>;
chomp($plotPrefix);

my $plotID = 1;
print OUT "Residences:\n";
for (my $currentX = 0; $currentX < $plotsX; $currentX++ ) {
	for (my $currentZ = 0; $currentZ < $plotsZ; $currentZ++ ) {
		$plotName = "$plotPrefix$plotID";
		print OUT "  $plotName:\n";
		print OUT "    EnterMessage: Welcome %player to %residence, owned by %owner\n";
		print OUT "    BlackList:\n";
		print OUT "      Type: BLACKLIST\n";
		print OUT "      ItemList: []\n";
		print OUT "    LeaveMessage: Now leaving %residence.\n";
		print OUT "    IgnoreList:\n";
		print OUT "      Type: IGNORELIST\n";
		print OUT "      ItemList: []\n";
		print OUT "    Areas:\n";
		print OUT "      main:\n";
		print OUT "        X1: " . ($currentX * ($sizeX + $bufferX) + $startX) . "\n";
		print OUT "        Y1: " . $startY . "\n";
		print OUT "        Z1: " . ($currentZ * ($sizeZ + $bufferZ) + $startZ) . "\n";
		print OUT "        X2: " . ($currentX * ($sizeX + $bufferX) + $startX + $sizeX) . "\n";
		print OUT "        Y2: " . ($startY + $sizeY) . "\n";
		print OUT "        Z2: " . ($currentZ * ($sizeZ + $bufferZ) + $startZ + $sizeZ) . "\n";
		print OUT "    Subzones: {}\n";
		print OUT "    Permissions:\n";
		print OUT "      PlayerFlags:\n";
		print OUT "        $owner:\n";
		print OUT "          container: true\n";
		print OUT "          ignite: true\n";
		print OUT "          use: true\n";
		print OUT "          build: true\n";
		print OUT "          move: true\n";
		print OUT "      GroupFlags: {}\n";
		print OUT "      AreaFlags:\n";
		print OUT "        pvp: false\n";
		print OUT "        firespread: false\n";
		print OUT "        container: false\n";
		print OUT "        tnt: false\n";
		print OUT "        ignite: false\n";
		print OUT "        piston: false\n";
		print OUT "        use: false\n";
		print OUT "        creeper: false\n";
		print OUT "        flow: false\n";
		print OUT "        build: false\n";
		print OUT "      Owner: $owner\n";
		print OUT "      World: $world\n";
		print OUT "    StoredMoney: 0\n";
		$plotID++;
	}
}
