/**
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Copyright 2011-2017 Peter Güttinger and contributors
 */
package ch.njol.skript.effects;

import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

@Name("Make Invulnerable")
@Description("Makes an entity invulnerable/not invulnerable.")
@Examples("make target entity invulnerable")
@Since("INSERT VERSION")
public class EffInvulnerability extends Effect {
	
	static {
		Skript.registerEffect(EffInvulnerability.class,
			"make %entities% invulnerable",
			"make %entities% (not invulnerable|vulnerable)");
	}
	
	@SuppressWarnings("null")
	private Expression<Entity> entities;
	private boolean invulnerable;
	
	@SuppressWarnings({"unchecked", "null"})
	@Override
	public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, ParseResult parseResult) {
		entities = (Expression<Entity>) exprs[0];
		invulnerable = matchedPattern == 0;
		return true;
	}
	
	@Override
	protected void execute(Event e) {
		for (Entity entity : entities.getArray(e)) {
			entity.setInvulnerable(invulnerable);
		}
	}
	
	@Override
	public String toString(@Nullable Event e, boolean debug) {
		return "make " + entities.toString(e, debug) + (invulnerable ? " invulnerable" : " not invulnerable");
	}
	
}
