/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.BlockEventHandler;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.RestoreNatureProcessingTask;
import me.ryanhamshire.GriefPrevention.SiegeData;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Claim {
    Location lesserBoundaryCorner;
    Location greaterBoundaryCorner;
    public Date modifiedDate;
    Long id = null;
    public UUID ownerID;
    public ArrayList<String> managers = new ArrayList();
    private HashMap<String, ClaimPermission> playerIDToClaimPermissionMap = new HashMap();
    public boolean inDataStore = false;
    public boolean areExplosivesAllowed = false;
    public Claim parent = null;
    public ArrayList<Claim> children = new ArrayList();
    public SiegeData siegeData = null;
    public boolean doorsOpen = false;
    private List<Material> placeableFarmingBlocksList = Arrays.asList(Material.PUMPKIN_STEM, Material.CROPS, Material.MELON_STEM, Material.CARROT, Material.POTATO, Material.NETHER_WARTS, Material.BEETROOT_BLOCK);

    public boolean isAdminClaim() {
        if (this.parent != null) {
            return this.parent.isAdminClaim();
        }
        return this.ownerID == null;
    }

    public Long getID() {
        return this.id;
    }

    Claim() {
        this.modifiedDate = Calendar.getInstance().getTime();
    }

    public boolean canSiege(Player defender) {
        if (this.isAdminClaim()) {
            return false;
        }
        return this.allowAccess(defender) == null;
    }

    public void removeSurfaceFluids(Claim exclusionClaim) {
        if (this.isAdminClaim()) {
            return;
        }
        if (this.getArea() > 10000) {
            return;
        }
        if (!GriefPrevention.instance.creativeRulesApply(this.lesserBoundaryCorner)) {
            return;
        }
        Location lesser = this.getLesserBoundaryCorner();
        Location greater = this.getGreaterBoundaryCorner();
        if (lesser.getWorld().getEnvironment() == World.Environment.NETHER) {
            return;
        }
        int seaLevel = 0;
        if (lesser.getWorld().getEnvironment() == World.Environment.NORMAL) {
            seaLevel = GriefPrevention.instance.getSeaLevel(lesser.getWorld());
        }
        int x = lesser.getBlockX();
        while (x <= greater.getBlockX()) {
            int z = lesser.getBlockZ();
            while (z <= greater.getBlockZ()) {
                int y = seaLevel - 1;
                while (y <= lesser.getWorld().getMaxHeight()) {
                    Block block = lesser.getWorld().getBlockAt(x, y, z);
                    if (!(exclusionClaim != null && exclusionClaim.contains(block.getLocation(), true, false) || block.getType() != Material.STATIONARY_LAVA && block.getType() != Material.WATER && block.getType() != Material.STATIONARY_WATER && block.getType() != Material.LAVA)) {
                        block.setType(Material.AIR);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    boolean hasSurfaceFluids() {
        Location lesser = this.getLesserBoundaryCorner();
        Location greater = this.getGreaterBoundaryCorner();
        if (this.getArea() > 10000) {
            return false;
        }
        int seaLevel = 0;
        if (lesser.getWorld().getEnvironment() == World.Environment.NORMAL) {
            seaLevel = GriefPrevention.instance.getSeaLevel(lesser.getWorld());
        }
        int x = lesser.getBlockX();
        while (x <= greater.getBlockX()) {
            int z = lesser.getBlockZ();
            while (z <= greater.getBlockZ()) {
                int y = seaLevel - 1;
                while (y <= lesser.getWorld().getMaxHeight()) {
                    Block block = lesser.getWorld().getBlockAt(x, y, z);
                    if (block.getType() == Material.STATIONARY_LAVA || block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER || block.getType() == Material.LAVA) {
                        return true;
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return false;
    }

    Claim(Location lesserBoundaryCorner, Location greaterBoundaryCorner, UUID ownerID, List<String> builderIDs, List<String> containerIDs, List<String> accessorIDs, List<String> managerIDs, Long id) {
        this.modifiedDate = Calendar.getInstance().getTime();
        this.id = id;
        this.lesserBoundaryCorner = lesserBoundaryCorner;
        this.greaterBoundaryCorner = greaterBoundaryCorner;
        this.ownerID = ownerID;
        for (String builderID : builderIDs) {
            if (builderID == null || builderID.isEmpty()) continue;
            this.playerIDToClaimPermissionMap.put(builderID, ClaimPermission.Build);
        }
        for (String containerID : containerIDs) {
            if (containerID == null || containerID.isEmpty()) continue;
            this.playerIDToClaimPermissionMap.put(containerID, ClaimPermission.Inventory);
        }
        for (String accessorID : accessorIDs) {
            if (accessorID == null || accessorID.isEmpty()) continue;
            this.playerIDToClaimPermissionMap.put(accessorID, ClaimPermission.Access);
        }
        for (String managerID : managerIDs) {
            if (managerID == null || managerID.isEmpty()) continue;
            this.managers.add(managerID);
        }
    }

    public int getArea() {
        int claimWidth = this.greaterBoundaryCorner.getBlockX() - this.lesserBoundaryCorner.getBlockX() + 1;
        int claimHeight = this.greaterBoundaryCorner.getBlockZ() - this.lesserBoundaryCorner.getBlockZ() + 1;
        return claimWidth * claimHeight;
    }

    public int getWidth() {
        return this.greaterBoundaryCorner.getBlockX() - this.lesserBoundaryCorner.getBlockX() + 1;
    }

    public int getHeight() {
        return this.greaterBoundaryCorner.getBlockZ() - this.lesserBoundaryCorner.getBlockZ() + 1;
    }

    public boolean isNear(Location location, int howNear) {
        Claim claim = new Claim(new Location(this.lesserBoundaryCorner.getWorld(), (double)(this.lesserBoundaryCorner.getBlockX() - howNear), (double)this.lesserBoundaryCorner.getBlockY(), (double)(this.lesserBoundaryCorner.getBlockZ() - howNear)), new Location(this.greaterBoundaryCorner.getWorld(), (double)(this.greaterBoundaryCorner.getBlockX() + howNear), (double)this.greaterBoundaryCorner.getBlockY(), (double)(this.greaterBoundaryCorner.getBlockZ() + howNear)), null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null);
        return claim.contains(location, false, true);
    }

    public String allowEdit(Player player) {
        if (player == null) {
            return "";
        }
        if (this.isAdminClaim() ? player.hasPermission("griefprevention.adminclaims") : player.hasPermission("griefprevention.deleteclaims")) {
            return null;
        }
        if (player.getUniqueId().equals(this.ownerID)) {
            if (this.siegeData != null) {
                return GriefPrevention.instance.dataStore.getMessage(Messages.NoModifyDuringSiege, new String[0]);
            }
            return null;
        }
        if (this.parent != null) {
            return this.parent.allowEdit(player);
        }
        return GriefPrevention.instance.dataStore.getMessage(Messages.OnlyOwnersModifyClaims, this.getOwnerName());
    }

    private boolean placeableForFarming(Material material) {
        return this.placeableFarmingBlocksList.contains(material);
    }

    public String allowBuild(Player player, Material material) {
        if (player == null) {
            return "";
        }
        GriefPrevention.instance.dataStore.tryExtendSiege(player, this);
        if (this.isAdminClaim() && player.hasPermission("griefprevention.adminclaims")) {
            return null;
        }
        if (this.siegeData != null) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildUnderSiege, this.siegeData.attacker.getName());
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.inPvpCombat()) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildPvP, new String[0]);
        }
        if (player.getUniqueId().equals(this.ownerID) || GriefPrevention.instance.dataStore.getPlayerData((UUID)player.getUniqueId()).ignoreClaims) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Build)) {
            return null;
        }
        ClaimPermission permissionLevel = this.playerIDToClaimPermissionMap.get("public");
        if (ClaimPermission.Build == permissionLevel) {
            return null;
        }
        if (this.allowContainers(player) == null && this.placeableForFarming(material)) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.allowBuild(player, material);
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildPermission, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = String.valueOf(reason) + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    private boolean hasExplicitPermission(Player player, ClaimPermission level) {
        String playerID = player.getUniqueId().toString();
        Set<String> keys = this.playerIDToClaimPermissionMap.keySet();
        for (String identifier : keys) {
            String permissionIdentifier;
            if (playerID.equalsIgnoreCase(identifier) && this.playerIDToClaimPermissionMap.get(identifier) == level) {
                return true;
            }
            if (!identifier.startsWith("[") || !identifier.endsWith("]") || (permissionIdentifier = identifier.substring(1, identifier.length() - 1)) == null || permissionIdentifier.isEmpty() || !player.hasPermission(permissionIdentifier) || this.playerIDToClaimPermissionMap.get(identifier) != level) continue;
            return true;
        }
        return false;
    }

    public String allowBreak(Player player, Material material) {
        if (this.siegeData != null || this.doorsOpen) {
            boolean breakable = false;
            int i = 0;
            while (i < GriefPrevention.instance.config_siege_blocks.size()) {
                Material breakableMaterial = GriefPrevention.instance.config_siege_blocks.get(i);
                if (breakableMaterial == material) {
                    breakable = true;
                    break;
                }
                ++i;
            }
            if (!breakable) {
                return GriefPrevention.instance.dataStore.getMessage(Messages.NonSiegeMaterial, new String[0]);
            }
            if (player.getUniqueId().equals(this.ownerID)) {
                return GriefPrevention.instance.dataStore.getMessage(Messages.NoOwnerBuildUnderSiege, new String[0]);
            }
            return null;
        }
        return this.allowBuild(player, material);
    }

    public String allowAccess(Player player) {
        if (this.doorsOpen) {
            return null;
        }
        if (this.isAdminClaim() && player.hasPermission("griefprevention.adminclaims")) {
            return null;
        }
        if (player.getUniqueId().equals(this.ownerID) || GriefPrevention.instance.dataStore.getPlayerData((UUID)player.getUniqueId()).ignoreClaims) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Access)) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Inventory)) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Build)) {
            return null;
        }
        ClaimPermission permissionLevel = this.playerIDToClaimPermissionMap.get("public");
        if (ClaimPermission.Build == permissionLevel || ClaimPermission.Inventory == permissionLevel || ClaimPermission.Access == permissionLevel) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.allowAccess(player);
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoAccessPermission, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = String.valueOf(reason) + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    public String allowContainers(Player player) {
        if (player == null) {
            return "";
        }
        GriefPrevention.instance.dataStore.tryExtendSiege(player, this);
        if (this.siegeData != null) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.NoContainersSiege, this.siegeData.attacker.getName());
        }
        if (player.getUniqueId().equals(this.ownerID) || GriefPrevention.instance.dataStore.getPlayerData((UUID)player.getUniqueId()).ignoreClaims) {
            return null;
        }
        if (this.isAdminClaim() && player.hasPermission("griefprevention.adminclaims")) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Inventory)) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Build)) {
            return null;
        }
        ClaimPermission permissionLevel = this.playerIDToClaimPermissionMap.get("public");
        if (ClaimPermission.Build == permissionLevel || ClaimPermission.Inventory == permissionLevel) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.allowContainers(player);
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoContainersPermission, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = String.valueOf(reason) + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    public String allowGrantPermission(Player player) {
        if (player == null) {
            return "";
        }
        if (this.allowEdit(player) == null) {
            return null;
        }
        int i = 0;
        while (i < this.managers.size()) {
            String managerID = this.managers.get(i);
            if (player.getUniqueId().toString().equals(managerID)) {
                return null;
            }
            if (managerID.startsWith("[") && managerID.endsWith("]") && (managerID = managerID.substring(1, managerID.length() - 1)) != null && !managerID.isEmpty() && player.hasPermission(managerID)) {
                return null;
            }
            ++i;
        }
        if (this.parent != null) {
            return this.parent.allowGrantPermission(player);
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoPermissionTrust, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = String.valueOf(reason) + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    public void setPermission(String playerID, ClaimPermission permissionLevel) {
        this.playerIDToClaimPermissionMap.put(playerID.toLowerCase(), permissionLevel);
    }

    public void dropPermission(String playerID) {
        this.playerIDToClaimPermissionMap.remove(playerID.toLowerCase());
        for (Claim child : this.children) {
            child.dropPermission(playerID);
        }
    }

    public void clearPermissions() {
        this.playerIDToClaimPermissionMap.clear();
        this.managers.clear();
        for (Claim child : this.children) {
            child.clearPermissions();
        }
    }

    public void getPermissions(ArrayList<String> builders, ArrayList<String> containers, ArrayList<String> accessors, ArrayList<String> managers) {
        for (Map.Entry<String, ClaimPermission> entry : this.playerIDToClaimPermissionMap.entrySet()) {
            if (entry.getValue() == ClaimPermission.Build) {
                builders.add(entry.getKey());
                continue;
            }
            if (entry.getValue() == ClaimPermission.Inventory) {
                containers.add(entry.getKey());
                continue;
            }
            accessors.add(entry.getKey());
        }
        int i = 0;
        while (i < this.managers.size()) {
            managers.add(this.managers.get(i));
            ++i;
        }
    }

    public Location getLesserBoundaryCorner() {
        return this.lesserBoundaryCorner.clone();
    }

    public Location getGreaterBoundaryCorner() {
        return this.greaterBoundaryCorner.clone();
    }

    public String getOwnerName() {
        if (this.parent != null) {
            return this.parent.getOwnerName();
        }
        if (this.ownerID == null) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.OwnerNameForAdminClaims, new String[0]);
        }
        return GriefPrevention.lookupPlayerName(this.ownerID);
    }

    public boolean contains(Location location, boolean ignoreHeight, boolean excludeSubdivisions) {
        boolean inClaim;
        if (!location.getWorld().equals(this.lesserBoundaryCorner.getWorld())) {
            return false;
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        boolean bl = inClaim = (ignoreHeight || y >= this.lesserBoundaryCorner.getY()) && x >= this.lesserBoundaryCorner.getX() && x < this.greaterBoundaryCorner.getX() + 1.0 && z >= this.lesserBoundaryCorner.getZ() && z < this.greaterBoundaryCorner.getZ() + 1.0;
        if (!inClaim) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.contains(location, ignoreHeight, false);
        }
        if (excludeSubdivisions) {
            int i = 0;
            while (i < this.children.size()) {
                if (this.children.get(i).contains(location, ignoreHeight, true)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    boolean overlaps(Claim otherClaim) {
        if (!this.lesserBoundaryCorner.getWorld().equals(otherClaim.getLesserBoundaryCorner().getWorld())) {
            return false;
        }
        if (otherClaim.contains(this.lesserBoundaryCorner, true, false)) {
            return true;
        }
        if (otherClaim.contains(this.greaterBoundaryCorner, true, false)) {
            return true;
        }
        if (otherClaim.contains(new Location(this.lesserBoundaryCorner.getWorld(), (double)this.lesserBoundaryCorner.getBlockX(), 0.0, (double)this.greaterBoundaryCorner.getBlockZ()), true, false)) {
            return true;
        }
        if (otherClaim.contains(new Location(this.lesserBoundaryCorner.getWorld(), (double)this.greaterBoundaryCorner.getBlockX(), 0.0, (double)this.lesserBoundaryCorner.getBlockZ()), true, false)) {
            return true;
        }
        if (this.contains(otherClaim.getLesserBoundaryCorner(), true, false)) {
            return true;
        }
        if (this.getLesserBoundaryCorner().getBlockZ() <= otherClaim.getGreaterBoundaryCorner().getBlockZ() && this.getLesserBoundaryCorner().getBlockZ() >= otherClaim.getLesserBoundaryCorner().getBlockZ() && this.getLesserBoundaryCorner().getBlockX() < otherClaim.getLesserBoundaryCorner().getBlockX() && this.getGreaterBoundaryCorner().getBlockX() > otherClaim.getGreaterBoundaryCorner().getBlockX()) {
            return true;
        }
        if (this.getGreaterBoundaryCorner().getBlockZ() <= otherClaim.getGreaterBoundaryCorner().getBlockZ() && this.getGreaterBoundaryCorner().getBlockZ() >= otherClaim.getLesserBoundaryCorner().getBlockZ() && this.getLesserBoundaryCorner().getBlockX() < otherClaim.getLesserBoundaryCorner().getBlockX() && this.getGreaterBoundaryCorner().getBlockX() > otherClaim.getGreaterBoundaryCorner().getBlockX()) {
            return true;
        }
        if (this.getLesserBoundaryCorner().getBlockX() <= otherClaim.getGreaterBoundaryCorner().getBlockX() && this.getLesserBoundaryCorner().getBlockX() >= otherClaim.getLesserBoundaryCorner().getBlockX() && this.getLesserBoundaryCorner().getBlockZ() < otherClaim.getLesserBoundaryCorner().getBlockZ() && this.getGreaterBoundaryCorner().getBlockZ() > otherClaim.getGreaterBoundaryCorner().getBlockZ()) {
            return true;
        }
        return this.getGreaterBoundaryCorner().getBlockX() <= otherClaim.getGreaterBoundaryCorner().getBlockX() && this.getGreaterBoundaryCorner().getBlockX() >= otherClaim.getLesserBoundaryCorner().getBlockX() && this.getLesserBoundaryCorner().getBlockZ() < otherClaim.getLesserBoundaryCorner().getBlockZ() && this.getGreaterBoundaryCorner().getBlockZ() > otherClaim.getGreaterBoundaryCorner().getBlockZ();
    }

    public String allowMoreEntities(boolean remove) {
        if (this.parent != null) {
            return this.parent.allowMoreEntities(remove);
        }
        if (!GriefPrevention.instance.creativeRulesApply(this.getLesserBoundaryCorner())) {
            return null;
        }
        if (this.isAdminClaim()) {
            return null;
        }
        if (this.getArea() > 10000) {
            return null;
        }
        int maxEntities = this.getArea() / 50;
        if (maxEntities == 0) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.ClaimTooSmallForEntities, new String[0]);
        }
        int totalEntities = 0;
        ArrayList<Chunk> chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            Entity[] entities = chunk.getEntities();
            int i = 0;
            while (i < entities.length) {
                Entity entity = entities[i];
                if (!(entity instanceof Player) && this.contains(entity.getLocation(), false, false) && remove && ++totalEntities > maxEntities) {
                    entity.remove();
                }
                ++i;
            }
        }
        if (totalEntities >= maxEntities) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.TooManyEntitiesInClaim, new String[0]);
        }
        return null;
    }

    public String allowMoreActiveBlocks() {
        if (this.parent != null) {
            return this.parent.allowMoreActiveBlocks();
        }
        int maxActives = this.getArea() / 100;
        if (maxActives == 0) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.ClaimTooSmallForActiveBlocks, new String[0]);
        }
        int totalActives = 0;
        ArrayList<Chunk> chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            BlockState[] actives = chunk.getTileEntities();
            int i = 0;
            while (i < actives.length) {
                BlockState active = actives[i];
                if (BlockEventHandler.isActiveBlock(active) && this.contains(active.getLocation(), false, false)) {
                    ++totalActives;
                }
                ++i;
            }
        }
        if (totalActives >= maxActives) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.TooManyActiveBlocksInClaim, new String[0]);
        }
        return null;
    }

    boolean greaterThan(Claim otherClaim) {
        Location thisCorner = this.getLesserBoundaryCorner();
        Location otherCorner = otherClaim.getLesserBoundaryCorner();
        if (thisCorner.getBlockX() > otherCorner.getBlockX()) {
            return true;
        }
        if (thisCorner.getBlockX() < otherCorner.getBlockX()) {
            return false;
        }
        if (thisCorner.getBlockZ() > otherCorner.getBlockZ()) {
            return true;
        }
        if (thisCorner.getBlockZ() < otherCorner.getBlockZ()) {
            return false;
        }
        return thisCorner.getWorld().getName().compareTo(otherCorner.getWorld().getName()) < 0;
    }

    long getPlayerInvestmentScore() {
        Location lesserBoundaryCorner = this.getLesserBoundaryCorner();
        ArrayList<Integer> playerBlocks = RestoreNatureProcessingTask.getPlayerBlocks(lesserBoundaryCorner.getWorld().getEnvironment(), lesserBoundaryCorner.getBlock().getBiome());
        double score = 0.0;
        boolean creativeMode = GriefPrevention.instance.creativeRulesApply(lesserBoundaryCorner);
        int x = this.lesserBoundaryCorner.getBlockX();
        while (x <= this.greaterBoundaryCorner.getBlockX()) {
            int z = this.lesserBoundaryCorner.getBlockZ();
            while (z <= this.greaterBoundaryCorner.getBlockZ()) {
                Block block;
                int y = this.lesserBoundaryCorner.getBlockY();
                while (y < GriefPrevention.instance.getSeaLevel(this.lesserBoundaryCorner.getWorld()) - 5) {
                    block = this.lesserBoundaryCorner.getWorld().getBlockAt(x, y, z);
                    if (playerBlocks.contains(block.getTypeId())) {
                        score = block.getType() == Material.CHEST && !creativeMode ? (score += 10.0) : (score += 0.5);
                    }
                    ++y;
                }
                while (y < this.lesserBoundaryCorner.getWorld().getMaxHeight()) {
                    block = this.lesserBoundaryCorner.getWorld().getBlockAt(x, y, z);
                    if (playerBlocks.contains(block.getTypeId())) {
                        score = block.getType() == Material.CHEST && !creativeMode ? (score += 10.0) : (creativeMode && (block.getType() == Material.LAVA || block.getType() == Material.STATIONARY_LAVA) ? (score -= 10.0) : (score += 1.0));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return (long)score;
    }

    public ArrayList<Chunk> getChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        World world = this.getLesserBoundaryCorner().getWorld();
        Chunk lesserChunk = this.getLesserBoundaryCorner().getChunk();
        Chunk greaterChunk = this.getGreaterBoundaryCorner().getChunk();
        int x = lesserChunk.getX();
        while (x <= greaterChunk.getX()) {
            int z = lesserChunk.getZ();
            while (z <= greaterChunk.getZ()) {
                chunks.add(world.getChunkAt(x, z));
                ++z;
            }
            ++x;
        }
        return chunks;
    }

    ArrayList<Long> getChunkHashes() {
        ArrayList<Long> hashes = new ArrayList<Long>();
        int smallX = this.getLesserBoundaryCorner().getBlockX() >> 4;
        int smallZ = this.getLesserBoundaryCorner().getBlockZ() >> 4;
        int largeX = this.getGreaterBoundaryCorner().getBlockX() >> 4;
        int largeZ = this.getGreaterBoundaryCorner().getBlockZ() >> 4;
        int x = smallX;
        while (x <= largeX) {
            int z = smallZ;
            while (z <= largeZ) {
                hashes.add(DataStore.getChunkHash(x, z));
                ++z;
            }
            ++x;
        }
        return hashes;
    }
}

