/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CreateClaimResult;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.PlayerEventHandler;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Dispenser;

public class BlockEventHandler
implements Listener {
    private DataStore dataStore;
    private ArrayList<Material> trashBlocks;
    private Claim lastSpreadClaim = null;

    public BlockEventHandler(DataStore dataStore) {
        this.dataStore = dataStore;
        this.trashBlocks = new ArrayList();
        this.trashBlocks.add(Material.COBBLESTONE);
        this.trashBlocks.add(Material.TORCH);
        this.trashBlocks.add(Material.DIRT);
        this.trashBlocks.add(Material.SAPLING);
        this.trashBlocks.add(Material.GRAVEL);
        this.trashBlocks.add(Material.SAND);
        this.trashBlocks.add(Material.TNT);
        this.trashBlocks.add(Material.WORKBENCH);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent breakEvent) {
        Block block;
        Player player = breakEvent.getPlayer();
        String noBuildReason = GriefPrevention.instance.allowBreak(player, block = breakEvent.getBlock(), block.getLocation());
        if (noBuildReason != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            breakEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignChanged(SignChangeEvent event) {
        if (!GriefPrevention.instance.config_signNotifications) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        StringBuilder lines = new StringBuilder(" placed a sign @ " + GriefPrevention.getfriendlyLocationString(event.getBlock().getLocation()));
        boolean notEmpty = false;
        int i = 0;
        while (i < event.getLines().length) {
            String withoutSpaces = event.getLine(i).replace(" ", "");
            if (!withoutSpaces.isEmpty()) {
                notEmpty = true;
                lines.append("\n  " + event.getLine(i));
            }
            ++i;
        }
        String signMessage = lines.toString();
        if (!player.hasPermission("griefprevention.spam") && GriefPrevention.instance.containsBlockedIP(signMessage)) {
            event.setCancelled(true);
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (notEmpty && playerData.lastMessage != null && !playerData.lastMessage.equals(signMessage)) {
            GriefPrevention.AddLogEntry(String.valueOf(player.getName()) + lines.toString().replace("\n  ", ";"), null);
            PlayerEventHandler.makeSocialLogEntry(player.getName(), signMessage);
            playerData.lastMessage = signMessage;
            if (!player.hasPermission("griefprevention.eavesdropsigns")) {
                Collection players = GriefPrevention.instance.getServer().getOnlinePlayers();
                for (Player otherPlayer : players) {
                    if (!otherPlayer.hasPermission("griefprevention.eavesdropsigns")) continue;
                    otherPlayer.sendMessage(ChatColor.GRAY + player.getName() + signMessage);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlocksPlace(BlockMultiPlaceEvent placeEvent) {
        Player player = placeEvent.getPlayer();
        if (!GriefPrevention.instance.claimsEnabledForWorld(placeEvent.getBlock().getWorld())) {
            return;
        }
        for (BlockState block : placeEvent.getReplacedBlockStates()) {
            String noBuildReason = GriefPrevention.instance.allowBuild(player, block.getLocation(), block.getType());
            if (noBuildReason == null) continue;
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            placeEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent placeEvent) {
        String noPlaceReason;
        Player player = placeEvent.getPlayer();
        Block block = placeEvent.getBlock();
        if (!(block.getType() != Material.FIRE || GriefPrevention.instance.pvpRulesApply(block.getWorld()) && GriefPrevention.instance.config_pvp_allowFireNearPlayers)) {
            List players = block.getWorld().getPlayers();
            int i = 0;
            while (i < players.size()) {
                Player otherPlayer = (Player)players.get(i);
                Location location = otherPlayer.getLocation();
                if (!otherPlayer.equals(player) && location.distanceSquared(block.getLocation()) < 9.0) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerTooCloseForFire2, new String[0]);
                    placeEvent.setCancelled(true);
                    return;
                }
                ++i;
            }
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(placeEvent.getBlock().getWorld())) {
            return;
        }
        String noBuildReason = GriefPrevention.instance.allowBuild(player, block.getLocation(), block.getType());
        if (noBuildReason != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            placeEvent.setCancelled(true);
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(block.getLocation(), true, playerData.lastClaim);
        if (claim != null) {
            playerData.lastClaim = claim;
            if (block.getType() == Material.TNT && !claim.areExplosivesAllowed && playerData.siegeData == null) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoTNTDamageClaims, new String[0]);
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ClaimExplosivesAdvertisement, new String[0]);
            }
            if (block.getY() <= claim.lesserBoundaryCorner.getBlockY() && claim.allowBuild(player, block.getType()) == null) {
                this.dataStore.extendClaim(claim, block.getY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance);
            }
            playerData.warnedAboutBuildingOutsideClaims = false;
        } else if (GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius > -1 && player.hasPermission("griefprevention.createclaims") && block.getType() == Material.CHEST) {
            if (GriefPrevention.instance.config_claims_preventTheft && block.getY() < GriefPrevention.instance.config_claims_maxDepth) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.TooDeepToClaim, new String[0]);
                return;
            }
            int radius = GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius;
            if (playerData.getClaims().size() == 0) {
                if (GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius == 0) {
                    this.dataStore.createClaim(block.getWorld(), block.getX(), block.getX(), block.getY(), block.getY(), block.getZ(), block.getZ(), player.getUniqueId(), null, null, player);
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.ChestClaimConfirmation, new String[0]);
                } else {
                    if (playerData.getRemainingClaimBlocks() < 1) {
                        GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoEnoughBlocksForChestClaim, new String[0]);
                        return;
                    }
                    CreateClaimResult result = null;
                    while (radius >= 0) {
                        int area = (radius * 2 + 1) * (radius * 2 + 1);
                        if (playerData.getRemainingClaimBlocks() >= area) {
                            result = this.dataStore.createClaim(block.getWorld(), block.getX() - radius, block.getX() + radius, block.getY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance, block.getY(), block.getZ() - radius, block.getZ() + radius, player.getUniqueId(), null, null, player);
                            if (result.succeeded) break;
                        }
                        --radius;
                    }
                    if (result != null && result.succeeded) {
                        GriefPrevention.sendMessage(player, TextMode.Success, Messages.AutomaticClaimNotification, new String[0]);
                        Visualization visualization = Visualization.FromClaim(result.claim, block.getY(), VisualizationType.Claim, player.getLocation());
                        Visualization.Apply(player, visualization);
                    }
                }
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
            }
            if (GriefPrevention.instance.config_claims_preventTheft && this.dataStore.getClaimAt(block.getLocation(), false, playerData.lastClaim) == null) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.UnprotectedChestWarning, new String[0]);
            }
        } else if (block.getType() == Material.SAPLING && GriefPrevention.instance.config_blockSkyTrees && GriefPrevention.instance.claimsEnabledForWorld(player.getWorld())) {
            Block earthBlock = placeEvent.getBlockAgainst();
            if (earthBlock.getType() != Material.GRASS && (earthBlock.getRelative(BlockFace.DOWN).getType() == Material.AIR || earthBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN).getType() == Material.AIR)) {
                placeEvent.setCancelled(true);
            }
        } else if (!this.trashBlocks.contains(block.getType()) && GriefPrevention.instance.claimsEnabledForWorld(block.getWorld()) && !playerData.warnedAboutBuildingOutsideClaims && !player.hasPermission("griefprevention.adminclaims") && (playerData.lastClaim == null && playerData.getClaims().size() == 0 || playerData.lastClaim != null && playerData.lastClaim.isNear(player.getLocation(), 15))) {
            Long now = null;
            if (playerData.buildWarningTimestamp == null || (now = Long.valueOf(System.currentTimeMillis())) - playerData.buildWarningTimestamp > 600000L) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.BuildingOutsideClaims, new String[0]);
                playerData.warnedAboutBuildingOutsideClaims = true;
                if (now == null) {
                    now = System.currentTimeMillis();
                }
                playerData.buildWarningTimestamp = now;
                if (playerData.getClaims().size() < 2) {
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
                }
                if (playerData.lastClaim != null) {
                    Visualization visualization = Visualization.FromClaim(playerData.lastClaim, block.getY(), VisualizationType.Claim, player.getLocation());
                    Visualization.Apply(player, visualization);
                }
            }
        }
        if (GriefPrevention.instance.config_blockSurfaceOtherExplosions && block.getType() == Material.TNT && block.getWorld().getEnvironment() != World.Environment.NETHER && block.getY() > GriefPrevention.instance.getSeaLevel(block.getWorld()) - 5 && claim == null && playerData.siegeData == null) {
            GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoTNTDamageAboveSeaLevel, new String[0]);
        }
        if (GriefPrevention.instance.config_pistonsInClaimsOnly && (block.getType() == Material.PISTON_BASE || block.getType() == Material.PISTON_STICKY_BASE) && claim == null) {
            GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoPistonsOutsideClaims, new String[0]);
        }
        if (!player.hasPermission("griefprevention.adminclaims") && GriefPrevention.instance.creativeRulesApply(block.getLocation()) && BlockEventHandler.isActiveBlock(block) && (noPlaceReason = claim.allowMoreActiveBlocks()) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noPlaceReason);
            placeEvent.setCancelled(true);
            return;
        }
    }

    static boolean isActiveBlock(Block block) {
        return BlockEventHandler.isActiveBlock(block.getType());
    }

    static boolean isActiveBlock(BlockState state) {
        return BlockEventHandler.isActiveBlock(state.getType());
    }

    static boolean isActiveBlock(Material type) {
        return type == Material.HOPPER || type == Material.BEACON || type == Material.MOB_SPAWNER;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (event.getDirection() == BlockFace.DOWN) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getBlock().getWorld())) {
            return;
        }
        Block pistonBlock = event.getBlock();
        List blocks = event.getBlocks();
        if (blocks.size() == 0) {
            Block invadedBlock = pistonBlock.getRelative(event.getDirection());
            if (invadedBlock.getType() == Material.AIR) {
                return;
            }
            if (this.dataStore.getClaimAt(pistonBlock.getLocation(), false, null) == null && this.dataStore.getClaimAt(invadedBlock.getLocation(), false, null) != null) {
                event.setCancelled(true);
            }
            return;
        }
        String pistonClaimOwnerName = "_";
        Claim claim = this.dataStore.getClaimAt(event.getBlock().getLocation(), false, null);
        if (claim != null) {
            pistonClaimOwnerName = claim.getOwnerName();
        }
        if (GriefPrevention.instance.config_pistonsInClaimsOnly) {
            if (claim == null) {
                event.setCancelled(true);
                return;
            }
            for (Block pushedBlock : event.getBlocks()) {
                if (!claim.contains(pushedBlock.getLocation(), false, false)) {
                    event.setCancelled(true);
                    return;
                }
                if (claim.contains(pushedBlock.getRelative(event.getDirection()).getLocation(), false, false)) continue;
                event.setCancelled(true);
                return;
            }
        } else {
            Block block;
            Claim cachedClaim = claim;
            int i = 0;
            while (i < blocks.size()) {
                block = (Block)blocks.get(i);
                claim = this.dataStore.getClaimAt(block.getLocation(), false, cachedClaim);
                if (claim != null) {
                    cachedClaim = claim;
                    if (!claim.getOwnerName().equals(pistonClaimOwnerName)) {
                        event.setCancelled(true);
                        pistonBlock.getWorld().createExplosion(pistonBlock.getLocation(), 0.0f);
                        pistonBlock.getWorld().dropItem(pistonBlock.getLocation(), new ItemStack(pistonBlock.getType()));
                        pistonBlock.setType(Material.AIR);
                        return;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < blocks.size()) {
                block = (Block)blocks.get(i);
                Claim originalClaim = this.dataStore.getClaimAt(block.getLocation(), false, cachedClaim);
                String originalOwnerName = "";
                if (originalClaim != null) {
                    cachedClaim = originalClaim;
                    originalOwnerName = originalClaim.getOwnerName();
                }
                Claim newClaim = this.dataStore.getClaimAt(block.getRelative(event.getDirection()).getLocation(), false, cachedClaim);
                String newOwnerName = "";
                if (newClaim != null) {
                    newOwnerName = newClaim.getOwnerName();
                }
                if (!newOwnerName.equals(originalOwnerName) && !newOwnerName.isEmpty()) {
                    event.setCancelled(true);
                    pistonBlock.getWorld().createExplosion(pistonBlock.getLocation(), 0.0f);
                    pistonBlock.getWorld().dropItem(pistonBlock.getLocation(), new ItemStack(pistonBlock.getType()));
                    pistonBlock.setType(Material.AIR);
                    return;
                }
                ++i;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (event.getDirection() == BlockFace.UP) {
            return;
        }
        try {
            if (!GriefPrevention.instance.claimsEnabledForWorld(event.getBlock().getWorld())) {
                return;
            }
            if (GriefPrevention.instance.config_pistonsInClaimsOnly) {
                Claim pistonClaim = this.dataStore.getClaimAt(event.getBlock().getLocation(), false, null);
                if (pistonClaim == null && !event.getBlocks().isEmpty()) {
                    event.setCancelled(true);
                    return;
                }
                for (Block movedBlock : event.getBlocks()) {
                    if (pistonClaim.contains(movedBlock.getLocation(), false, false)) continue;
                    event.setCancelled(true);
                    return;
                }
            } else {
                String pistonOwnerName = "_";
                Block block = event.getBlock();
                Location pistonLocation = block.getLocation();
                Claim pistonClaim = this.dataStore.getClaimAt(pistonLocation, false, null);
                if (pistonClaim != null) {
                    pistonOwnerName = pistonClaim.getOwnerName();
                }
                String movingBlockOwnerName = "_";
                for (Block movedBlock : event.getBlocks()) {
                    Claim movingBlockClaim = this.dataStore.getClaimAt(movedBlock.getLocation(), false, pistonClaim);
                    if (movingBlockClaim != null) {
                        movingBlockOwnerName = movingBlockClaim.getOwnerName();
                    }
                    if (pistonOwnerName.equals(movingBlockOwnerName)) continue;
                    event.setCancelled(true);
                    block.getWorld().createExplosion(block.getLocation(), 0.0f);
                    block.getWorld().dropItem(block.getLocation(), new ItemStack(Material.PISTON_STICKY_BASE));
                    block.setType(Material.AIR);
                    return;
                }
            }
        }
        catch (NoSuchMethodError exception) {
            GriefPrevention.AddLogEntry("Your server is running an outdated version of 1.8 which has a griefing vulnerability.  Update your server (reruns buildtools.jar to get an updated server JAR file) to ensure players can't steal claimed blocks using pistons.");
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockIgnite(BlockIgniteEvent igniteEvent) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(igniteEvent.getBlock().getWorld())) {
            return;
        }
        if (!GriefPrevention.instance.config_fireSpreads && igniteEvent.getCause() != BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL && igniteEvent.getCause() != BlockIgniteEvent.IgniteCause.LIGHTNING) {
            igniteEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockSpread(BlockSpreadEvent spreadEvent) {
        if (spreadEvent.getSource().getType() != Material.FIRE) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(spreadEvent.getBlock().getWorld())) {
            return;
        }
        if (!GriefPrevention.instance.config_fireSpreads) {
            spreadEvent.setCancelled(true);
            Block underBlock = spreadEvent.getSource().getRelative(BlockFace.DOWN);
            if (underBlock.getType() != Material.NETHERRACK) {
                spreadEvent.getSource().setType(Material.AIR);
            }
            return;
        }
        if (this.dataStore.getClaimAt(spreadEvent.getBlock().getLocation(), false, null) != null) {
            spreadEvent.setCancelled(true);
            Block source = spreadEvent.getSource();
            if (source.getRelative(BlockFace.DOWN).getType() != Material.NETHERRACK) {
                source.setType(Material.AIR);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBurn(BlockBurnEvent burnEvent) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(burnEvent.getBlock().getWorld())) {
            return;
        }
        if (!GriefPrevention.instance.config_fireDestroys) {
            burnEvent.setCancelled(true);
            Block block = burnEvent.getBlock();
            Block[] adjacentBlocks = new Block[]{block.getRelative(BlockFace.UP), block.getRelative(BlockFace.DOWN), block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.SOUTH), block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.WEST)};
            int i = 0;
            while (i < adjacentBlocks.length) {
                Block adjacentBlock = adjacentBlocks[i];
                if (adjacentBlock.getType() == Material.FIRE && adjacentBlock.getRelative(BlockFace.DOWN).getType() != Material.NETHERRACK) {
                    adjacentBlock.setType(Material.AIR);
                }
                ++i;
            }
            Block aboveBlock = block.getRelative(BlockFace.UP);
            if (aboveBlock.getType() == Material.FIRE) {
                aboveBlock.setType(Material.AIR);
            }
            return;
        }
        if (this.dataStore.getClaimAt(burnEvent.getBlock().getLocation(), false, null) != null) {
            burnEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockFromTo(BlockFromToEvent spreadEvent) {
        if (spreadEvent.getFace() == BlockFace.DOWN) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(spreadEvent.getBlock().getWorld())) {
            return;
        }
        Block toBlock = spreadEvent.getToBlock();
        Location toLocation = toBlock.getLocation();
        Claim toClaim = this.dataStore.getClaimAt(toLocation, false, this.lastSpreadClaim);
        if (toClaim != null) {
            this.lastSpreadClaim = toClaim;
            if (!(toClaim.contains(spreadEvent.getBlock().getLocation(), false, true) || toClaim.parent != null && toClaim.parent.contains(spreadEvent.getBlock().getLocation(), false, false))) {
                spreadEvent.setCancelled(true);
            }
        } else if (GriefPrevention.instance.creativeRulesApply(toLocation)) {
            spreadEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onForm(BlockFormEvent event) {
        Claim claim;
        Material type;
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (GriefPrevention.instance.creativeRulesApply(location) && ((type = block.getType()) == Material.COBBLESTONE || type == Material.OBSIDIAN || type == Material.STATIONARY_LAVA || type == Material.STATIONARY_WATER) && (claim = GriefPrevention.instance.dataStore.getClaimAt(location, false, null)) == null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDispense(BlockDispenseEvent dispenseEvent) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(dispenseEvent.getBlock().getWorld())) {
            return;
        }
        Block fromBlock = dispenseEvent.getBlock();
        Dispenser dispenser = new Dispenser(Material.DISPENSER, fromBlock.getData());
        Block toBlock = fromBlock.getRelative(dispenser.getFacing());
        Claim fromClaim = this.dataStore.getClaimAt(fromBlock.getLocation(), false, null);
        Claim toClaim = this.dataStore.getClaimAt(toBlock.getLocation(), false, fromClaim);
        Material materialDispensed = dispenseEvent.getItem().getType();
        if ((materialDispensed == Material.WATER_BUCKET || materialDispensed == Material.LAVA_BUCKET) && GriefPrevention.instance.creativeRulesApply(dispenseEvent.getBlock().getLocation()) && toClaim == null) {
            dispenseEvent.setCancelled(true);
            return;
        }
        if (fromClaim == null && toClaim == null) {
            return;
        }
        if (fromClaim == toClaim) {
            return;
        }
        dispenseEvent.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onTreeGrow(StructureGrowEvent growEvent) {
        if (!GriefPrevention.instance.config_limitTreeGrowth) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(growEvent.getWorld())) {
            return;
        }
        Location rootLocation = growEvent.getLocation();
        Claim rootClaim = this.dataStore.getClaimAt(rootLocation, false, null);
        String rootOwnerName = null;
        if (rootClaim != null) {
            if (rootClaim.parent != null) {
                rootClaim = rootClaim.parent;
            }
            if (rootClaim.isAdminClaim()) {
                return;
            }
            rootOwnerName = rootClaim.getOwnerName();
        }
        int i = 0;
        while (i < growEvent.getBlocks().size()) {
            BlockState block = (BlockState)growEvent.getBlocks().get(i);
            Claim blockClaim = this.dataStore.getClaimAt(block.getLocation(), false, rootClaim);
            if (!(blockClaim == null || rootOwnerName != null && rootOwnerName.equals(blockClaim.getOwnerName()))) {
                growEvent.getBlocks().remove(i--);
            }
            ++i;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        Item item;
        List data;
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof HopperMinecart || holder instanceof Hopper) && (data = (item = event.getItem()).getMetadata("GP_ITEMOWNER")) != null && data.size() > 0) {
            event.setCancelled(true);
        }
    }
}

