/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.RestoreNatureProcessingTask;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.plugin.Plugin;

class AutoExtendClaimTask
implements Runnable {
    private Claim claim;
    private ArrayList<ChunkSnapshot> chunks;
    private World.Environment worldType;

    public AutoExtendClaimTask(Claim claim, ArrayList<ChunkSnapshot> chunks, World.Environment worldType) {
        this.claim = claim;
        this.chunks = chunks;
        this.worldType = worldType;
    }

    @Override
    public void run() {
        int newY = this.getLowestBuiltY();
        if (newY < this.claim.getLesserBoundaryCorner().getBlockY()) {
            Bukkit.getScheduler().runTask((Plugin)GriefPrevention.instance, (Runnable)new ExecuteExtendClaimTask(this.claim, newY));
        }
    }

    private int getLowestBuiltY() {
        int y = this.claim.getLesserBoundaryCorner().getBlockY();
        if (this.yTooSmall(y)) {
            return y;
        }
        for (ChunkSnapshot chunk : this.chunks) {
            Biome biome = chunk.getBiome(0, 0);
            ArrayList<Integer> playerBlockIDs = RestoreNatureProcessingTask.getPlayerBlocks(this.worldType, biome);
            boolean ychanged = true;
            while (!this.yTooSmall(y) && ychanged) {
                ychanged = false;
                int x = 0;
                while (x < 16) {
                    int z = 0;
                    while (z < 16) {
                        int blockType = chunk.getBlockTypeId(x, y, z);
                        while (!this.yTooSmall(y) && playerBlockIDs.contains(blockType)) {
                            ychanged = true;
                            blockType = chunk.getBlockTypeId(x, --y, z);
                        }
                        if (this.yTooSmall(y)) {
                            return y;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            if (!this.yTooSmall(y)) continue;
            return y;
        }
        return y;
    }

    private boolean yTooSmall(int y) {
        return y == 0 || y <= GriefPrevention.instance.config_claims_maxDepth;
    }

    private class ExecuteExtendClaimTask
    implements Runnable {
        private Claim claim;
        private int newY;

        public ExecuteExtendClaimTask(Claim claim, int newY) {
            this.claim = claim;
            this.newY = newY;
        }

        @Override
        public void run() {
            GriefPrevention.instance.dataStore.extendClaim(this.claim, this.newY);
        }
    }
}

