/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.UUIDFetcher;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class DatabaseDataStore
extends DataStore {
    private Connection databaseConnection = null;
    private String databaseUrl;
    private String userName;
    private String password;

    DatabaseDataStore(String url, String userName, String password) throws Exception {
        this.databaseUrl = url;
        this.userName = userName;
        this.password = password;
        this.initialize();
    }

    @Override
    void initialize() throws Exception {
        ResultSet results;
        Statement statement;
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("ERROR: Unable to load Java's mySQL database driver.  Check to make sure you've installed it properly.");
            throw e;
        }
        try {
            this.refreshDataConnection();
        }
        catch (Exception e2) {
            GriefPrevention.AddLogEntry("ERROR: Unable to connect to database.  Check your config file settings.");
            throw e2;
        }
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS griefprevention_nextclaimid (nextid INT(15));");
            statement.execute("CREATE TABLE IF NOT EXISTS griefprevention_claimdata (id INT(15), owner VARCHAR(50), lessercorner VARCHAR(100), greatercorner VARCHAR(100), builders TEXT, containers TEXT, accessors TEXT, managers TEXT, parentid INT(15));");
            statement.execute("CREATE TABLE IF NOT EXISTS griefprevention_playerdata (name VARCHAR(50), lastlogin DATETIME, accruedblocks INT(15), bonusblocks INT(15));");
            statement.execute("CREATE TABLE IF NOT EXISTS griefprevention_schemaversion (version INT(15));");
            statement.execute("ALTER TABLE griefprevention_claimdata MODIFY builders TEXT;");
            statement.execute("ALTER TABLE griefprevention_claimdata MODIFY containers TEXT;");
            statement.execute("ALTER TABLE griefprevention_claimdata MODIFY accessors TEXT;");
            statement.execute("ALTER TABLE griefprevention_claimdata MODIFY managers TEXT;");
            results = statement.executeQuery("SELECT * FROM griefprevention_nextclaimid;");
            if (!results.next()) {
                this.setSchemaVersion(2);
            }
        }
        catch (Exception e3) {
            GriefPrevention.AddLogEntry("ERROR: Unable to create the necessary database table.  Details:");
            GriefPrevention.AddLogEntry(e3.getMessage());
            e3.printStackTrace();
            throw e3;
        }
        statement = this.databaseConnection.createStatement();
        results = statement.executeQuery("SELECT * FROM griefprevention_playerdata;");
        while (results.next()) {
            String groupName;
            String name = results.getString("name");
            if (!name.startsWith("$") || (groupName = name.substring(1)) == null || groupName.isEmpty()) continue;
            int groupBonusBlocks = results.getInt("bonusblocks");
            this.permissionToBonusBlocksMap.put(groupName, groupBonusBlocks);
        }
        results = statement.executeQuery("SELECT * FROM griefprevention_nextclaimid;");
        if (!results.next()) {
            statement.execute("INSERT INTO griefprevention_nextclaimid VALUES(0);");
            this.nextClaimID = 0L;
        } else {
            this.nextClaimID = results.getLong("nextid");
        }
        if (this.getSchemaVersion() == 0) {
            try {
                this.refreshDataConnection();
                statement = this.databaseConnection.createStatement();
                results = statement.executeQuery("SELECT * FROM griefprevention_playerdata;");
                HashMap<String, Object> changes = new HashMap<String, Object>();
                ArrayList<String> namesToConvert = new ArrayList<String>();
                while (results.next()) {
                    String playerName = results.getString("name");
                    namesToConvert.add(playerName);
                }
                try {
                    UUIDFetcher fetcher = new UUIDFetcher(namesToConvert);
                    fetcher.call();
                }
                catch (Exception e) {
                    GriefPrevention.AddLogEntry("Failed to resolve a batch of names to UUIDs.  Details:" + e.getMessage());
                    e.printStackTrace();
                }
                results.beforeFirst();
                while (results.next()) {
                    String playerName = results.getString("name");
                    try {
                        UUID playerID = UUIDFetcher.getUUIDOf(playerName);
                        if (playerID == null) continue;
                        changes.put(playerName, playerID);
                    }
                    catch (Exception playerID) {
                        // empty catch block
                    }
                }
                this.refreshDataConnection();
                for (String name : changes.keySet()) {
                    try {
                        statement = this.databaseConnection.createStatement();
                        statement.execute("UPDATE griefprevention_playerdata SET name = '" + ((UUID)changes.get(name)).toString() + "' WHERE name = '" + name + "';");
                    }
                    catch (SQLException e) {
                        GriefPrevention.AddLogEntry("Unable to convert player data for " + name + ".  Skipping.");
                        GriefPrevention.AddLogEntry(e.getMessage());
                    }
                }
            }
            catch (SQLException e) {
                GriefPrevention.AddLogEntry("Unable to convert player data.  Details:");
                GriefPrevention.AddLogEntry(e.getMessage());
                e.printStackTrace();
            }
        }
        results = statement.executeQuery("SELECT * FROM griefprevention_claimdata;");
        ArrayList<Claim> claimsToRemove = new ArrayList<Claim>();
        ArrayList<Claim> subdivisionsToLoad = new ArrayList<Claim>();
        List validWorlds = Bukkit.getServer().getWorlds();
        Long claimID = null;
        while (results.next()) {
            try {
                boolean removeClaim = false;
                long parentId = results.getLong("parentid");
                claimID = results.getLong("id");
                Location lesserBoundaryCorner = null;
                Location greaterBoundaryCorner = null;
                String lesserCornerString = "(location not available)";
                try {
                    lesserCornerString = results.getString("lessercorner");
                    lesserBoundaryCorner = this.locationFromString(lesserCornerString, validWorlds);
                    String greaterCornerString = results.getString("greatercorner");
                    greaterBoundaryCorner = this.locationFromString(greaterCornerString, validWorlds);
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("World not found")) {
                        GriefPrevention.AddLogEntry("Failed to load a claim (ID:" + claimID.toString() + ") because its world isn't loaded (yet?).  Please delete the claim or contact the GriefPrevention developer with information about which plugin(s) you're using to load or create worlds.  " + lesserCornerString);
                        continue;
                    }
                    throw e;
                }
                String ownerName = results.getString("owner");
                UUID ownerID = null;
                if (ownerName.isEmpty() || ownerName.startsWith("--")) {
                    ownerID = null;
                } else if (this.getSchemaVersion() < 1) {
                    try {
                        ownerID = UUIDFetcher.getUUIDOf(ownerName);
                    }
                    catch (Exception ex) {
                        GriefPrevention.AddLogEntry("This owner name did not convert to a UUID: " + ownerName + ".");
                        GriefPrevention.AddLogEntry("  Converted land claim to administrative @ " + lesserBoundaryCorner.toString());
                    }
                } else {
                    try {
                        ownerID = UUID.fromString(ownerName);
                    }
                    catch (Exception ex) {
                        GriefPrevention.AddLogEntry("This owner entry is not a UUID: " + ownerName + ".");
                        GriefPrevention.AddLogEntry("  Converted land claim to administrative @ " + lesserBoundaryCorner.toString());
                    }
                }
                String buildersString = results.getString("builders");
                List<String> builderNames = Arrays.asList(buildersString.split(";"));
                builderNames = this.convertNameListToUUIDList(builderNames);
                String containersString = results.getString("containers");
                List<String> containerNames = Arrays.asList(containersString.split(";"));
                containerNames = this.convertNameListToUUIDList(containerNames);
                String accessorsString = results.getString("accessors");
                List<String> accessorNames = Arrays.asList(accessorsString.split(";"));
                accessorNames = this.convertNameListToUUIDList(accessorNames);
                String managersString = results.getString("managers");
                List<String> managerNames = Arrays.asList(managersString.split(";"));
                managerNames = this.convertNameListToUUIDList(managerNames);
                Claim claim = new Claim(lesserBoundaryCorner, greaterBoundaryCorner, ownerID, builderNames, containerNames, accessorNames, managerNames, claimID);
                if (removeClaim) {
                    claimsToRemove.add(claim);
                    continue;
                }
                if (parentId == -1L) {
                    this.addClaim(claim, false);
                    continue;
                }
                subdivisionsToLoad.add(claim);
            }
            catch (SQLException e) {
                GriefPrevention.AddLogEntry("Unable to load a claim.  Details: " + e.getMessage() + " ... " + results.toString());
                e.printStackTrace();
            }
        }
        for (Claim childClaim : subdivisionsToLoad) {
            Claim topLevelClaim = this.getClaimAt(childClaim.getLesserBoundaryCorner(), true, null);
            if (topLevelClaim == null) {
                claimsToRemove.add(childClaim);
                GriefPrevention.AddLogEntry("Removing orphaned claim subdivision: " + childClaim.getLesserBoundaryCorner().toString());
                continue;
            }
            childClaim.parent = topLevelClaim;
            topLevelClaim.children.add(childClaim);
            childClaim.inDataStore = true;
        }
        int i = 0;
        while (i < claimsToRemove.size()) {
            this.deleteClaimFromSecondaryStorage((Claim)claimsToRemove.get(i));
            ++i;
        }
        if (this.getSchemaVersion() <= 2) {
            this.refreshDataConnection();
            statement = this.databaseConnection.createStatement();
            statement.execute("DELETE FROM griefprevention_claimdata WHERE id='-1';");
        }
        super.initialize();
    }

    @Override
    synchronized void writeClaimToStorage(Claim claim) {
        try {
            this.refreshDataConnection();
            this.deleteClaimFromSecondaryStorage(claim);
            this.writeClaimData(claim);
        }
        catch (SQLException e) {
            GriefPrevention.AddLogEntry("Unable to save data for claim at " + this.locationToString(claim.lesserBoundaryCorner) + ".  Details:");
            GriefPrevention.AddLogEntry(e.getMessage());
        }
    }

    private synchronized void writeClaimData(Claim claim) throws SQLException {
        String lesserCornerString = this.locationToString(claim.getLesserBoundaryCorner());
        String greaterCornerString = this.locationToString(claim.getGreaterBoundaryCorner());
        String owner = "";
        if (claim.ownerID != null) {
            owner = claim.ownerID.toString();
        }
        ArrayList<String> builders = new ArrayList<String>();
        ArrayList<String> containers = new ArrayList<String>();
        ArrayList<String> accessors = new ArrayList<String>();
        ArrayList<String> managers = new ArrayList<String>();
        claim.getPermissions(builders, containers, accessors, managers);
        String buildersString = "";
        int i = 0;
        while (i < builders.size()) {
            buildersString = String.valueOf(buildersString) + builders.get(i) + ";";
            ++i;
        }
        String containersString = "";
        int i2 = 0;
        while (i2 < containers.size()) {
            containersString = String.valueOf(containersString) + containers.get(i2) + ";";
            ++i2;
        }
        String accessorsString = "";
        int i3 = 0;
        while (i3 < accessors.size()) {
            accessorsString = String.valueOf(accessorsString) + accessors.get(i3) + ";";
            ++i3;
        }
        String managersString = "";
        int i4 = 0;
        while (i4 < managers.size()) {
            managersString = String.valueOf(managersString) + managers.get(i4) + ";";
            ++i4;
        }
        long parentId = claim.parent == null ? -1L : claim.parent.id;
        try {
            this.refreshDataConnection();
            Statement statement = this.databaseConnection.createStatement();
            statement.execute("INSERT INTO griefprevention_claimdata (id, owner, lessercorner, greatercorner, builders, containers, accessors, managers, parentid) VALUES(" + claim.id + ", '" + owner + "', '" + lesserCornerString + "', '" + greaterCornerString + "', '" + buildersString + "', '" + containersString + "', '" + accessorsString + "', '" + managersString + "', " + parentId + ");");
        }
        catch (SQLException e) {
            GriefPrevention.AddLogEntry("Unable to save data for claim at " + this.locationToString(claim.lesserBoundaryCorner) + ".  Details:");
            GriefPrevention.AddLogEntry(e.getMessage());
        }
    }

    @Override
    synchronized void deleteClaimFromSecondaryStorage(Claim claim) {
        try {
            this.refreshDataConnection();
            Statement statement = this.databaseConnection.createStatement();
            statement.execute("DELETE FROM griefprevention_claimdata WHERE id='" + claim.id + "';");
        }
        catch (SQLException e) {
            GriefPrevention.AddLogEntry("Unable to delete data for claim " + claim.id + ".  Details:");
            GriefPrevention.AddLogEntry(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    synchronized PlayerData getPlayerDataFromStorage(UUID playerID) {
        PlayerData playerData = new PlayerData();
        playerData.playerID = playerID;
        try {
            this.refreshDataConnection();
            Statement statement = this.databaseConnection.createStatement();
            ResultSet results = statement.executeQuery("SELECT * FROM griefprevention_playerdata WHERE name='" + playerID.toString() + "';");
            if (results.next()) {
                playerData.setLastLogin(results.getTimestamp("lastlogin"));
                playerData.setAccruedClaimBlocks(results.getInt("accruedblocks"));
                playerData.setBonusClaimBlocks(results.getInt("bonusblocks"));
            }
        }
        catch (SQLException e) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            GriefPrevention.AddLogEntry(playerID + " " + errors.toString(), CustomLogEntryTypes.Exception);
        }
        return playerData;
    }

    @Override
    public void overrideSavePlayerData(UUID playerID, PlayerData playerData) {
        if (playerID == null) {
            return;
        }
        this.savePlayerData(playerID.toString(), playerData);
    }

    private void savePlayerData(String playerID, PlayerData playerData) {
        try {
            this.refreshDataConnection();
            SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sqlFormat.format(playerData.getLastLogin());
            Statement statement = this.databaseConnection.createStatement();
            statement.execute("DELETE FROM griefprevention_playerdata WHERE name='" + playerID.toString() + "';");
            statement = this.databaseConnection.createStatement();
            statement.execute("INSERT INTO griefprevention_playerdata (name, lastlogin, accruedblocks, bonusblocks) VALUES ('" + playerID.toString() + "', '" + dateString + "', " + playerData.getAccruedClaimBlocks() + ", " + playerData.getBonusClaimBlocks() + ");");
        }
        catch (SQLException e) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            GriefPrevention.AddLogEntry(String.valueOf(playerID) + " " + errors.toString(), CustomLogEntryTypes.Exception);
        }
    }

    @Override
    synchronized void incrementNextClaimID() {
        this.setNextClaimID(this.nextClaimID + 1L);
    }

    synchronized void setNextClaimID(long nextID) {
        this.nextClaimID = nextID;
        try {
            this.refreshDataConnection();
            Statement statement = this.databaseConnection.createStatement();
            statement.execute("DELETE FROM griefprevention_nextclaimid;");
            statement.execute("INSERT INTO griefprevention_nextclaimid VALUES (" + nextID + ");");
        }
        catch (SQLException e) {
            GriefPrevention.AddLogEntry("Unable to set next claim ID to " + nextID + ".  Details:");
            GriefPrevention.AddLogEntry(e.getMessage());
        }
    }

    @Override
    synchronized void saveGroupBonusBlocks(String groupName, int currentValue) {
        try {
            this.refreshDataConnection();
            SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sqlFormat.format(new Date());
            Statement statement = this.databaseConnection.createStatement();
            statement.execute("DELETE FROM griefprevention_playerdata WHERE name='$" + groupName + "';");
            statement = this.databaseConnection.createStatement();
            statement.execute("INSERT INTO griefprevention_playerdata (name, lastlogin, accruedblocks, bonusblocks) VALUES ('$" + groupName + "', '" + dateString + "', " + "0" + ", " + String.valueOf(currentValue) + ");");
        }
        catch (SQLException e) {
            GriefPrevention.AddLogEntry("Unable to save data for group " + groupName + ".  Details:");
            GriefPrevention.AddLogEntry(e.getMessage());
        }
    }

    @Override
    synchronized void close() {
        if (this.databaseConnection != null) {
            try {
                if (!this.databaseConnection.isClosed()) {
                    this.databaseConnection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.databaseConnection = null;
    }

    private synchronized void refreshDataConnection() throws SQLException {
        if (this.databaseConnection == null || !this.databaseConnection.isValid(3)) {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
            }
            Properties connectionProps = new Properties();
            connectionProps.put("user", this.userName);
            connectionProps.put("password", this.password);
            connectionProps.put("autoReconnect", "true");
            connectionProps.put("maxReconnects", String.valueOf(Integer.MAX_VALUE));
            this.databaseConnection = DriverManager.getConnection(this.databaseUrl, connectionProps);
        }
    }

    @Override
    protected int getSchemaVersionFromStorage() {
        ResultSet results;
        block3: {
            try {
                this.refreshDataConnection();
                Statement statement = this.databaseConnection.createStatement();
                results = statement.executeQuery("SELECT * FROM griefprevention_schemaversion;");
                if (results.next()) break block3;
                this.setSchemaVersion(0);
                return 0;
            }
            catch (SQLException e) {
                GriefPrevention.AddLogEntry("Unable to retrieve schema version from database.  Details:");
                GriefPrevention.AddLogEntry(e.getMessage());
                e.printStackTrace();
                return 0;
            }
        }
        return results.getInt("version");
    }

    @Override
    protected void updateSchemaVersionInStorage(int versionToSet) {
        try {
            this.refreshDataConnection();
            Statement statement = this.databaseConnection.createStatement();
            statement.execute("DELETE FROM griefprevention_schemaversion;");
            statement.execute("INSERT INTO griefprevention_schemaversion VALUES (" + versionToSet + ");");
        }
        catch (SQLException e) {
            GriefPrevention.AddLogEntry("Unable to set next schema version to " + versionToSet + ".  Details:");
            GriefPrevention.AddLogEntry(e.getMessage());
        }
    }
}

