/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.ShovelMode;
import me.ryanhamshire.GriefPrevention.SiegeData;
import me.ryanhamshire.GriefPrevention.Visualization;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlayerData {
    public UUID playerID;
    private Vector<Claim> claims = null;
    private Integer accruedClaimBlocks = null;
    private int newlyAccruedClaimBlocks = 0;
    public Location lastAfkCheckLocation = null;
    private Integer bonusClaimBlocks = null;
    public ShovelMode shovelMode = ShovelMode.Basic;
    int fillRadius = 0;
    public Location lastShovelLocation = null;
    public Claim claimResizing = null;
    public Claim claimSubdividing = null;
    public boolean pendingTrapped = false;
    boolean warnedAboutBuildingOutsideClaims = false;
    long lastSiegeEndTimeStamp = 0L;
    boolean wasKicked = false;
    private Date lastLogin = null;
    public String lastMessage = "";
    public Date lastMessageTimestamp = new Date();
    public int spamCount = 0;
    public boolean spamWarned = false;
    public Visualization currentVisualization = null;
    public boolean pvpImmune = false;
    public long lastSpawn = 0L;
    public boolean ignoreClaims = false;
    public Claim lastClaim = null;
    public SiegeData siegeData = null;
    public long lastPvpTimestamp = 0L;
    public String lastPvpPlayer = "";
    public boolean warnedAboutMajorDeletion = false;
    public InetAddress ipAddress;
    boolean receivedDropUnlockAdvertisement = false;
    boolean dropsAreUnlocked = false;
    String messageOnRespawn = null;
    OfflinePlayer petGiveawayRecipient = null;
    Long buildWarningTimestamp = null;
    Location noChatLocation = null;
    public ConcurrentHashMap<UUID, Boolean> ignoredPlayers = new ConcurrentHashMap();
    public boolean ignoreListChanged = false;
    boolean profanityWarned = false;
    boolean ipLimited = false;

    public boolean inPvpCombat() {
        if (this.lastPvpTimestamp == 0L) {
            return false;
        }
        long now = Calendar.getInstance().getTimeInMillis();
        long elapsed = now - this.lastPvpTimestamp;
        if (elapsed > (long)(GriefPrevention.instance.config_pvp_combatTimeoutSeconds * 1000)) {
            this.lastPvpTimestamp = 0L;
            return false;
        }
        return true;
    }

    public int getRemainingClaimBlocks() {
        int remainingBlocks = this.getAccruedClaimBlocks() + this.getBonusClaimBlocks();
        int i = 0;
        while (i < this.getClaims().size()) {
            Claim claim = this.getClaims().get(i);
            remainingBlocks -= claim.getArea();
            ++i;
        }
        return remainingBlocks += GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID);
    }

    public int getAccruedClaimBlocks() {
        if (this.accruedClaimBlocks == null) {
            this.loadDataFromSecondaryStorage();
        }
        if (this.newlyAccruedClaimBlocks > 0) {
            int accruedLimit = this.getAccruedClaimBlocksLimit();
            if (this.accruedClaimBlocks < accruedLimit) {
                int newTotal = this.accruedClaimBlocks + this.newlyAccruedClaimBlocks;
                this.accruedClaimBlocks = Math.min(newTotal, accruedLimit);
            }
            this.newlyAccruedClaimBlocks = 0;
            return this.accruedClaimBlocks;
        }
        return this.accruedClaimBlocks;
    }

    public void setAccruedClaimBlocks(Integer accruedClaimBlocks) {
        this.accruedClaimBlocks = accruedClaimBlocks;
        this.newlyAccruedClaimBlocks = 0;
    }

    public int getBonusClaimBlocks() {
        if (this.bonusClaimBlocks == null) {
            this.loadDataFromSecondaryStorage();
        }
        return this.bonusClaimBlocks;
    }

    public void setBonusClaimBlocks(Integer bonusClaimBlocks) {
        this.bonusClaimBlocks = bonusClaimBlocks;
    }

    public Date getLastLogin() {
        if (this.lastLogin == null) {
            this.loadDataFromSecondaryStorage();
        }
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    private void loadDataFromSecondaryStorage() {
        PlayerData storageData = GriefPrevention.instance.dataStore.getPlayerDataFromStorage(this.playerID);
        if (this.lastLogin == null) {
            if (storageData.lastLogin != null) {
                this.lastLogin = storageData.lastLogin;
            } else {
                Calendar fiveMinutesBack = Calendar.getInstance();
                fiveMinutesBack.add(12, -5);
                this.lastLogin = fiveMinutesBack.getTime();
            }
        }
        if (this.accruedClaimBlocks == null) {
            if (storageData.accruedClaimBlocks != null) {
                this.accruedClaimBlocks = storageData.accruedClaimBlocks;
                if (this.accruedClaimBlocks < GriefPrevention.instance.config_claims_initialBlocks) {
                    this.accruedClaimBlocks = GriefPrevention.instance.config_claims_initialBlocks;
                }
            } else {
                this.accruedClaimBlocks = GriefPrevention.instance.config_claims_initialBlocks;
            }
        }
        if (this.bonusClaimBlocks == null) {
            this.bonusClaimBlocks = storageData.bonusClaimBlocks != null ? storageData.bonusClaimBlocks : Integer.valueOf(0);
        }
    }

    public Vector<Claim> getClaims() {
        if (this.claims == null) {
            this.claims = new Vector();
            DataStore dataStore = GriefPrevention.instance.dataStore;
            int totalClaimsArea = 0;
            int i = 0;
            while (i < dataStore.claims.size()) {
                Claim claim = dataStore.claims.get(i);
                if (!claim.inDataStore) {
                    dataStore.claims.remove(i--);
                } else if (this.playerID.equals(claim.ownerID)) {
                    this.claims.add(claim);
                    totalClaimsArea += claim.getArea();
                }
                ++i;
            }
            this.loadDataFromSecondaryStorage();
            int totalBlocks = this.accruedClaimBlocks + this.getBonusClaimBlocks() + GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID);
            if (totalBlocks < totalClaimsArea) {
                OfflinePlayer player = GriefPrevention.instance.getServer().getOfflinePlayer(this.playerID);
                GriefPrevention.AddLogEntry(String.valueOf(player.getName()) + " has more claimed land than blocks available.  Adding blocks to fix.", CustomLogEntryTypes.Debug, true);
                GriefPrevention.AddLogEntry("Total blocks: " + totalBlocks + " Total claimed area: " + totalClaimsArea, CustomLogEntryTypes.Debug, true);
                for (Claim claim : this.claims) {
                    if (!claim.inDataStore) continue;
                    GriefPrevention.AddLogEntry(String.valueOf(GriefPrevention.getfriendlyLocationString(claim.getLesserBoundaryCorner())) + " // " + GriefPrevention.getfriendlyLocationString(claim.getGreaterBoundaryCorner()) + " = " + claim.getArea(), CustomLogEntryTypes.Debug, true);
                }
                this.accruedClaimBlocks = totalClaimsArea;
                int accruedLimit = this.getAccruedClaimBlocksLimit();
                this.accruedClaimBlocks = Math.min(accruedLimit, this.accruedClaimBlocks);
                totalBlocks = this.accruedClaimBlocks + this.getBonusClaimBlocks() + GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID);
                if (totalBlocks < totalClaimsArea) {
                    this.bonusClaimBlocks = this.bonusClaimBlocks + (totalClaimsArea - totalBlocks);
                }
            }
        }
        int i = 0;
        while (i < this.claims.size()) {
            if (!this.claims.get((int)i).inDataStore) {
                this.claims.remove(i--);
            }
            ++i;
        }
        return this.claims;
    }

    private int getAccruedClaimBlocksLimit() {
        Player player = Bukkit.getServer().getPlayer(this.playerID);
        if (player == null) {
            return Integer.MAX_VALUE;
        }
        if (player.hasPermission("griefprevention.mostaccrued")) {
            return GriefPrevention.instance.config_claims_maxAccruedBlocks_most;
        }
        if (player.hasPermission("griefprevention.moreaccrued")) {
            return GriefPrevention.instance.config_claims_maxAccruedBlocks_more;
        }
        return GriefPrevention.instance.config_claims_maxAccruedBlocks_default;
    }

    public void accrueBlocks(int howMany) {
        this.newlyAccruedClaimBlocks += howMany;
    }
}

