/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResidenceBank {
    int storedMoney = 0;
    ClaimedResidence res;

    public ResidenceBank(ClaimedResidence parent) {
        this.res = parent;
    }

    public int getStoredMoney() {
        return this.storedMoney;
    }

    public void setStoredMoney(int amount) {
        this.storedMoney = amount;
    }

    public void add(int amount) {
        this.storedMoney += amount;
    }

    public boolean hasEnough(int amount) {
        return this.storedMoney >= amount;
    }

    public void subtract(int amount) {
        this.storedMoney -= amount;
        if (this.storedMoney < 0) {
            this.storedMoney = 0;
        }
    }

    public void withdraw(CommandSender sender, int amount, boolean resadmin2) {
        if (!Residence.getInstance().getConfigManager().enableEconomy()) {
            Residence.getInstance().msg(sender, lm.Economy_MarketDisabled, new Object[0]);
        }
        if (!resadmin2 && !this.res.getPermissions().playerHas(sender.getName(), Flags.bank, FlagPermissions.FlagCombo.OnlyTrue)) {
            Residence.getInstance().msg(sender, lm.Bank_NoAccess, new Object[0]);
            return;
        }
        if (!this.hasEnough(amount)) {
            Residence.getInstance().msg(sender, lm.Bank_NoMoney, new Object[0]);
            return;
        }
        if (sender instanceof Player && Residence.getInstance().getEconomyManager().add(sender.getName(), amount) || !(sender instanceof Player)) {
            this.subtract(amount);
            Residence.getInstance().msg(sender, lm.Bank_Withdraw, String.format("%d", amount));
        }
    }

    public void deposit(CommandSender sender, int amount, boolean resadmin2) {
        if (!Residence.getInstance().getConfigManager().enableEconomy()) {
            Residence.getInstance().msg(sender, lm.Economy_MarketDisabled, new Object[0]);
        }
        if (!resadmin2 && !this.res.getPermissions().playerHas(sender.getName(), Flags.bank, FlagPermissions.FlagCombo.OnlyTrue)) {
            Residence.getInstance().msg(sender, lm.Bank_NoAccess, new Object[0]);
            return;
        }
        if (sender instanceof Player && !Residence.getInstance().getEconomyManager().canAfford(sender.getName(), amount)) {
            Residence.getInstance().msg(sender, lm.Economy_NotEnoughMoney, new Object[0]);
            return;
        }
        if (sender instanceof Player && Residence.getInstance().getEconomyManager().subtract(sender.getName(), amount) || !(sender instanceof Player)) {
            this.add(amount);
            Residence.getInstance().msg(sender, lm.Bank_Deposit, String.format("%d", amount));
        }
    }
}

