/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceCommandEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidenceCommandListener
extends Residence {
    private static List<String> AdminCommands = new ArrayList<String>();

    public static List<String> getAdminCommands() {
        if (AdminCommands.size() == 0) {
            AdminCommands = Residence.getInstance().getCommandFiller().getCommands(false);
        }
        return AdminCommands;
    }

    public boolean onCommand(CommandSender sender, Command command2, String label, String[] args) {
        block40: {
            boolean respond;
            String cmd2;
            ResidenceCommandEvent cevent = new ResidenceCommandEvent(command2.getName(), args, sender);
            this.getServ().getPluginManager().callEvent((Event)cevent);
            if (cevent.isCancelled()) {
                return true;
            }
            if (sender instanceof Player && !this.getPermissionManager().isResidenceAdmin(sender) && this.isDisabledWorldCommand(((Player)sender).getWorld())) {
                this.msg(sender, lm.General_DisabledWorld, new Object[0]);
                return true;
            }
            if (command2.getName().equals("resreload") && args.length == 0) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (this.getPermissionManager().isResidenceAdmin((CommandSender)player) && player.hasPermission("residence.topadmin")) {
                        this.reloadPlugin();
                        sender.sendMessage(ChatColor.GREEN + "[Residence] Reloaded config.");
                        System.out.println("[Residence] Reloaded by " + player.getName() + ".");
                    } else {
                        this.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    }
                } else {
                    this.reloadPlugin();
                    System.out.println("[Residence] Reloaded by console.");
                }
                return true;
            }
            if (command2.getName().equals("resload")) {
                if (!(sender instanceof Player) || sender instanceof Player && this.getPermissionManager().isResidenceAdmin(sender) && ((Player)sender).hasPermission("residence.topadmin")) {
                    try {
                        this.loadYml();
                        sender.sendMessage(ChatColor.GREEN + "[Residence] Reloaded save file...");
                    }
                    catch (Exception ex) {
                        sender.sendMessage(ChatColor.RED + "[Residence] Unable to reload the save file, exception occured!");
                        sender.sendMessage(ChatColor.RED + ex.getMessage());
                        Logger.getLogger(((Object)((Object)ResidenceCommandListener.getInstance())).getClass().getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    this.msg(sender, lm.General_NoPermission, new Object[0]);
                }
                return true;
            }
            if (command2.getName().equals("rc")) {
                cmd cmdClass = ResidenceCommandListener.getCmdClass(new String[]{"rc"});
                if (cmdClass == null) {
                    this.sendUsage(sender, command2.getName());
                    return true;
                }
                boolean respond2 = cmdClass.perform(ResidenceCommandListener.getInstance(), args, false, command2, sender);
                if (!respond2) {
                    this.sendUsage(sender, command2.getName());
                }
                return true;
            }
            if (!command2.getName().equals("res") && !command2.getName().equals("residence") && !command2.getName().equals("resadmin")) break block40;
            boolean resadmin2 = false;
            if (sender instanceof Player) {
                if (command2.getName().equals("resadmin") && this.getPermissionManager().isResidenceAdmin(sender)) {
                    resadmin2 = true;
                }
                if (command2.getName().equals("resadmin") && !this.getPermissionManager().isResidenceAdmin(sender)) {
                    ((Player)sender).sendMessage(this.msg(lm.Residence_NonAdmin, new Object[0]));
                    return true;
                }
                if (command2.getName().equals("res") && this.getPermissionManager().isResidenceAdmin(sender) && this.getConfigManager().getAdminFullAccess()) {
                    resadmin2 = true;
                }
            } else {
                resadmin2 = true;
            }
            if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("?") || args.length > 1 && args[args.length - 2].equals("?")) {
                return this.commandHelp(args, resadmin2, sender, command2);
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            } else {
                resadmin2 = true;
            }
            if (this.getConfigManager().allowAdminsOnly() && !resadmin2 && player != null) {
                this.msg((CommandSender)player, lm.General_AdminOnly, new Object[0]);
                return true;
            }
            if (args.length == 0) {
                args = new String[]{"?"};
            }
            switch (cmd2 = args[0].toLowerCase()) {
                case "delete": {
                    cmd2 = "remove";
                    break;
                }
                case "sz": {
                    cmd2 = "subzone";
                }
            }
            cmd cmdClass = ResidenceCommandListener.getCmdClass(args);
            if (cmdClass == null) {
                return this.commandHelp(new String[]{"?"}, resadmin2, sender, command2);
            }
            if (!resadmin2 && !this.hasPermission(sender, "residence.command." + args[0].toLowerCase())) {
                return true;
            }
            if (!resadmin2 && player != null && this.resadminToggle.contains(player.getName()) && !this.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                this.resadminToggle.remove(player.getName());
            }
            if (!(respond = cmdClass.perform(ResidenceCommandListener.getInstance(), args, resadmin2, command2, sender))) {
                String[] tempArray = new String[args.length + 1];
                int i = 0;
                while (i < args.length) {
                    tempArray[i] = args[i];
                    ++i;
                }
                tempArray[args.length] = "?";
                args = tempArray;
                return this.commandHelp(args, resadmin2, sender, command2);
            }
            return true;
        }
        return this.onCommand(sender, command2, label, args);
    }

    private static cmd getCmdClass(String[] args) {
        cmd cmdClass = null;
        try {
            Class<?> nmsClass = Class.forName("com.bekvon.bukkit.residence.commands." + args[0].toLowerCase());
            if (cmd.class.isAssignableFrom(nmsClass)) {
                cmdClass = (cmd)nmsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return cmdClass;
    }

    public void sendUsage(CommandSender sender, String command2) {
        this.msg(sender, lm.General_DefaultUsage, command2);
    }

    private boolean commandHelp(String[] args, boolean resadmin2, CommandSender sender, Command command2) {
        if (this.getHelpPages() == null) {
            return false;
        }
        String helppath = this.getHelpPath(args);
        int page = 1;
        if (!args[args.length - 1].equalsIgnoreCase("?")) {
            try {
                page = Integer.parseInt(args[args.length - 1]);
            }
            catch (Exception ex) {
                this.msg(sender, lm.General_InvalidHelp, new Object[0]);
            }
        }
        if (command2.getName().equalsIgnoreCase("res")) {
            resadmin2 = false;
        }
        if (this.getHelpPages().containesEntry(helppath)) {
            this.getHelpPages().printHelp(sender, page, helppath, resadmin2);
        }
        return true;
    }

    private String getHelpPath(String[] args) {
        String helppath = "res";
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("?")) break;
            helppath = String.valueOf(helppath) + "." + args[i];
            ++i;
        }
        if (!this.getHelpPages().containesEntry(helppath) && args.length > 0) {
            return this.getHelpPath(Arrays.copyOf(args, args.length - 1));
        }
        return helppath;
    }
}

