/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Arrays;
import me.ryanhamshire.GriefPrevention.WordFinder;
import org.junit.Assert;
import org.junit.Test;

public class Tests {
    @Test
    public void TrivialTest() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void WordFinder_BeginningMiddleEnd() {
        WordFinder finder = new WordFinder(Arrays.asList("alpha", "beta", "gamma"));
        Assert.assertTrue((boolean)finder.hasMatch("alpha"));
        Assert.assertTrue((boolean)finder.hasMatch("alpha etc"));
        Assert.assertTrue((boolean)finder.hasMatch("etc alpha etc"));
        Assert.assertTrue((boolean)finder.hasMatch("etc alpha"));
        Assert.assertTrue((boolean)finder.hasMatch("beta"));
        Assert.assertTrue((boolean)finder.hasMatch("beta etc"));
        Assert.assertTrue((boolean)finder.hasMatch("etc beta etc"));
        Assert.assertTrue((boolean)finder.hasMatch("etc beta"));
        Assert.assertTrue((boolean)finder.hasMatch("gamma"));
        Assert.assertTrue((boolean)finder.hasMatch("gamma etc"));
        Assert.assertTrue((boolean)finder.hasMatch("etc gamma etc"));
        Assert.assertTrue((boolean)finder.hasMatch("etc gamma"));
    }

    @Test
    public void WordFinder_Casing() {
        WordFinder finder = new WordFinder(Arrays.asList("aLPhA"));
        Assert.assertTrue((boolean)finder.hasMatch("alpha"));
        Assert.assertTrue((boolean)finder.hasMatch("aLPhA"));
        Assert.assertTrue((boolean)finder.hasMatch("AlpHa"));
        Assert.assertTrue((boolean)finder.hasMatch("ALPHA"));
    }

    @Test
    public void WordFinder_Punctuation() {
        WordFinder finder = new WordFinder(Arrays.asList("alpha"));
        Assert.assertTrue((boolean)finder.hasMatch("What do you think,alpha?"));
    }

    @Test
    public void WordFinder_NoMatch() {
        WordFinder finder = new WordFinder(Arrays.asList("alpha"));
        Assert.assertFalse((boolean)finder.hasMatch("Unit testing is smart."));
    }

    @Test
    public void WordFinder_EmptyList() {
        WordFinder finder = new WordFinder(new ArrayList<String>());
        Assert.assertFalse((boolean)finder.hasMatch("alpha"));
    }

    @Test
    public void WordFinder_PunctuationOnly() {
        WordFinder finder = new WordFinder(Arrays.asList("alpha"));
        Assert.assertFalse((boolean)finder.hasMatch("!"));
        Assert.assertFalse((boolean)finder.hasMatch("?"));
    }

    @Test
    public void WordFinder_StartingPunctuation() {
        WordFinder finder = new WordFinder(Arrays.asList("alpha"));
        Assert.assertFalse((boolean)finder.hasMatch("!asas dfasdf"));
        Assert.assertFalse((boolean)finder.hasMatch("?asdfa sdfas df"));
    }
}

