/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.Collection;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class DeliverClaimBlocksTask
implements Runnable {
    private Player player;

    public DeliverClaimBlocksTask(Player player) {
        this.player = player;
    }

    @Override
    public void run() {
        if (this.player == null) {
            Collection players = GriefPrevention.instance.getServer().getOnlinePlayers();
            long i = 0L;
            for (Player onlinePlayer : players) {
                DeliverClaimBlocksTask newTask = new DeliverClaimBlocksTask(onlinePlayer);
                GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)newTask, i++);
            }
        } else {
            if (!this.player.isOnline()) {
                return;
            }
            DataStore dataStore = GriefPrevention.instance.dataStore;
            PlayerData playerData = dataStore.getPlayerData(this.player.getUniqueId());
            Location lastLocation = playerData.lastAfkCheckLocation;
            try {
                if (!(this.player.isInsideVehicle() || lastLocation != null && !(lastLocation.distanceSquared(this.player.getLocation()) >= 0.0) || this.player.getLocation().getBlock().isLiquid())) {
                    int accrualRate = GriefPrevention.instance.config_claims_blocksAccruedPerHour_default;
                    if (this.player.hasPermission("griefprevention.fastestaccrual")) {
                        accrualRate = GriefPrevention.instance.config_claims_blocksAccruedPerHour_fastest;
                    } else if (this.player.hasPermission("griefprevention.fasteraccrual")) {
                        accrualRate = GriefPrevention.instance.config_claims_blocksAccruedPerHour_faster;
                    }
                    int accruedBlocks = accrualRate / 6;
                    if (accruedBlocks < 0) {
                        accruedBlocks = 1;
                    }
                    playerData.accrueBlocks(accruedBlocks);
                    GriefPrevention.AddLogEntry("Delivering " + accruedBlocks + " blocks to " + this.player.getName(), CustomLogEntryTypes.Debug, true);
                } else {
                    GriefPrevention.AddLogEntry(String.valueOf(this.player.getName()) + " wasn't active enough to accrue claim blocks this round.", CustomLogEntryTypes.Debug, true);
                }
            }
            catch (IllegalArgumentException accrualRate) {
            }
            catch (Exception e) {
                GriefPrevention.AddLogEntry("Problem delivering claim blocks to player " + this.player.getName() + ":");
                e.printStackTrace();
            }
            playerData.lastAfkCheckLocation = this.player.getLocation();
        }
    }
}

