/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Witch;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class ResidenceEntityListener
implements Listener {
    Residence plugin;

    public ResidenceEntityListener(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onMinecartHopperItemMove(InventoryMoveItemEvent event) {
        if (!(event.getInitiator().getHolder() instanceof HopperMinecart)) {
            return;
        }
        HopperMinecart hopper = (HopperMinecart)event.getInitiator().getHolder();
        if (this.plugin.isDisabledWorldListener(hopper.getWorld())) {
            return;
        }
        Block block = hopper.getLocation().getBlock();
        switch (block.getType()) {
            case POWERED_RAIL: 
            case DETECTOR_RAIL: 
            case RAILS: 
            case ACTIVATOR_RAIL: {
                return;
            }
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEndermanChangeBlock(EntityChangeBlockEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (event.getEntityType() != EntityType.ENDERMAN) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.destroy, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent event) {
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(block.getWorld())) {
            return;
        }
        Material mat = block.getType();
        Entity entity = event.getEntity();
        FlagPermissions perms = this.plugin.getPermsByLoc(block.getLocation());
        boolean hastrample = perms.has(Flags.trample, perms.has(Flags.build, true));
        if (!(hastrample || entity.getType() == EntityType.FALLING_BLOCK || mat != Material.SOIL && mat != Material.SOUL_SAND)) {
            event.setCancelled(true);
        }
    }

    public static boolean isMonster(Entity ent) {
        return ent instanceof Monster || ent instanceof Slime || ent instanceof Ghast;
    }

    private static boolean isTamed(Entity ent) {
        return ent instanceof Tameable ? ((Tameable)ent).isTamed() : false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKilling(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(cause, Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, Flags.animalkilling.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKillingByFlame(EntityCombustByEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        Entity damager = event.getCombuster();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        if (res.getPermissions().playerHas(cause.getName(), Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, Flags.animalkilling.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalDamageByMobs(EntityDamageByEntityEvent event) {
        FlagPermissions world;
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player || damager instanceof Player) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(entity.getLocation());
        if (!perms.has(Flags.animalkilling, (world = this.plugin.getWorldFlags().getPerms(entity.getWorld().getName())).has(Flags.animalkilling, true))) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void OnEntityDeath(EntityDeathEvent event) {
        LivingEntity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (ent instanceof Player) {
            return;
        }
        Location loc = ent.getLocation();
        FlagPermissions perms = this.plugin.getPermsByLoc(loc);
        if (!perms.has(Flags.mobitemdrop, true)) {
            event.getDrops().clear();
        }
        if (!perms.has(Flags.mobexpdrop, true)) {
            event.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void VehicleDestroy(VehicleDestroyEvent event) {
        FlagPermissions perms;
        Entity damager = event.getAttacker();
        if (damager == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(damager.getWorld())) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle == null) {
            return;
        }
        if ((damager instanceof Projectile && !(((Projectile)damager).getShooter() instanceof Player) || !(damager instanceof Player)) && !(perms = this.plugin.getPermsByLoc(vehicle.getLocation())).has(Flags.vehicledestroy, true)) {
            event.setCancelled(true);
            return;
        }
        Player cause = null;
        if (damager instanceof Player) {
            cause = (Player)damager;
        } else if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) {
            cause = (Player)((Projectile)damager).getShooter();
        }
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(vehicle.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(cause.getName(), Flags.vehicledestroy, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, Flags.vehicledestroy.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void MonsterKilling(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!ResidenceEntityListener.isMonster(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(cause.getName(), Flags.mobkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, Flags.mobkilling.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalLeash(PlayerLeashEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(player.getName(), Flags.leash, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.leash, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onWitherSpawn(CreatureSpawnEvent event) {
        LivingEntity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (ent.getType() != EntityType.WITHER) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getLocation());
        if (perms.has(Flags.witherspawn, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        block20: {
            FlagPermissions perms;
            LivingEntity ent;
            block19: {
                ent = event.getEntity();
                if (ent == null) {
                    return;
                }
                if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
                    return;
                }
                perms = this.plugin.getPermsByLoc(event.getLocation());
                if (!this.plugin.getNms().isAnimal((Entity)ent)) break block19;
                if (!perms.has(Flags.animals, true)) {
                    event.setCancelled(true);
                    return;
                }
                switch (event.getSpawnReason()) {
                    case BUILD_WITHER: {
                        break;
                    }
                    case BUILD_SNOWMAN: 
                    case BUILD_IRONGOLEM: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (perms.has(Flags.canimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case EGG: 
                    case VILLAGE_DEFENSE: 
                    case VILLAGE_INVASION: 
                    case BREEDING: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case CURED: 
                    case OCELOT_BABY: 
                    case MOUNT: {
                        if (perms.has(Flags.nanimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (perms.has(Flags.sanimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (ResidenceEntityListener.isMonster((Entity)ent)) {
                if (perms.has(Flags.monsters, FlagPermissions.FlagCombo.OnlyFalse)) {
                    event.setCancelled(true);
                    return;
                }
                switch (event.getSpawnReason()) {
                    case BUILD_WITHER: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (!perms.has(Flags.cmonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        event.setCancelled(true);
                        return;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case LIGHTNING: 
                    case SLIME_SPLIT: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case INFECTION: 
                    case CURED: 
                    case SILVERFISH_BLOCK: 
                    case MOUNT: {
                        if (!perms.has(Flags.nmonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        event.setCancelled(true);
                        return;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (!perms.has(Flags.smonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        String world;
        String pname;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(player.getWorld())) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(event.getEntity().getLocation(), player);
        if (!perms.playerHas(pname = player.getName(), world = player.getWorld().getName(), Flags.place, perms.playerHas(pname, world, Flags.build, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.place});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        String world;
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getRemover();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        if (this.plugin.getResidenceManager().isOwnerOfLocation(player, ent.getLocation())) {
            return;
        }
        String pname = player.getName();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(ent.getLocation(), player);
        if (!perms.playerHas(pname, world = ent.getWorld().getName(), Flags.destroy, perms.playerHas(pname, world, Flags.build, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (event.getRemover() instanceof Player) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        if (!perms.has(Flags.destroy, perms.has(Flags.build, true))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Entity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        if (!perms.has(Flags.burn, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        Entity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        EntityType entity = event.getEntityType();
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        switch (entity) {
            case CREEPER: {
                if (perms.has(Flags.creeper, perms.has(Flags.explode, true))) break;
                if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                        event.setCancelled(true);
                        ent.remove();
                        break;
                    }
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    event.setCancelled(true);
                    ent.remove();
                    break;
                }
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case PRIMED_TNT: 
            case MINECART_TNT: {
                if (perms.has(Flags.tnt, perms.has(Flags.explode, true))) break;
                if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                        event.setCancelled(true);
                        ent.remove();
                        break;
                    }
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    event.setCancelled(true);
                    ent.remove();
                    break;
                }
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                if (!perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) break;
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case WITHER_SKULL: 
            case WITHER: {
                if (!perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !perms.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) break;
                event.setCancelled(true);
                ent.remove();
                break;
            }
            default: {
                if (!perms.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) break;
                event.setCancelled(true);
                ent.remove();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        FlagPermissions world;
        FlagPermissions perms;
        Boolean cancel;
        Entity ent;
        block39: {
            block40: {
                Location loc = event.getLocation();
                if (this.plugin.isDisabledWorldListener(loc.getWorld())) {
                    return;
                }
                if (event.isCancelled()) {
                    return;
                }
                ent = event.getEntity();
                cancel = false;
                perms = this.plugin.getPermsByLoc(loc);
                world = this.plugin.getWorldFlags().getPerms(loc.getWorld().getName());
                if (ent == null) break block40;
                switch (event.getEntityType()) {
                    case CREEPER: {
                        ClaimedResidence res;
                        if (!perms.has(Flags.creeper, perms.has(Flags.explode, true))) {
                            if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                                if (loc.getBlockY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                                    cancel = true;
                                    break;
                                }
                                res = this.plugin.getResidenceManager().getByLoc(loc);
                                if (res != null) {
                                    cancel = true;
                                    break;
                                }
                                break block39;
                            } else {
                                cancel = true;
                                break;
                            }
                        }
                        break block39;
                    }
                    case PRIMED_TNT: 
                    case MINECART_TNT: {
                        ClaimedResidence res;
                        if (!perms.has(Flags.tnt, perms.has(Flags.explode, true))) {
                            if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                                if (loc.getBlockY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                                    cancel = true;
                                    break;
                                }
                                res = this.plugin.getResidenceManager().getByLoc(loc);
                                if (res != null) {
                                    cancel = true;
                                    break;
                                }
                                break block39;
                            } else {
                                cancel = true;
                                break;
                            }
                        }
                        break block39;
                    }
                    case FIREBALL: 
                    case SMALL_FIREBALL: {
                        if (perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) || perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) {
                            cancel = true;
                            break;
                        }
                        break block39;
                    }
                    case WITHER_SKULL: 
                    case WITHER: {
                        if (perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) || perms.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) {
                            cancel = true;
                            break;
                        }
                        break block39;
                    }
                    default: {
                        if (!perms.has(Flags.destroy, world.has(Flags.destroy, true))) {
                            cancel = true;
                            break;
                        }
                        break block39;
                    }
                }
                break block39;
            }
            if (!perms.has(Flags.destroy, world.has(Flags.destroy, true))) {
                cancel = true;
            }
        }
        if (cancel.booleanValue()) {
            event.setCancelled(true);
            if (ent != null) {
                ent.remove();
            }
            return;
        }
        ArrayList<Block> preserve = new ArrayList<Block>();
        block14: for (Block block : event.blockList()) {
            FlagPermissions blockperms = this.plugin.getPermsByLoc(block.getLocation());
            if (ent != null) {
                switch (event.getEntityType()) {
                    case CREEPER: {
                        ClaimedResidence res;
                        if (blockperms.has(Flags.creeper, blockperms.has(Flags.explode, true))) continue block14;
                        if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                            if (block.getY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                                preserve.add(block);
                                break;
                            }
                            res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (res == null) continue block14;
                            preserve.add(block);
                            break;
                        }
                        preserve.add(block);
                        break;
                    }
                    case PRIMED_TNT: 
                    case MINECART_TNT: {
                        ClaimedResidence res;
                        if (blockperms.has(Flags.tnt, blockperms.has(Flags.explode, true))) continue block14;
                        if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                            if (block.getY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                                preserve.add(block);
                                break;
                            }
                            res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (res == null) continue block14;
                            preserve.add(block);
                            break;
                        }
                        preserve.add(block);
                        break;
                    }
                    case ENDER_DRAGON: {
                        if (blockperms.has(Flags.dragongrief, false)) continue block14;
                        preserve.add(block);
                        break;
                    }
                    case ENDER_CRYSTAL: {
                        if (!blockperms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) continue block14;
                        preserve.add(block);
                        break;
                    }
                    case FIREBALL: 
                    case SMALL_FIREBALL: {
                        if (!blockperms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) continue block14;
                        preserve.add(block);
                        break;
                    }
                    case WITHER_SKULL: 
                    case WITHER: {
                        if (!blockperms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !blockperms.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) continue block14;
                        preserve.add(block);
                        break;
                    }
                    default: {
                        if (!blockperms.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) continue block14;
                        preserve.add(block);
                        break;
                    }
                }
                continue;
            }
            if (blockperms.has(Flags.destroy, world.has(Flags.destroy, true))) continue;
            preserve.add(block);
        }
        for (Block block : preserve) {
            event.blockList().remove(block);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSplashPotion(EntityChangeBlockEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent.getType() != EntityType.WITHER) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSplashPotion(PotionSplashEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        ProjectileSource shooter = event.getPotion().getShooter();
        if (shooter instanceof Witch) {
            return;
        }
        boolean harmfull = false;
        block0: for (PotionEffect one : event.getPotion().getEffects()) {
            for (String oneHarm : this.plugin.getConfigManager().getNegativePotionEffects()) {
                if (!oneHarm.equalsIgnoreCase(one.getType().getName())) continue;
                harmfull = true;
                break block0;
            }
        }
        if (!harmfull) {
            return;
        }
        ThrownPotion ent = event.getEntity();
        boolean srcpvp = this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        for (LivingEntity target : event.getAffectedEntities()) {
            if (target.getType() != EntityType.PLAYER) continue;
            Boolean tgtpvp = this.plugin.getPermsByLoc(target.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
            if (srcpvp && tgtpvp.booleanValue()) continue;
            event.setIntensity(target, 0.0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PlayerKillingByFlame(EntityCombustByEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        Entity damager = event.getCombuster();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        Boolean srcpvp = this.plugin.getPermsByLoc(cause.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        Boolean tgtpvp = this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        if (!srcpvp.booleanValue() || !tgtpvp.booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void OnFallDamage(EntityDamageEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity ent = event.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.falldamage, FlagPermissions.FlagCombo.TrueOrNone)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void OnArmorStandFlameDamage(EntityDamageEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) {
            return;
        }
        Entity ent = event.getEntity();
        if (!this.plugin.getNms().isArmorStandEntity(ent.getType()) && !(ent instanceof Arrow)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.destroy, true)) {
            event.setCancelled(true);
            ent.setFireTicks(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockCatchingFire(ProjectileHitEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getEntity() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)event.getEntity();
        FlagPermissions perms = this.plugin.getPermsByLoc(arrow.getLocation());
        if (!perms.has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
            arrow.setFireTicks(0);
        }
    }

    @EventHandler
    public void OnPlayerDamageByLightning(EntityDamageEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.LIGHTNING) {
            return;
        }
        Entity ent = event.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByFireballEvent(EntityDamageByEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity dmgr = event.getDamager();
        if (dmgr.getType() != EntityType.SMALL_FIREBALL && dmgr.getType() != EntityType.FIREBALL) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getEntity().getLocation());
        if (perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByWitherEvent(EntityDamageByEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity dmgr = event.getDamager();
        if (dmgr.getType() != EntityType.WITHER && dmgr.getType() != EntityType.WITHER_SKULL) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getEntity().getLocation());
        if (perms.has(Flags.witherdamage, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        ItemFrame it;
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntityType() != EntityType.ENDER_CRYSTAL && event.getEntityType() != EntityType.ITEM_FRAME && !this.plugin.getNms().isArmorStandEntity(event.getEntityType())) {
            return;
        }
        Entity dmgr = event.getDamager();
        Player player = null;
        if (dmgr instanceof Player) {
            player = (Player)event.getDamager();
        } else if (dmgr instanceof Projectile && ((Projectile)dmgr).getShooter() instanceof Player) {
            player = (Player)((Projectile)dmgr).getShooter();
        } else {
            FlagPermissions perms;
            if (dmgr instanceof Projectile && !(((Projectile)dmgr).getShooter() instanceof Player)) {
                Location loc = event.getEntity().getLocation();
                FlagPermissions perm = this.plugin.getPermsByLoc(loc);
                if (perm.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) {
                    event.setCancelled(true);
                }
                return;
            }
            if (dmgr.getType() == EntityType.PRIMED_TNT || dmgr.getType() == EntityType.MINECART_TNT) {
                perms = this.plugin.getPermsByLoc(event.getEntity().getLocation());
                if (perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) {
                    event.setCancelled(true);
                    return;
                }
            } else if ((dmgr.getType() == EntityType.WITHER_SKULL || dmgr.getType() == EntityType.WITHER) && (perms = this.plugin.getPermsByLoc(event.getEntity().getLocation())).has(Flags.witherdamage, FlagPermissions.FlagCombo.OnlyFalse)) {
                event.setCancelled(true);
                return;
            }
        }
        Location loc = event.getEntity().getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (ResidenceEntityListener.isMonster(dmgr) && !res.getPermissions().has(Flags.destroy, false)) {
            event.setCancelled(true);
            return;
        }
        if (player == null) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(loc, player);
        if (event.getEntityType() == EntityType.ITEM_FRAME && (it = (ItemFrame)event.getEntity()).getItem() != null) {
            if (!perms.playerHas(player, Flags.container, true)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
            }
            return;
        }
        if (!perms.playerHas(player, Flags.destroy, perms.playerHas(player, Flags.build, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.destroy.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent.hasMetadata("NPC")) {
            return;
        }
        boolean tamedAnimal = ResidenceEntityListener.isTamed(ent);
        ClaimedResidence area2 = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent attackevent = (EntityDamageByEntityEvent)event;
            Entity damager = attackevent.getDamager();
            if (area2 != null && ent instanceof Player && damager instanceof Player && (area2.getPermissions().has(Flags.overridepvp, false) || this.plugin.getConfigManager().isOverridePvp() && area2.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.OnlyFalse, false))) {
                Player player;
                Player damage = player = (Player)event.getEntity();
                damage.damage(event.getDamage());
                damage.setVelocity(damager.getLocation().getDirection());
                event.setCancelled(true);
                return;
            }
            ClaimedResidence srcarea = null;
            if (damager != null) {
                srcarea = this.plugin.getResidenceManager().getByLoc(damager.getLocation());
            }
            boolean srcpvp = true;
            boolean allowSnowBall = false;
            boolean isSnowBall = false;
            boolean isOnFire = false;
            if (srcarea != null) {
                srcpvp = srcarea.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone, false);
            }
            if (((ent = attackevent.getEntity()) instanceof Player || tamedAnimal) && (damager instanceof Player || damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) && event.getCause() != EntityDamageEvent.DamageCause.FALL) {
                Player attacker = null;
                if (damager instanceof Player) {
                    attacker = (Player)damager;
                } else if (damager instanceof Projectile) {
                    Projectile project = (Projectile)damager;
                    if (project.getType() == EntityType.SNOWBALL && srcarea != null) {
                        isSnowBall = true;
                        allowSnowBall = srcarea.getPermissions().has(Flags.snowball, FlagPermissions.FlagCombo.TrueOrNone);
                    }
                    if (project.getFireTicks() > 0) {
                        isOnFire = true;
                    }
                    attacker = (Player)((Projectile)damager).getShooter();
                }
                if (!(ent instanceof Player)) {
                    return;
                }
                if (!srcpvp && !isSnowBall || !allowSnowBall && isSnowBall) {
                    if (attacker != null) {
                        this.plugin.msg((CommandSender)attacker, lm.General_NoPVPZone, new Object[0]);
                    }
                    if (isOnFire) {
                        ent.setFireTicks(0);
                    }
                    event.setCancelled(true);
                    return;
                }
                if (area2 == null) {
                    FlagPermissions aPerm;
                    if (damager != null && !this.plugin.getWorldFlags().getPerms(damager.getWorld().getName()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                        if (attacker != null) {
                            this.plugin.msg((CommandSender)attacker, lm.General_WorldPVPDisabled, new Object[0]);
                        }
                        if (isOnFire) {
                            ent.setFireTicks(0);
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (attacker != null && !(aPerm = this.plugin.getPermsByLoc(attacker.getLocation())).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                        this.plugin.msg((CommandSender)attacker, lm.General_NoPVPZone, new Object[0]);
                        if (isOnFire) {
                            ent.setFireTicks(0);
                        }
                        event.setCancelled(true);
                        return;
                    }
                } else if (!isSnowBall && !area2.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone, false) || isSnowBall && !allowSnowBall) {
                    if (attacker != null) {
                        this.plugin.msg((CommandSender)attacker, lm.General_NoPVPZone, new Object[0]);
                    }
                    if (isOnFire) {
                        ent.setFireTicks(0);
                    }
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if ((ent instanceof Player || tamedAnimal) && damager instanceof Creeper) {
                if (area2 == null && !this.plugin.getWorldFlags().getPerms(damager.getWorld().getName()).has(Flags.creeper, true)) {
                    event.setCancelled(true);
                } else if (area2 != null && !area2.getPermissions().has(Flags.creeper, true)) {
                    event.setCancelled(true);
                }
            }
        }
        if (area2 == null) {
            if (!this.plugin.getWorldFlags().getPerms(ent.getWorld().getName()).has(Flags.damage, true) && (ent instanceof Player || tamedAnimal)) {
                event.setCancelled(true);
            }
        } else if (!area2.getPermissions().has(Flags.damage, true) && (ent instanceof Player || tamedAnimal)) {
            event.setCancelled(true);
        }
        if (event.isCancelled() && (ent instanceof Player || tamedAnimal) && (event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
            ent.setFireTicks(0);
        }
    }
}

