/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ResidencePlayer {
    private String userName = null;
    private Player player = null;
    private OfflinePlayer ofPlayer = null;
    private UUID uuid = null;
    private Map<String, ClaimedResidence> ResidenceList = new HashMap<String, ClaimedResidence>();
    private ClaimedResidence mainResidence = null;
    private PermissionGroup group = null;
    private int maxRes = -1;
    private int maxRents = -1;
    private int maxSubzones = -1;
    private int maxSubzoneDepth = -1;

    public ResidencePlayer(Player player) {
        if (player == null) {
            return;
        }
        Residence.getInstance().getOfflinePlayerMap().put(player.getName(), (OfflinePlayer)player);
        Residence.getInstance().addCachedPlayerNameUUIDs(player.getUniqueId(), player.getName());
        this.updatePlayer(player);
        this.RecalculatePermissions();
    }

    public ResidencePlayer(String userName) {
        this.userName = userName;
        this.updatePlayer();
        this.RecalculatePermissions();
    }

    public void setMainResidence(ClaimedResidence res) {
        if (this.mainResidence != null) {
            this.mainResidence.setMainResidence(false);
        }
        this.mainResidence = res;
    }

    public ClaimedResidence getMainResidence() {
        if (this.mainResidence == null) {
            for (Map.Entry<String, ClaimedResidence> entry : this.ResidenceList.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().isMainResidence()) continue;
                this.mainResidence = entry.getValue();
                return this.mainResidence;
            }
            for (String string : Residence.getInstance().getRentManager().getRentedLands(this.userName)) {
                ClaimedResidence res = Residence.getInstance().getResidenceManager().getByName(string);
                if (res == null) continue;
                this.mainResidence = res;
                return this.mainResidence;
            }
            for (Map.Entry entry : this.ResidenceList.entrySet()) {
                if (entry.getValue() == null) continue;
                this.mainResidence = (ClaimedResidence)entry.getValue();
                return this.mainResidence;
            }
        }
        return this.mainResidence;
    }

    public void RecalculatePermissions() {
        this.getGroup();
        this.recountMaxRes();
        this.recountMaxRents();
        this.recountMaxSubzones();
    }

    public void recountMaxRes() {
        if (this.group != null) {
            this.maxRes = this.group.getMaxZones();
        }
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxResCount()) {
            if (this.player != null && this.player.isOnline()) {
                if (this.player.hasPermission("residence.max.res." + i)) {
                    this.maxRes = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, "residence.max.res." + i, Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxRes = i;
            }
            ++i;
        }
    }

    public void recountMaxRents() {
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxRentCount()) {
            if (this.player != null) {
                if (this.player.isPermissionSet("residence.max.rents." + i)) {
                    this.maxRents = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, "residence.max.rents." + i, Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxRents = i;
            }
            ++i;
        }
        int m = this.getGroup().getMaxRents();
        if (this.maxRents < m) {
            this.maxRents = m;
        }
    }

    public int getMaxRents() {
        this.recountMaxRents();
        return this.maxRents;
    }

    public void recountMaxSubzones() {
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxSubzonesCount()) {
            if (this.player != null) {
                if (this.player.isPermissionSet("residence.max.subzones." + i)) {
                    this.maxSubzones = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, "residence.max.subzones." + i, Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxSubzones = i;
            }
            ++i;
        }
        int m = this.getGroup().getMaxSubzones();
        if (this.maxSubzones < m) {
            this.maxSubzones = m;
        }
    }

    public int getMaxSubzones() {
        this.recountMaxSubzones();
        return this.maxSubzones;
    }

    public void recountMaxSubzoneDepth() {
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxSubzoneDepthCount()) {
            if (this.player != null) {
                if (this.player.isPermissionSet("residence.max.subzonedepth." + i)) {
                    this.maxSubzoneDepth = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, "residence.max.subzonedepth." + i, Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxSubzoneDepth = i;
            }
            ++i;
        }
        int m = this.getGroup().getMaxSubzoneDepth();
        if (this.maxSubzoneDepth < m) {
            this.maxSubzoneDepth = m;
        }
    }

    public int getMaxSubzoneDepth() {
        this.recountMaxSubzoneDepth();
        return this.maxSubzoneDepth;
    }

    public int getMaxRes() {
        Residence.getInstance().getPermissionManager().updateGroupNameForPlayer(this.userName, this.player != null && this.player.isOnline() ? this.player.getPlayer().getLocation().getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld(), true);
        this.recountMaxRes();
        PermissionGroup g = this.getGroup();
        if (this.maxRes < g.getMaxZones()) {
            return g.getMaxZones();
        }
        return this.maxRes;
    }

    public PermissionGroup getGroup() {
        return this.getGroup(this.player != null ? this.player.getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld());
    }

    public PermissionGroup getGroup(String world) {
        String gp = Residence.getInstance().getPermissionManager().getGroupNameByPlayer(this.userName, world);
        this.group = Residence.getInstance().getPermissionManager().getGroupByName(gp);
        return this.group;
    }

    public void recountRes() {
        if (this.userName != null) {
            ResidenceManager m = Residence.getInstance().getResidenceManager();
            this.ResidenceList = m.getResidenceMapList(this.userName, true);
        }
    }

    public ResidencePlayer updatePlayer(Player player) {
        this.player = player;
        this.uuid = player.getUniqueId();
        this.userName = player.getName();
        this.ofPlayer = player;
        return this;
    }

    private void updatePlayer() {
        if (this.player != null && this.player.isOnline()) {
            return;
        }
        if (this.uuid != null && Bukkit.getPlayer((UUID)this.uuid) != null) {
            this.player = Bukkit.getPlayer((UUID)this.uuid);
            this.userName = this.player.getName();
            return;
        }
        if (this.userName != null) {
            this.player = Bukkit.getPlayer((String)this.userName);
        }
        if (this.player != null) {
            this.userName = this.player.getName();
            this.uuid = this.player.getUniqueId();
            this.ofPlayer = this.player;
            return;
        }
        if (this.player == null && this.ofPlayer == null) {
            this.ofPlayer = Residence.getInstance().getOfflinePlayer(this.userName);
        }
        if (this.ofPlayer != null) {
            this.userName = this.ofPlayer.getName();
            this.uuid = this.ofPlayer.getUniqueId();
            return;
        }
    }

    public void addResidence(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        this.ResidenceList.put(residence.getName().toLowerCase(), residence);
    }

    public void removeResidence(String residence) {
        if (residence == null) {
            return;
        }
        residence = residence.toLowerCase();
        this.ResidenceList.remove(residence);
    }

    public void renameResidence(String oldResidence, String newResidence) {
        if (oldResidence == null) {
            return;
        }
        if (newResidence == null) {
            return;
        }
        ClaimedResidence res = this.ResidenceList.get(oldResidence = oldResidence.toLowerCase());
        if (res != null) {
            this.removeResidence(oldResidence);
            this.ResidenceList.put(newResidence.toLowerCase(), res);
        }
    }

    public int getResAmount() {
        return this.ResidenceList.size();
    }

    public List<ClaimedResidence> getResList() {
        ArrayList<ClaimedResidence> temp = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> one : this.ResidenceList.entrySet()) {
            temp.add(one.getValue());
        }
        return temp;
    }

    public Map<String, ClaimedResidence> getResidenceMap() {
        return this.ResidenceList;
    }
}

