/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.SiegeData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class SiegeCheckupTask
implements Runnable {
    private SiegeData siegeData;

    public SiegeCheckupTask(SiegeData siegeData) {
        this.siegeData = siegeData;
    }

    @Override
    public void run() {
        DataStore dataStore = GriefPrevention.instance.dataStore;
        Player defender = this.siegeData.defender;
        Player attacker = this.siegeData.attacker;
        Claim defenderClaim = dataStore.getClaimAt(defender.getLocation(), false, null);
        if (defenderClaim != null) {
            String noAccessReason = defenderClaim.allowAccess(defender);
            if (defenderClaim.canSiege(defender) && noAccessReason == null) {
                this.siegeData.claims.add(defenderClaim);
                defenderClaim.siegeData = this.siegeData;
            }
        }
        boolean attackerRemains = this.playerRemains(attacker);
        boolean defenderRemains = this.playerRemains(defender);
        if (attackerRemains && defenderRemains) {
            this.scheduleAnotherCheck();
        } else if (attackerRemains && !defenderRemains) {
            dataStore.endSiege(this.siegeData, attacker.getName(), defender.getName(), null);
        } else if (!attackerRemains && defenderRemains) {
            dataStore.endSiege(this.siegeData, defender.getName(), attacker.getName(), null);
        } else if (attacker.getWorld().equals(defender.getWorld()) && attacker.getLocation().distanceSquared(defender.getLocation()) < 2500.0) {
            this.scheduleAnotherCheck();
        } else {
            dataStore.endSiege(this.siegeData, attacker.getName(), defender.getName(), null);
        }
    }

    private boolean playerRemains(Player player) {
        int i = 0;
        while (i < this.siegeData.claims.size()) {
            Claim claim = this.siegeData.claims.get(i);
            if (claim.isNear(player.getLocation(), 25)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void scheduleAnotherCheck() {
        this.siegeData.checkupTaskID = GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)this, 600L);
    }
}

