/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ConfigReader;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class rc
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=1100)
    public boolean perform(Residence plugin, String[] args, boolean resadmin2, Command command2, CommandSender sender) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        String pname = player.getName();
        if (!plugin.getConfigManager().chatEnabled()) {
            plugin.msg((CommandSender)player, lm.Residence_ChatDisabled, new Object[0]);
            return false;
        }
        if (args.length > 0) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length == 0) {
            ClaimedResidence res = plugin.getResidenceManager().getByLoc(player.getLocation());
            if (res == null) {
                ChatChannel chat = plugin.getChatManager().getPlayerChannel(pname);
                if (chat != null) {
                    plugin.getChatManager().removeFromChannel(pname);
                    plugin.getPlayerListener().removePlayerResidenceChat(player);
                    return true;
                }
                plugin.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                return true;
            }
            ChatChannel chat = plugin.getChatManager().getPlayerChannel(pname);
            if (chat != null && chat.getChannelName().equals(res.getName())) {
                plugin.getChatManager().removeFromChannel(pname);
                plugin.getPlayerListener().removePlayerResidenceChat(player);
                return true;
            }
            if (!res.getPermissions().playerHas(player.getName(), Flags.chat, true) && !plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.chat, res.getName()});
                return false;
            }
            plugin.getPlayerListener().tooglePlayerResidenceChat(player, res.getName());
            plugin.getChatManager().setChannel(pname, res);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("l") || args[0].equalsIgnoreCase("leave")) {
                plugin.getChatManager().removeFromChannel(pname);
                plugin.getPlayerListener().removePlayerResidenceChat(player);
                return true;
            }
            ClaimedResidence res = plugin.getResidenceManager().getByName(args[0]);
            if (res == null) {
                plugin.msg((CommandSender)player, lm.Chat_InvalidChannel, new Object[0]);
                return true;
            }
            if (!res.getPermissions().playerHas(player.getName(), Flags.chat, true) && !plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.chat.getName(), res.getName());
                return false;
            }
            plugin.getPlayerListener().tooglePlayerResidenceChat(player, res.getName());
            plugin.getChatManager().setChannel(pname, res);
            return true;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("setcolor")) {
                ChatChannel chat = plugin.getChatManager().getPlayerChannel(pname);
                if (chat == null) {
                    plugin.msg((CommandSender)player, lm.Chat_JoinFirst, new Object[0]);
                    return true;
                }
                ClaimedResidence res = plugin.getResidenceManager().getByName(chat.getChannelName());
                if (res == null) {
                    return false;
                }
                if (!res.isOwner(player) && !plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                    plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (!plugin.hasPermission((CommandSender)player, "residence.chatcolor")) {
                    return true;
                }
                String posibleColor = args[1];
                if (!posibleColor.contains("&")) {
                    posibleColor = "&" + posibleColor;
                }
                if (posibleColor.length() != 2 || ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)posibleColor)).length() != 0) {
                    plugin.msg((CommandSender)player, lm.Chat_InvalidColor, new Object[0]);
                    return true;
                }
                ChatColor color = ChatColor.getByChar((String)posibleColor.replace("&", ""));
                res.setChannelColor(color);
                chat.setChannelColor(color);
                plugin.msg((CommandSender)player, lm.Chat_ChangedColor, color.name());
                return true;
            }
            if (args[0].equalsIgnoreCase("setprefix")) {
                ChatChannel chat = plugin.getChatManager().getPlayerChannel(pname);
                if (chat == null) {
                    plugin.msg((CommandSender)player, lm.Chat_JoinFirst, new Object[0]);
                    return true;
                }
                ClaimedResidence res = plugin.getResidenceManager().getByName(chat.getChannelName());
                if (res == null) {
                    return false;
                }
                if (!res.isOwner(player) && !plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                    plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (!plugin.hasPermission((CommandSender)player, "residence.chatprefix")) {
                    return true;
                }
                String prefix = args[1];
                if (prefix.length() > plugin.getConfigManager().getChatPrefixLength()) {
                    plugin.msg((CommandSender)player, lm.Chat_InvalidPrefixLength, plugin.getConfigManager().getChatPrefixLength());
                    return true;
                }
                res.setChatPrefix(prefix);
                chat.setChatPrefix(prefix);
                plugin.msg((CommandSender)player, lm.Chat_ChangedPrefix, ChatColor.translateAlternateColorCodes((char)'&', (String)prefix));
                return true;
            }
            if (args[0].equalsIgnoreCase("kick")) {
                ChatChannel chat = plugin.getChatManager().getPlayerChannel(pname);
                if (chat == null) {
                    plugin.msg((CommandSender)player, lm.Chat_JoinFirst, new Object[0]);
                    return true;
                }
                ClaimedResidence res = plugin.getResidenceManager().getByName(chat.getChannelName());
                if (res == null) {
                    return false;
                }
                if (!res.getOwner().equals(player.getName()) && !plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                    plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (!plugin.hasPermission((CommandSender)player, "residence.chatkick")) {
                    return true;
                }
                String targetName = args[1];
                if (!chat.hasMember(targetName)) {
                    plugin.msg((CommandSender)player, lm.Chat_NotInChannel, new Object[0]);
                    return false;
                }
                chat.leave(targetName);
                plugin.getPlayerListener().removePlayerResidenceChat(targetName);
                plugin.msg((CommandSender)player, lm.Chat_Kicked, targetName, chat.getChannelName());
                return true;
            }
        }
        return true;
    }

    @Override
    public void getLocale(ConfigReader c, String path) {
        c.get(String.valueOf(path) + "Description", "Joins current or defined residence chat channel");
        c.get(String.valueOf(path) + "Info", Arrays.asList("&eUsage: &6/res rc (residence)", "Join residence chat channel."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("[residence]"));
        path = String.valueOf(path) + "SubCommands.";
        c.get(String.valueOf(path) + "leave.Description", "Leaves current residence chat channel");
        c.get(String.valueOf(path) + "leave.Info", Arrays.asList("&eUsage: &6/res rc leave", "If you are in residence chat channel then you will leave it"));
        c.get(String.valueOf(path) + "setcolor.Description", "Sets residence chat channel text color");
        c.get(String.valueOf(path) + "setcolor.Info", Arrays.asList("&eUsage: &6/res rc setcolor [colorCode]", "Sets residence chat channel text color"));
        c.get(String.valueOf(path) + "setprefix.Description", "Sets residence chat channel prefix");
        c.get(String.valueOf(path) + "setprefix.Info", Arrays.asList("&eUsage: &6/res rc setprefix [newName]", "Sets residence chat channel prefix"));
        c.get(String.valueOf(path) + "kick.Description", "Kicks player from channel");
        c.get(String.valueOf(path) + "kick.Info", Arrays.asList("&eUsage: &6/res rc kick [player]", "Kicks player from channel"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "kick"), Arrays.asList("[playername]"));
    }
}

