/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;

class IgnoreLoaderThread
extends Thread {
    private UUID playerToLoad;
    private ConcurrentHashMap<UUID, Boolean> destinationMap;

    IgnoreLoaderThread(UUID playerToLoad, ConcurrentHashMap<UUID, Boolean> destinationMap) {
        this.playerToLoad = playerToLoad;
        this.destinationMap = destinationMap;
        this.setPriority(1);
    }

    @Override
    public void run() {
        File ignoreFile = new File(String.valueOf(DataStore.playerDataFolderPath) + File.separator + this.playerToLoad + ".ignore");
        if (!ignoreFile.exists()) {
            return;
        }
        boolean needRetry = false;
        int retriesRemaining = 5;
        Exception latestException = null;
        do {
            try {
                needRetry = false;
                List lines = Files.readLines((File)ignoreFile, (Charset)Charset.forName("UTF-8"));
                for (String line : lines) {
                    boolean adminIgnore = false;
                    if (line.startsWith("*")) {
                        adminIgnore = true;
                        line = line.substring(1);
                    }
                    try {
                        UUID ignoredUUID = UUID.fromString(line);
                        this.destinationMap.put(ignoredUUID, adminIgnore);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                latestException = e;
                needRetry = true;
                --retriesRemaining;
            }
            try {
                if (!needRetry) continue;
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (needRetry && retriesRemaining >= 0);
        if (needRetry) {
            GriefPrevention.AddLogEntry("Retry attempts exhausted.  Unable to load ignore data for player \"" + this.playerToLoad.toString() + "\": " + latestException.toString());
            latestException.printStackTrace();
        }
    }
}

